'use strict';

define(function() {
  var eventLinked = function(
      AncAppFactory,
      BacAppFactory,
      CalendarFactory,
      UsersFactory,
      $filter,
      $rootScope,
      $timeout,
      gaDomUtils,
      ngDialog,
      gaJsUtils,
      kisCalendarFactory
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/event_linked.html',
      scope: {
        openDialogUsers: '&?',
        actionPriseRdv: '&?',
        linkedobjects: '=?',
      },
      restrict: 'E',
      link: function(scope, element, attr) {

        scope.length_events = false;
        scope.disabled = false;
        scope.openControleAcceptsRDV = false;

        scope.currentRDVControles = [];
        scope.expanded = [];

        scope.appType = $rootScope.xgos.sector;

        var CurrentAppFactory = $rootScope.xgos.sector == 'bac' ? BacAppFactory : AncAppFactory;

        scope.getEventsAncRDV = function(){
          const where = "created_by='" + $rootScope.xgos.user.login + "'";

          CurrentAppFactory.getActifsControles(scope.linkedobjects).then(function(res) {
            if(
                res.data !== undefined && res.data.features !== undefined
                && res.data.features.length > 0
            ){
              scope.openControleAcceptsRDV = true;
            }
          })
          .catch(err => {
            err.stack;
          });

          UsersFactory.getactiveuserslight().then(function(res) {
            let usersArray = [];
            if(res.data !== undefined){
              usersArray = res.data;

              CurrentAppFactory.getcontroles(scope.linkedobjects).then(function(res) {

                if(res.data.features !== undefined){

                  scope.length_events = true;

                  if(res.data.features.length > 0){
                    // order controles
                    let controles = res.data.features;
                    controles.sort(function(a, b) {
                      let x = parseInt(a['id'].split('.')[1]);
                      let y = parseInt(b['id'].split('.')[1]);
                      return ((x < y) ? -1 : ((x > y) ? 1 : 0));
                    });

                    for(let i = 0; i < controles.length; i++){
                      controles[i].ctrlLabel = CurrentAppFactory.getControleName(
                          controles[i].properties.type,
                          controles[i].properties.date_passage
                      );

                      if(i == 0){
                        scope.expanded[i] = true;
                      } else {
                        scope.expanded[i] = false;
                      }
                      controles[i].eventsRDV = [];

                      $timeout(function(){

                        CalendarFactory.getevents(where, '', '','', controles[i].id).then(function(res){
                            if (
                                res.data != undefined &&
                                res.data.features !== undefined
                            ) {

                              controles[i].eventsRDV = res.data.features;

                              for (let property in res.data) {
                                for(let j = 0; j < controles[i].eventsRDV.length; j++){
                                  if(controles[i].eventsRDV[j].properties !== undefined){
                                    if(res.data['agents'][j] !== undefined){
                                      controles[i].eventsRDV[j].properties.agent = res.data['agents'][j];
                                    } else {
                                      controles[i].eventsRDV[j].properties.agent = '';
                                    }
                                  }
                                }
                              }

                              for(let j = 0; j < controles[i].eventsRDV.length; j++){
                                let event = controles[i].eventsRDV[j];

                                event.properties.agentRDV = {};

                                event.properties.agentRDV.login = event.properties.agent;

                                //display user's name and surname
                                let found = usersArray.find(function (element) {
                                  return element.login  == event.properties.agentRDV.login;
                                });
                                if (found !== undefined) {
                                  event.properties.agentRDV.name = found.name;
                                  event.properties.agentRDV.surname = found.vorname;
                                }

                                // alert color for date background
                                scope.dossiersCfg = angular.copy(
                                    CurrentAppFactory.appCfg.main.dossierCfg);

                                let echeance = new Date(
                                    event.properties.start).getTime();
                                let now = Date.now();
                                let diff = gaJsUtils.dayDiff(now, echeance);
                                if (diff < scope.dossiersCfg.alerte.red) {
                                  event.properties.alertClass = 'redAlertRDV';
                                } else if (diff > scope.dossiersCfg.alerte.red && diff
                                    < scope.dossiersCfg.alerte.green) {
                                  event.properties.alertClass = 'yellowAlertRDV';
                                } else {
                                  event.properties.alertClass = 'greenAlertRDV';
                                }

                                // statut du rendez vous
                                let choixStatutRDV = CurrentAppFactory.getChoixStatutRDV();

                                choixStatutRDV.forEach(function (statut, index) {
                                  if (controles[i].properties.statut_rdv === statut.value) {
                                    event.properties.statutRDV = statut.label;
                                  }
                                });
                                if (controles[i].properties.statut_rdv == null) {
                                  event.properties.statutRDV = 'A venir';
                                }

                                event.properties.origine_du_report_annulation =
                                    event.properties.origine_du_report_annulation_rdv;

                                //get comment
                                event.properties.comment = event.properties.commentaire_rdv;
                              }

                            }
                        })
                        .catch(err => {
                          require('toastr').error(
                              "Un problème est survenu lors de la récupération de l'evenement.",
                              'Erreur',
                              {
                                positionClass: 'toast-bottom-left',
                              }
                          );
                          err.stack;
                        });

                      }, 30);

                      scope.currentRDVControles.push(controles[i]);
                    }
                  }
                }

              })
              .catch(err => {
                err.stack;
              });

            }
          })
          .catch(err => {
            err.stack;
          });
        }

        scope.getEventsBacRDV = function() {
          const where = "created_by='" + $rootScope.xgos.user.login + "'";

          UsersFactory.getactiveuserslight().then(function (res) {
            let usersArray = [];
            if (res.data !== undefined) {
            usersArray = res.data;

            CurrentAppFactory.getcontroles(scope.linkedobjects).then(
                function (res) {
                  if (res.data.features !== undefined) {

                    scope.length_events = true;

                    if (res.data.features.length > 0) {
                      // order controles
                      let controles = res.data.features;
                      controles.sort(function (a, b) {
                        let x = parseInt(a['id'].split('.')[1]);
                        let y = parseInt(b['id'].split('.')[1]);
                        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
                      });

                      for(let i = 0; i < controles.length; i++){
                        controles[i].ctrlLabel = CurrentAppFactory.getControleName(
                            controles[i].properties.type,
                            controles[i].properties.date_passage
                        );

                        if (i == 0) {
                          scope.expanded[i] = true;
                        } else {
                          scope.expanded[i] = false;
                        }

                        // event
                        controles[i].eventsRDV = [];

                        if(controles[i].properties.date_passage !== null){
                          let eventProperties = {};
                          eventProperties.properties = {};
                          let agentData = {};
                          agentData.login = controles[i].properties.agent;

                          //display user's name and surname
                          let found = usersArray.find(function (element) {
                            return element.login
                                == agentData.login;
                          });
                          if (found !== undefined) {
                            agentData.name = found.name;
                            agentData.surname = found.vorname;
                          }

                          eventProperties.properties.agentRDV = agentData;
                          eventProperties.properties.title = controles[i].ctrlLabel;
                          eventProperties.properties.start = controles[i].properties.date_passage;

                          // alert color for date background
                          scope.dossiersCfg = angular.copy(
                              CurrentAppFactory.appCfg.main.dossierCfg);

                          let echeance = new Date(
                              eventProperties.properties.start).getTime();
                          let now = Date.now();
                          let diff = gaJsUtils.dayDiff(now, echeance);
                          if (diff < scope.dossiersCfg.alerte.red) {
                            eventProperties.properties.alertClass = 'redAlertRDV';
                          } else if (diff > scope.dossiersCfg.alerte.red
                              && diff
                              < scope.dossiersCfg.alerte.green) {
                            eventProperties.properties.alertClass = 'yellowAlertRDV';
                          } else {
                            eventProperties.properties.alertClass = 'greenAlertRDV';
                          }

                          // statut du rendez vous
                          let choixStatutRDV = CurrentAppFactory.getChoixStatutRDV();

                          choixStatutRDV.forEach(function (statut, index) {
                            if (controles[i].properties.statut_rdv
                                === statut.value) {
                              eventProperties.properties.statutRDV = statut.label;
                            }
                          });
                          if (controles[i].properties.statut_rdv == null) {
                            eventProperties.properties.statutRDV = 'A venir';
                          }

                          eventProperties.properties.origine_du_report_annulation =
                              controles[i].properties.origine_du_report_annulation_rdv;

                          eventProperties.properties.comment =
                              controles[i].properties.commentaire_rdv;

                          controles[i].eventsRDV.push(eventProperties);
                        }

                        scope.currentRDVControles.push(controles[i]);
                      }
                    }
                  }
                })
                .catch(err => {
                  err.stack;
                });
            }
          })
          .catch(err => {
            err.stack;
          });
        }

        if(scope.appType === 'anc'){
          scope.getEventsAncRDV();
        } else if(scope.appType === 'bac') {
          scope.getEventsBacRDV();
        }


        // kis_calendar_event_changed
        $rootScope.$on('kis_calendar_event_changed', function(
            event,
            data
        ) {
          scope.currentRDVControles = [];
          scope.getEventsAncRDV();
        });

        //render date
        scope.renderValue = function(v) {
          v = new Date(v);
          v = $filter('date')(v, 'dd/MM/yyyy');

          return v;
        };

        //render date
        scope.renderTimeFromDate = function(v) {
          return new Date(v).toTimeString().split(' ')[0];
        };

        //refresh events
        scope.refresh = function() {
          scope.currentRDVControles = [];
          if(scope.appType === 'anc'){
            scope.getEventsAncRDV();
          } else if(scope.appType === 'bac') {
            scope.getEventsBacRDV();
          }
        };

        //add event
        scope.addNewEvent = function() {
          scope.actionPriseRdv();
        };

        scope.editEventLine = {};
        let svgType;
        let currentId;

        // edit event
        scope.editEvent = function(idx) {
          if (currentId && currentId != idx) {
            scope.events[currentId] = angular.copy(svgType);
            scope.editEventLine = {};
          }
          currentId = idx;
          let tmp = {};
          tmp[idx] = !scope.editEventLine[idx];
          scope.editEventLine = tmp;
          svgType = angular.copy(scope.events[idx]);
        };

        scope.updateEventType = function(idx) {
          gaDomUtils.showGlobalLoader();
          if (scope.events[idx].properties.agent) {
            scope.events[idx].properties.agent = {login: scope.events[idx].properties.agent.login}
          }
          CalendarFactory.updateeventdetails(scope.events[idx]).then(function(res) {
            gaDomUtils.hideGlobalLoader();
            scope.editEventLine = {};
            currentId = false;
          });
        }

        // cancel event edit
        scope.cancelEventEdit = function(idx) {
          $timeout(function() {
            scope.events[idx] = svgType;
            scope.editEventLine = {};
            currentId = false;
          });
        };

        scope.removeEvent = function(event, controlId) {
          var ans = confirm(
              'Êtes-vous certain de vouloir effectuer cette action ?'
          );

          if (ans) {
            if(scope.appType == 'anc'){
              gaDomUtils.showGlobalLoader();
              CalendarFactory.removeeventdetails(event.id).then(
                  function(res) {
                    scope.currentRDVControles = [];
                    scope.getEventsAncRDV();
                    gaDomUtils.hideGlobalLoader();
                  }
              )
              .catch(err => {
                err.stack;
              });
            }

            if(scope.appType == 'bac'){

              gaDomUtils.showGlobalLoader();

              CurrentAppFactory.getcontroles(scope.linkedobjects).then(function(res){
                if(res.data !== undefined && res.data.features !== undefined){

                  let control = res.data.features.filter(function(control){
                    return control.id == controlId;
                  });

                  if(control !== undefined && control[0] !== undefined){
                    control[0].properties.date_passage = null;
                    control[0].properties.origine_du_report_annulation_rdv = null;
                    control[0].properties.commentaire_rdv = null;
                    control[0].properties.statut_rdv = null;

                    // update controle object
                    BacAppFactory.updatecontrole({
                      type: 'FeatureCollection',
                      features: [control[0]],
                    }).then(function(res){

                    })
                    .catch(err => {
                      require('toastr').error(
                          "Un problème est survenu lors de l'enregistitrement de l'instruction.",
                          'Erreur',
                          {
                            positionClass: 'toast-bottom-left',
                          }
                      );
                      err.stack;
                    });


                    BacAppFactory.addcontroledetail(
                        control[0],
                        scope.linkedobjects,
                        controlId
                    ).then(function(res) {
                        require('toastr').success(
                            "Informations de l'instruction enregistrées.",
                            '',
                            {
                              positionClass: 'toast-bottom-left',
                            }
                        );
                      // reset dirty variable
                      scope.ctrlFormIsDirty = false;

                      scope.currentRDVControles = [];
                      scope.getEventsBacRDV();

                      gaDomUtils.hideGlobalLoader();
                    })
                    .catch(err => {
                      err.stack;
                    });

                  }
                }
              })
              .catch(err => {
                err.stack;
              });

            }
          }
        };
      },
    };
  };

  eventLinked.$inject = [
      'AncAppFactory',
      'BacAppFactory',
      'CalendarFactory',
      'UsersFactory',
      '$filter',
      '$rootScope',
      '$timeout',
      'gaDomUtils',
      'ngDialog',
      'gaJsUtils',
      'kisCalendarFactory',
  ];
  return eventLinked;
});
