'use strict';
define(function() {
  /**
   *
   */
  var geocatalogueFilter = function(FeatureTypeFactory, extendedNgDialog, $filter) {
    return {
      restrict: 'AE',
      templateUrl:
        'js/XG/modules/common/views/directives/geocatalogueFilter.html',
      link: function($scope) {
        $scope.initFilterLayers = () => {
          if($scope.edit_resource && ($scope.geocatalogueNotFromApplication || $scope.appTypeIsMap())){
            $scope.grouplayers = {};
            $scope.hiddenPanels = {};
            $scope.allPanelHidden = false;
            $scope.subGroupChecked = {};
            $scope.groupChecked= {};
            FeatureTypeFactory.get(true).then((res) =>{
              res.forEach(layer=>{
                if(layer.geographic || $scope.geocatalogueNotFromApplication){
                  var themename =
                    layer.theme && layer.theme !== 'undefined' ? layer.theme : 'Default';
                  layer.theme = themename;
                  if (angular.isUndefined($scope.grouplayers[themename])) {
                    $scope.grouplayers[themename] = [];
                  }
                  $scope.grouplayers[themename].push({
                    "name": layer.name,
                    "alias": layer.alias,
                    "uid": layer.uid,
                    "srid": layer.srid?'['+layer.srid.split(":").pop()+']':''
                  });
                }
              })
              $scope.display = 'Alias'
              $scope.grouplayersName = Object.keys($scope.grouplayers);
              $scope.showAllPanels();
              if(!$scope.edit_resource.filterLayers){
                $scope.edit_resource.filterLayers = {};
              }
              if(!$scope.edit_resource.filterLayers.layers){
                $scope.edit_resource.filterLayers.layers = {};
              }
              if(!angular.isDefined($scope.edit_resource.filterLayers.useFilter)){
                $scope.edit_resource.filterLayers.useFilter = false;
              }
              if($scope.geocatalogueNotFromApplication){
                $scope.edit_resource.rightFeatures.forEach(feat =>{
                  $scope.edit_resource.filterLayers.layers[feat]=true;
                });
              }
              $scope.grouplayersName.forEach(group=>{
                $scope.groupIsChecked(group);
              });
              $scope.allGroupIsChecked();
            });
            // init filterLayers dans un objet sinon filterLayers n'est pas mis à jour depuis le html
            $scope.search = {
              filterLayers: ''
            };
          }
        };
        $scope.checkFeature = (uid,value) => {
          $scope.edit_resource.filterLayers.layers[uid]=angular.isDefined(value)?
                                                          value:!$scope.edit_resource.filterLayers.layers[uid];
          if($scope.geocatalogueNotFromApplication){
            if(!$scope.edit_resource.filterLayers.layers[uid]){
              const index = $scope.edit_resource.rightFeatures.indexOf(uid);
              if (index > -1) {
                $scope.edit_resource.rightFeatures.splice(index, 1);
              }
            }else if($scope.edit_resource.rightFeatures.indexOf(uid)===-1) {
              $scope.edit_resource.rightFeatures.push(uid);
            }
          }
        }
        $scope.hideAllPanels = () => {
          $scope.grouplayersName.forEach(group=>{
            $scope.hiddenPanels[group] = true;
            $scope.allPanelHidden = true;
          });
        };
        // fermer tous les groupes de thèmes
        $scope.showAllPanels = function() {
          $scope.hiddenPanels = {};
          $scope.allPanelHidden = false;
        };

        $scope.groupIsChecked = (group) => {
          $scope.groupChecked[group] = true;
          $scope.grouplayers[group].forEach((layer) => {
            if(!$scope.edit_resource.filterLayers.layers[layer.uid]){
              $scope.groupChecked[group]  = false;
            }
          });
        };

        $scope.subGroupCheckedFn = (group) => {
          $scope.grouplayers[group].forEach((layer) => {
            $scope.checkFeature(layer.uid,$scope.groupChecked[group]);
          });
        };

        $scope.allGroupCheckedFn = () => {
          $scope.allGroupChecked=!$scope.allGroupChecked
          $scope.grouplayersName.forEach(group=>{
            $scope.groupChecked[group] = $scope.allGroupChecked;
            $scope.subGroupCheckedFn(group);
          });
        };
        $scope.allGroupIsChecked = () => {
          $scope.allGroupChecked= true;
          $scope.grouplayersName.forEach(group=>{
            if(!$scope.groupChecked[group]){
              $scope.allGroupChecked= false;
            }
          });
        }

        $scope.$watch('edit_resource', ()=>{
          $scope.initFilterLayers();
        });

        /**
         * Supprime le filtrage quand on appuie sur la touche "escape"
         * Uniquement lors du 1er caractère écrit:<ul><li>
         * Sauvegarde l'état de d'affichage des groupes</li><li>
         * Dégroupe tous les groupes de couches</li><ul>
         * @param event keydown event
         */
        $scope.onFilterKeydown = (event) => {
          // reset si escape
          $scope.search.filterLayers = event.keyCode === 27 ? '' : $scope.search.filterLayers;

          if (!$scope.hiddenPanelsPrevState && $scope.search.filterLayers.length > 0) {
            if (Object.keys($scope.hiddenPanels).length > 0) {
              $scope.hiddenPanelsPrevState = angular.copy($scope.hiddenPanels);
            }
            // modifie la variable allPanelHidden
            $scope.showAllPanels();
          }
        };


        /**
         * Après avoir effacé le texte de saisie du filtre,
         * restaure l'état initial d'affichage des groupes de couches
         */
        $scope.onFilterKeyup = () => {
          if ($scope.search.filterLayers.length === 0) {

            if ($scope.filterState){
              $scope.filterState = false;
            }

            // restaure un état initial existant
            if ($scope.hiddenPanelsPrevState) {
              $scope.hiddenPanels = $scope.hiddenPanelsPrevState;
              // restaure allPanelHidden
              if (Object.keys($scope.hiddenPanels).length === Object.keys($scope.grouplayers).length) {
                $scope.allPanelHidden = Object.values($scope.hiddenPanels).every(active => active);
              }
              $scope.hiddenPanelsPrevState = null;
            }
          }
        };

        /**
         * Au clic sur le bouton suppimer (croix) de la zone de saisie du filtre des couches
         */
        $scope.resetFilter = () => {
          $scope.search.filterLayers = ''
          $scope.onFilterKeyup();
        };

        /**
         * Au clic sur le bouton d'ouverture de la liste des composants
         */
        $scope.openGeocatalog = () => {
          if (!$scope.isGeocatalogOpened) {
            let title = $filter('translate')('applications.applications.filterLayers.title');
            if ($scope.geocatalogueNotFromApplication) {
              title = $filter('translate')('applications.applications.filterLayers.titleRole');
            }
            $scope.isGeocatalogOpened = true;
            extendedNgDialog.open({
              template:
                  'js/XG/modules/applications/views/modals/modal.filterLayers.application.html',
              className: 'ngdialog-theme-plain nopadding geocatalog miniclose',
              closeByDocument: false,
              scope: $scope,
              draggable: true,
              resizable: true,
              title: title,
              preCloseCallback: () => {
                $scope.isGeocatalogOpened = false;
              },
            });
          }
        };
      }
    };
  };

  geocatalogueFilter.$inject = ['FeatureTypeFactory', 'extendedNgDialog', '$filter'];
  return geocatalogueFilter;
});
