'use strict';
/**
 * @ngdoc overview
 * @name modules.common
 * @description
 * common module
 */
define([
  'angular',
  'modules/common/controllers/MainCtrl',
  'modules/common/controllers/NavigationCtrl',
  'modules/common/controllers/CalendarInviteCtrl',
  'modules/common/controllers/listesDeroulantesCtrl',

  'modules/common/services/extendedNgDialog',
  'modules/common/services/dialogsCommon',
  'modules/common/services/kisGeocodageFactory',
  'modules/common/services/twitterFactory',
  'modules/common/services/versionsFactory',

  'modules/common/directives/navGroup',
  'modules/common/directives/applicationLogo',
  'modules/common/directives/submitLoad',
  'modules/common/directives/dualListBox',
  'modules/common/directives/editList',
  'modules/common/directives/closeModaleButton',
  'modules/common/directives/geocatalogueFilter',
  'modules/common/directives/checkList',
  'modules/common/directives/arrayInput',
  'modules/common/directives/restrictedInput',
  'modules/common/directives/validateInput',
  'modules/common/directives/tabbedForm',
  'modules/common/directives/uncheckableRadio',
  'modules/common/directives/fixedHeaderTable',
  'modules/common/directives/mapPositionPicker',
  'modules/common/directives/positionAutoComplete',
  'modules/common/directives/banoInfo',
  'modules/common/directives/featuresConfig',
  'modules/common/directives/eventLinked',
  'modules/common/directives/userPicker',
  'modules/common/directives/parameterSaveLoad',
  'modules/common/directives/emailWriter',
  'modules/common/directives/kisGeocoderPicker',
  'modules/common/directives/positionFeature',
  'modules/common/directives/featureHistoryTable',
  'modules/common/directives/imageLibraryPicker',
  'modules/common/directives/jsonText',
  'modules/common/directives/arrayNumberInput',
  'modules/common/directives/kisSocialShare',
  'modules/common/directives/optionClass',
  'modules/common/directives/executeQuery',
  'modules/common/directives/executeQueryManager',
  'modules/common/directives/mapLeftMenu',
  'modules/common/directives/iconPicker',
  'modules/common/directives/categoryWidgetIconPicker',
  'modules/common/directives/kisVersions',
  'modules/common/directives/portalHelpLinks',
  'modules/common/directives/noForbiddenChars',
  'modules/common/directives/progressText',

  'modules/common/filters/booleanToCheck',
  'modules/common/filters/datetoshow',
  'modules/common/filters/dataStoreTypeLogo',
  'modules/common/filters/layerTypeToIcon',
  'modules/common/filters/userExtraProvider',
  'modules/common/filters/ObjectsArrayToObjectAttributeArray',
  'modules/common/filters/isArray',
  'modules/common/filters/isHexa',
  'modules/common/filters/displayXML',
  'modules/common/filters/forceArray',
  'modules/common/filters/findObjectInArray',
  'modules/common/filters/arrayMap',
  'modules/common/filters/trustUrl',
  'modules/common/filters/translateColumn',
  'modules/common/filters/nl2br',
  'modules/common/filters/formatDateToLocale',
  'modules/common/filters/joinArray',

  'angular-strap',
  'angular-strap.tpl',

  'angular-route',
  'ngDragDrop',

  'toastr',
  'ng-table',
], function(
  angular,
  MainCtrl,
  NavigationCtrl,
  CalendarInviteCtrl,
  listesDeroulantesCtrl,
  extendedNgDialog,
  dialogsCommon,
  kisGeocodageFactory,
  twitterFactory,
  versionsFactory,
  navGroup,
  applicationLogo,
  submitLoad,
  dualListBox,
  editList,
  closeModaleButton,
  geocatalogueFilter,
  checkList,
  arrayInput,
  restrictedInput,
  validateInput,
  tabbedForm,
  uncheckableRadio,
  fixedHeaderTable,
  mapPositionPicker,
  positionAutoComplete,
  banoInfo,
  featuresConfig,
  eventLinked,
  userPicker,
  parameterSaveLoad,
  emailWriter,
  kisGeocoderPicker,
  positionFeature,
  featureHistoryTable,
  imageLibraryPicker,
  jsonText,
  arrayNumberInput,
  kisSocialShare,
  optionClass,
  executeQuery,
  executeQueryManager,
  mapLeftMenu,
  iconPicker,
  categoryWidgetIconPicker,
  kisVersions,
  portalHelpLinks,
  noForbiddenChars,
  progressText,
  booleanToCheck,
  datetoshow,
  dataStoreTypeLogo,
  layerTypeToIcon,
  userExtraProvider,
  ObjectsArrayToObjectAttributeArray,
  isArray,
  isHexa,
  displayXML,
  forceArray,
  findObjectInArray,
  arrayMap,
  trustUrl,
  translateColumn,
  nl2br,
  formatDateToLocale,
  joinArray
) {
  // Module
  var mod = angular.module('common', ['ngRoute', 'ngDragDrop']);

  // Services
  mod.factory('extendedNgDialog', extendedNgDialog);
  mod.factory('dialogsCommon', dialogsCommon);
  mod.factory('kisGeocodageFactory', kisGeocodageFactory);
  mod.factory('twitterFactory', twitterFactory);
  mod.factory('versionsFactory', versionsFactory);

  // Controllers
  mod.controller('NavigationCtrl', NavigationCtrl);
  mod.controller('CalendarInviteCtrl', CalendarInviteCtrl);
  mod.controller('listesDeroulantesCtrl', listesDeroulantesCtrl);

  // Directives
  mod.directive('navGroup', navGroup);
  mod.directive('applicationLogo', applicationLogo);
  mod.directive('submitLoad', submitLoad);
  mod.directive('dualListBox', dualListBox);
  mod.directive('editList', editList);
  mod.directive('closeModaleButton', closeModaleButton);
  mod.directive('geocatalogueFilter', geocatalogueFilter);
  mod.directive('checkList', checkList);
  mod.directive('arrayInput', arrayInput);
  mod.directive('restrictedInput', restrictedInput);
  mod.directive('validateInput', validateInput);
  mod.directive('tabbedForm', tabbedForm);
  mod.directive('uncheckableRadio', uncheckableRadio);
  mod.directive('fixedHeaderTable', fixedHeaderTable);
  mod.directive('mapPositionPicker', mapPositionPicker);
  mod.directive('positionAutoComplete', positionAutoComplete);
  mod.directive('banoInfo', banoInfo);
  mod.directive('featuresConfig', featuresConfig);
  mod.directive('kisGeocoderPicker', kisGeocoderPicker);
  mod.directive('eventLinked', eventLinked);
  mod.directive('userPicker', userPicker);
  mod.directive('parameterSaveLoad', parameterSaveLoad);
  mod.directive('emailWriter', emailWriter);
  mod.directive('positionFeature', positionFeature);
  mod.directive('featureHistoryTable', featureHistoryTable);
  mod.directive('imageLibraryPicker', imageLibraryPicker);
  mod.directive('jsonText', jsonText);
  mod.directive('arrayNumberInput', arrayNumberInput);
  mod.directive('kisSocialShare', kisSocialShare);

  mod.directive('optionsClass', function($parse) {
    return {
      require: 'select',
      link: function(scope, elem, attrs, ngSelect) {
        // get the source for the items array that populates the select.
        var optionsSourceStr = attrs.ngOptions.split(' ').pop(),
          // use $parse to get a function from the options-class attribute
          // that you can use to evaluate later.
          getOptionsClass = $parse(attrs.optionsClass);

        scope.$watch(optionsSourceStr, function(items) {
          // when the options source changes loop through its items.
          angular.forEach(items, function(item, index) {
            // evaluate against the item to get a mapping object for
            // for your classes.
            var classes = getOptionsClass(item),
              // also get the option you're going to need. This can be found
              // by looking for the option with the appropriate index in the
              // value attribute.
              option = elem.find('option[value=' + index + ']');

            // now loop through the key/value pairs in the mapping object
            // and apply the classes that evaluated to be truthy.
            angular.forEach(classes, function(add, className) {
              if (add) {
                angular.element(option).addClass(className);
              }
            });
          });
        });
      },
    };
  });
  mod.directive('executequery', executeQuery);
  mod.directive('executequerymanager', executeQueryManager);
  mod.directive('mapLeftMenu', mapLeftMenu);
  mod.directive('iconPicker', iconPicker);
  mod.directive('categoryWidgetIconPicker', categoryWidgetIconPicker);
  mod.directive('kisVersions', kisVersions);
  mod.directive('portalhelplinks', portalHelpLinks);
  mod.directive('noForbiddenChars', noForbiddenChars);
  mod.directive('progressText', progressText);

  // Filters
  mod.filter('booleanToCheck', booleanToCheck);
  mod.filter('datetoshow', datetoshow);
  mod.filter('dataStoreTypeLogo', dataStoreTypeLogo);
  mod.filter('layerTypeToIcon', layerTypeToIcon);
  mod.filter('userExtraProvider', userExtraProvider);
  mod.filter(
    'ObjectsArrayToObjectAttributeArray',
    ObjectsArrayToObjectAttributeArray
  );
  mod.filter('isArray', isArray);
  mod.filter('isHexa', isHexa);
  mod.filter('displayXML', displayXML);
  mod.filter('forceArray', forceArray);
  mod.filter('findObjectInArray', findObjectInArray);
  mod.filter('arrayMap', arrayMap);
  mod.filter('trustUrl', trustUrl);
  mod.filter('translateColumn', translateColumn);
  mod.filter('nl2br', nl2br);
  mod.filter('formatDateToLocale', formatDateToLocale);
  mod.filter('joinArray', joinArray);

  /**
   * Dynamic filter allowing to invoke another filter dynamically
   */
  mod.filter('dynamicFilter', [
    '$filter',
    '$sce',
    function($filter, $sce) {
      return function(input, filterToUse) {
        if (filterToUse == '') {
          if (typeof input == 'number') {
            input = '' + input;
          }
          if (typeof input == 'boolean') {
            input = input
              ? '<i class="fa fa-check" aria-hidden="true"></i>'
              : '';
          }
          return $sce.trustAsHtml(input);
        } else {
          return $filter(filterToUse)(input);
        }
      };
    },
  ]);

  /**
   * Dynamic filter allowing to invoke another filter dynamically
   */
  mod.filter('datetypetoparse', [
    '$filter',
    function($filter) {
      return function(input, filterToUse) {
        if (input) {
          return $filter('date')(new Date(input), 'dd MMM yyyy HH:mm');
        } else {
          return undefined;
        }
      };
    },
  ]);
  /**
   * orderByTranslated
   */
  mod.filter('orderByTranslated', [
    '$translate',
    '$filter',
    function($translate, $filter) {
      return function(array, i18nKeyPrefix, objKey) {
        var result = [];
        var translated = [];
        angular.forEach(array, function(value) {
          var i18nKeySuffix = objKey ? value[objKey] : value;
          translated.push({
            key: value,
            label: $translate.instant(i18nKeyPrefix + i18nKeySuffix),
          });
        });
        angular.forEach($filter('orderBy')(translated, 'label'), function(
          sortedObject
        ) {
          result.push(sortedObject.key);
        });
        return result;
      };
    },
  ]);

  // Configuration
  mod.config([
    '$routeProvider',
    '$locationProvider',
    function($routeProvider, $locationProvider) {
      $locationProvider.hashPrefix('');
      // specific route resolve for some apps
      var originalWhen = $routeProvider.when;

      $routeProvider.when = function(path, route) {
        route.resolve || (route.resolve = {});

        angular.extend(route.resolve, {
          cfgLoaded: ['SirocoFactory', 'AncAppFactory', 'BacAppFactory', 'ApplicationFactory', function(SirocoFactory, AncAppFactory, BacAppFactory, ApplicationFactory) {
            if (path) {
              // SIROCO
              // any siroco route but nocfg
              if (
                ~path.indexOf('/siroco/') &&
                !~path.indexOf('/siroco/nocfg')
              ) {
                return SirocoFactory.getSirocoCfg();
              }
              // ANC
              if (~path.indexOf('/anc/')) {
                return AncAppFactory.getAppCfg();
              }
              // BAC
              if (~path.indexOf('/bac/')) {
                return BacAppFactory.getAppCfg();
              }
              if (path === '/map') {
                // récupère les applications avant de poursuivre vers la destination
                return ApplicationFactory.get();
              }
            }
          }],
        });
        return originalWhen.call($routeProvider, path, route);
      };

      // Routes
      $routeProvider.when('/map', {
        templateUrl: 'map.html',
        controller: 'gcMainController',
      });
      $routeProvider.when('/form', {
        templateUrl: 'form.html',
        controller: 'gcFormController',
      });

      /*  siroco was moved into widgets/sirocoapp/init/mod.js to include extra verifications
             $routeProvider.when('/siroco', {
             templateUrl: 'siroco.html',
             controller: 'gcSirocoController'
             });
      */
      $routeProvider.when('/indigau', {
        templateUrl: 'js/XG/widgets/indigauapp/main/views/controller/main.html',
        controller: 'gcIndigauController',
      });
      $routeProvider.when('/calendar_invite', {
        templateUrl: 'js/XG/modules/common/views/calendar_invite.html',
        controller: 'CalendarInviteCtrl',
      });
      /**
       * SEPPRI
       */
      $routeProvider.when('/hpo', {
        templateUrl: 'js/XG/widgets/hpoapp/main/views/controller/main.html',
        controller: 'gcMainHpoController',
      });
      /**
       * SEPPRI
       */
      $routeProvider.when('/mapv2', {
        templateUrl: 'js/XG/widgets/hpoapp/main/views/controller/main.html',
        controller: 'gcMainCarteController',
      });

      $routeProvider.when('/503/', {
        templateUrl: 'js/XG/modules/common/views/503.html',
      });
      $routeProvider.when('/404/', {
        templateUrl: 'js/XG/modules/common/views/404.html',
      });
      $routeProvider.when('/', { redirectTo: '/users/' });
      $routeProvider.otherwise({ redirectTo: '/404/' });
    },
  ]);

  return mod;
});
