'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    EditTypesFactory,
    $translate,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.setRemoteAttribute.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope, element, attrs, ctrl) {
        //scope.result = {};
        scope.rule.name = 'SetRemoteAttribute';
        scope.rule.type = 'OnEnd';

        var editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.updateattributes,
          EditTypesFactory.editTypes.update,
        ];

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        //Si phase de creation
        if (scope.rule.parameters == undefined) {
          scope.rule.parameters = {};
        }
        if (scope.rule.parameters.dataSource == undefined) {
          scope.rule.parameters.dataSource = {};
        }
        if (scope.rule.parameters.targets == undefined) {
          scope.rule.parameters.targets = [];
        }

        if (FeatureTypeFactory.resources.featuretypes.length == 0) {
          FeatureTypeFactory.get().then(function() {
            scope.featureTypes = angular.copy(
              FeatureTypeFactory.resources.featuretypes
            );
          });
        } else {
          scope.featureTypes = angular.copy(
            FeatureTypeFactory.resources.featuretypes
          );
        }

        scope.initSelectedLayer = function(layerName) {
          var selectedFti = undefined;
          for (var i = 0; i < scope.featureTypes.length; i++) {
            if (scope.featureTypes[i].name == layerName) {
              selectedFti = scope.featureTypes[i];
              break;
            }
          }
          return selectedFti;
        };
        scope.initSourceLayer = function(layerName) {
          var selectedFti = undefined;
          for (var i = 0; i < scope.featureTypes.length; i++) {
            if (scope.featureTypes[i].name == layerName) {
              selectedFti = scope.featureTypes[i];
              break;
            }
          }
          scope.temp = selectedFti;
          return selectedFti;
        };

        scope.onSourceChange = function(fti) {
          scope.temp = fti;
        };

        scope.addTarget = function() {
          var sourceArray = scope.rule['parameters']['targets'];
          sourceArray.push({});
        };
        scope.removeTarget = function(sourceIndex) {
          var sourceArray = scope.rule['parameters']['targets'];
          sourceArray.splice(sourceIndex, 1);
        };

        RuleCfgFactory.listAllSharedObjects(scope);

        if (!scope.rule.parameters.hasOwnProperty('isPostValidationOnCreate')) {
          scope.rule.parameters.isPostValidationOnCreate = false;
        }

        scope.isPostValidationOptionOnCreateEnabled = false;

        // A l'initialisation de la popup de configuration de la règle avec la dualListBox
        scope.$watch('rule.editTypes', () => {
          scope.onRuleEditTypesChange();
        });

        /**
         * Exécutée à chaque changement du composant enfant dualListBox des editTypes
         */
        scope.onRuleEditTypesChange = () => {
          scope.isPostValidationOptionOnCreateEnabled = scope.rule.editTypes.some(editType => editType.name === 'add');
          if (!scope.isPostValidationOptionOnCreateEnabled) {
            scope.rule.parameters.isPostValidationOnCreate = false;
          }
        };
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    'EditTypesFactory',
    '$translate',
    'RuleCfgFactory',
  ];
  return gcelement;
});
