'use strict';
define(function() {
  class featuretypeTriggers {
    constructor(ngDialog, $filter, DataStoreFactory) {
      return {
        templateUrl: 'js/XG/modules/model/views/directives/featuretypeTriggers.html',
        restrict: 'E',
        scope: {
          currentfeaturetype: '=featuretype',
        },
        link: (scope, element, attrs) => {

          scope.generatePossibleTypes = () => {
            scope.possibleTypes = [
              {
                key: 'attribut',
                label: $filter('translate')('rulecfg.setuniqueidbyconcat.attribut'),
              }
            ];
            const targetField = scope.currentfeaturetype.attributes.find(attribute => attribute.name === scope.currentTrigger.targetField);
            if(['java.lang.Double', 'java.lang.String', 'java.lang.Integer'].includes(targetField.type)){
              scope.possibleTypes.push({
                key: 'fid',
                label: $filter('translate')('rulecfg.setuniqueidbyconcat.fid'),
              })
            }
            if(['java.lang.String'].includes(targetField.type)){
              scope.possibleTypes.push({
                key: 'value',
                label: $filter('translate')('rulecfg.setuniqueidbyconcat.value'),
              })
            }
            if(['java.lang.String', 'java.util.Date', 'java.sql.Timestamp'].includes(targetField.type)){
              scope.possibleTypes.push({
                key: 'currentDate',
                label: $filter('translate')('model.featuretypes.triggers.currentDate'),
              })
            }

            if(['java.lang.Double', 'java.lang.Integer'].includes(targetField.type)){
              scope.possibleAttributes = scope.currentfeaturetype.attributes.filter(attribute => ['java.lang.Double', 'java.lang.Integer'].includes(attribute.type));
            }else if(['java.util.Date', 'java.sql.Timestamp'].includes(targetField.type)){
              scope.possibleAttributes = scope.currentfeaturetype.attributes.filter(attribute => ['java.util.Date', 'java.sql.Timestamp'].includes(attribute.type));
            }else{
              scope.possibleAttributes = scope.currentfeaturetype.attributes;
            }
          }

          const openAddUpdateDialog = () => {
            ngDialog.open({
              template:
                'js/XG/modules/model/views/modals/modal.featuretypes.triggers.html',
  
              scope: scope,
              showClose: false,
              closeByEscape: false,
              closeByDocument: false,
              className: 'ngdialog-theme-plain width800 miniclose',
            });
          }

          scope.addNewTrigger = () => {
            scope.triggerPosition = -1;
            scope.currentTrigger = {formula:[], enabled: true};
            openAddUpdateDialog();
          }

          scope.updateTrigger = (index) => {
            scope.triggerPosition = index;
            scope.currentTrigger = scope.currentfeaturetype.triggers[index];
            scope.generatePossibleTypes();
            openAddUpdateDialog();
          }

          scope.checkDuplicateName = () => {
            scope.nameExists = scope.currentfeaturetype.triggers.some(trigger => trigger.name === scope.currentTrigger.name);
          }

          scope.addNumerotationPart = () => {
            scope.currentTrigger.formula.push({
              key: ' ',
              format: ' ',
            });
          };

          scope.removePartFromNumerotationCfg = (index) => {
            scope.currentTrigger.formula.splice(index, 1);
          };  

          scope.moveNumerotationpart = (direction, index) => {
            if(!(index === 0 && direction === 'up') &&
               !(index === scope.currentTrigger.formula.length - 1 && direction === 'down')) {
              const newIndex = direction === 'up' ? index - 1 : index + 1;
              scope.currentTrigger.formula.splice(index, 0, scope.currentTrigger.formula.splice(newIndex, 1)[0]);
            }
          };

          scope.moveTrigger = (direction, index) => {
            if(!(index === 0 && direction === 'up') &&
               !(index === scope.currentfeaturetype.triggers.length - 1 && direction === 'down')) {
              const newIndex = direction === 'up' ? index - 1 : index + 1;
              scope.currentfeaturetype.triggers.splice(index, 0, scope.currentfeaturetype.triggers.splice(newIndex, 1)[0]);
            }
          };

          scope.removeTriggerFromFeatureType = () => {
            let selectedTrigger = scope.currentfeaturetype.triggers.find(trigger => trigger.$selected)
            swal(
              {
                title: $filter('translate')('model.featuretypes.triggers.deleteTitle'),
                text: $filter('translate')('model.featuretypes.triggers.deleteText')+ selectedTrigger.name,
                showCancelButton: true,
                confirmButtonColor: '#DD6B55',
                confirmButtonText: $filter('translate')('common.yes'),
                cancelButtonText: $filter('translate')('common.no'),
                closeOnConfirm: true,
                closeOnCancel: true,
              },
              function (res) {
                if(res){
                  scope.currentfeaturetype.triggers = scope.currentfeaturetype.triggers.filter(trigger => !trigger.$selected);
                  scope.$apply();
                }
              }
            );
          }

          scope.addOrUpdateTrigger = () => {
            if(scope.currentTrigger){
              if(!scope.currentTrigger.specifiqueSql){
                scope.generateSql();
              }
              if(scope.triggerPosition === -1){
                if(!Array.isArray(scope.currentfeaturetype.triggers)){
                  scope.currentfeaturetype.triggers = [];
                }
                scope.currentfeaturetype.triggers.push(scope.currentTrigger);
              }else{
                scope.currentfeaturetype.triggers.splice(
                  scope.triggerPosition,
                  1,
                  scope.currentTrigger
                );
              }
              scope.currentfeaturetype.triggers.sort((a, b) => a.name.localeCompare(b.name));
            }
          }

          const getAction = () => {
            let action = '';
        
            if (scope.currentTrigger.insert) {
                action = 'INSERT';
            }
        
            if (scope.currentTrigger.update) {
                action += action ? ' OR UPDATE' : 'UPDATE';
            }
        
            return action;
          }

          scope.noselectionatAll = (trigger) => {
            scope.currentfeaturetype.triggers.map((x) => {
              if (x.name !== trigger.name) {
                x.$selected = false;
              }
            });
          };

          scope.getTriggerType = (trigger) => {
            const translate = $filter('translate');
            let type = translate('model.featuretypes.triggers.before');
            const insertText = trigger.insert ? ` ${translate('model.featuretypes.triggers.insert')}` : '';
            const updateText = trigger.update ? ` ${translate('model.featuretypes.triggers.update')}` : '';
            const orText = (trigger.insert && trigger.update) ? ` ${translate('model.featuretypes.triggers.or')}` : '';
          
            return `${type}${insertText}${orText}${updateText}`.trim();
          }          

          const generateFormula = () => {
            let formulaParts = [];
        
            scope.currentTrigger.formula.forEach(element => {
                switch (element.key) {
                    case 'attribut':
                        formulaParts.push(`NEW."${element.format}"`);
                        break;
                    case 'value':
                        formulaParts.push(`'${element.format}'`);
                        break;
                    case 'fid':
                        const primaryKey = scope.currentfeaturetype.primaryKey || 'fid';
                        formulaParts.push(`NEW."${primaryKey}"`);
                        break;
                    case 'currentDate':
                        formulaParts.push('CURRENT_DATE');
                        break;
                }
            });
        
            return formulaParts.join(' || ');
          }

          const datastore = DataStoreFactory.getDataStoreByName(scope.currentfeaturetype.storeName);


          scope.generateSql = () => {
            //KIS-3703-Remplacer les tirets par des underscores
            const featureTypeName = scope.currentfeaturetype.name.toLowerCase().replace(/-/g, '_');
            const triggerName = `${featureTypeName}_${scope.currentTrigger.name}`;
            scope.currentTrigger.generatedSQL = `CREATE OR REPLACE FUNCTION "${datastore.schema}".${triggerName}()
 RETURNS trigger
 LANGUAGE plpgsql
 AS $function$
 BEGIN
     NEW."${scope.currentTrigger.targetField}" := ${generateFormula()};
     RETURN NEW;
 END;
 $function$;

 DROP TRIGGER IF EXISTS ${triggerName} ON "${datastore.schema}"."${scope.currentfeaturetype.name}"; `;

            if(scope.currentTrigger.enabled){
              scope.currentTrigger.generatedSQL +=`
CREATE TRIGGER ${triggerName} BEFORE ${getAction()}
ON "${datastore.schema}"."${scope.currentfeaturetype.name}"
FOR EACH ROW EXECUTE PROCEDURE "${datastore.schema}".${triggerName}();`
            }

          }
  
        },
      };
    }
  }

  featuretypeTriggers.$inject = ['ngDialog', '$filter', 'DataStoreFactory'];
  return featuretypeTriggers;
});
