'use strict';
define([
  'angular',

  'modules/print/services/PrintModelFactory',
  'modules/print/services/SharedFactory',
  'modules/print/services/DocumentFactory',

  'modules/print/controllers/PrintModelCtrl',
  'modules/print/controllers/ModelGUICtrl',

  'modules/print/directives/objectInput',
  'modules/print/directives/guiMenu',
  'modules/print/directives/legendSketch',
  'modules/print/directives/jsonEditor',
  'modules/print/directives/guiEditor',

  'modules/print/directives/guieditor/attributes',
  'modules/print/directives/guieditor/toolBox',
  'modules/print/directives/guieditor/treeSet',

  'modules/print/directives/blocks/mapBlock',
  'modules/print/directives/blocks/overviewBlock',
  'modules/print/directives/blocks/textBlock',
  'modules/print/directives/blocks/imgBlock',
  'modules/print/directives/blocks/columnsBlock',
  'modules/print/directives/blocks/legendBlock',
  'modules/print/directives/blocks/attributesBlock',
  'modules/print/directives/blocks/pageBlock',

  'modules/print/directives/blocks/blocksConf/mapAttr',
  'modules/print/directives/blocks/blocksConf/overviewAttr',
  'modules/print/directives/blocks/blocksConf/textAttr',
  'modules/print/directives/blocks/blocksConf/imgAttr',
  'modules/print/directives/blocks/blocksConf/columnsAttr',
  'modules/print/directives/blocks/blocksConf/legendAttr',
  'modules/print/directives/blocks/blocksConf/attributesAttr',
  'modules/print/directives/blocks/blocksConf/pageAttr',
  'modules/print/directives/blocks/blocksConf/variablesAttr',

  'modules/print/directives/unitconvert',

  /* 'easel',*/

  'colorpicker.module',
  'angular-strap',
  'angular-strap.tpl',

  'angular-route',

  'toastr',
], function(
  angular,
  PrintModelFactory,
  SharedFactory,
  DocumentFactory,
  PrintModelCtrl,
  ModelGUICtrl,
  objectInput,
  guiMenu,
  legendSketch,
  jsonEditor,
  guiEditor,
  attributes,
  toolBox,
  treeSet,
  mapBlock,
  overviewBlock,
  textBlock,
  imgBlock,
  columnsBlock,
  legendBlock,
  attributesBlock,
  pageBlock,
  mapAttr,
  overviewAttr,
  textAttr,
  imgAttr,
  columnsAttr,
  legendAttr,
  attributesAttr,
  pageAttr,
  variablesAttr,
  unitconvert
) {
  // Module
  var mod = angular.module('print', ['colorpicker.module']);
  // Services
  mod.factory('PrintModelFactory', PrintModelFactory);
  mod.factory('SharedFactory', SharedFactory);
  mod.factory('DocumentFactory', DocumentFactory);

  // Controllers
  mod.controller('PrintModelCtrl', PrintModelCtrl);
  mod.controller('ModelGUICtrl', ModelGUICtrl);
  //directives
  mod.directive('objectInput', objectInput);
  mod.directive('guiMenu', guiMenu);
  mod.directive('legendSketch', legendSketch);
  mod.directive('jsonEditor', jsonEditor);
  mod.directive('guiEditor', guiEditor);

  mod.directive('printAttributes', attributes);
  mod.directive('toolBox', toolBox);
  mod.directive('treeSet', treeSet);

  mod.directive('mapBlock', mapBlock);
  mod.directive('overviewBlock', overviewBlock);
  mod.directive('textBlock', textBlock);
  mod.directive('imgBlock', imgBlock);
  mod.directive('columnsBlock', columnsBlock);
  mod.directive('legendBlock', legendBlock);
  mod.directive('attributesBlock', attributesBlock);
  mod.directive('pageBlock', pageBlock);

  mod.directive('mapAttr', mapAttr);
  mod.directive('overviewAttr', overviewAttr);
  mod.directive('textAttr', textAttr);
  mod.directive('imgAttr', imgAttr);
  mod.directive('columnsAttr', columnsAttr);
  mod.directive('legendAttr', legendAttr);
  mod.directive('attributesAttr', attributesAttr);
  mod.directive('pageAttr', pageAttr);
  mod.directive('variablesAttr', variablesAttr);

  mod.directive('unitconvert', unitconvert);

  //route provider
  mod.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/printmodel/', {
        templateUrl: 'js/XG/modules/' + 'print/views/printmodel.html',
        controller: PrintModelCtrl,
      });
    },
  ]);
  return mod;
});
