'use strict';
define(function() {
  var CalendarFactory = function($http, $rootScope, $q, gaJsUtils) {
    var CalendarFactory = {};

    var resources = {
      event_types: [],
      event: [],
      alerts: {},
    };

    /**
     * Add the missing '#' to eventTypes color when missing
     * @param eventTypes
     */
    const fixEventTypesColor = (eventTypes) => {
      for(let i in eventTypes) {
        if (eventTypes[i].properties.default_color &&
            !eventTypes[i].properties.default_color.startsWith('#')) {
          eventTypes[i].properties.default_color =
              '#' + eventTypes[i].properties.default_color;
        }
      }
    };

    /**
     * Remove the '#' before the color in the eventType for consistency in DB
     * @param eventType
     */
    const formatEventTypeColorForDB = (eventTypes) => {
      for(let i in eventTypes) {
        if (eventTypes[i].properties.default_color &&
            eventTypes[i].properties.default_color.startsWith('#')) {
          eventTypes[i].properties.default_color =
              eventTypes[i].properties.default_color.substring(1);
        }
      }
    }


    /**
     * Class : CalendarFactory
     * Factory WebServices
     */

    /**
     * Function: addevent
     */
    function addevent(senddata) {
      // old events
      var toSend = {};
      if (!angular.isDefined(senddata.collection)) {
        toSend = { collection: senddata };
      } else {
        toSend = senddata;
      }

      var promise = $http.post(
        '/services/{portalid}/calendar/addEvent?f=json',
        toSend
      );

      return promise;
    }
    /**
     * Function: createeventtables
     */
    function createeventtables(senddata, datastore_name) {
      var promise = $http.post(
        '/services/{portalid}/calendar/createEventTables?f=json' +
          '&datastore_name=' +
          datastore_name,
        senddata
      );

      return promise;
    }

    /**
     * Function: geteventsCalendarMode
     */
     function geteventsCalendarMode(
      where,
      start_datetime,
      end_datetime,
      Timezone,
      linkedobjects
    ) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        return defer.promise;
      } else {
        where = where || '1=1';

        /*  var prevDate = new Date(),
                nextDate = new Date();
            prevDate.setMonth(prevDate.getMonth() - 3);
            nextDate.setMonth(nextDate.getMonth() + 36);

            start_datetime = start_datetime || prevDate.toISOString();
            end_datetime = end_datetime || nextDate.toISOString();*/
        start_datetime = start_datetime || '';
        end_datetime = end_datetime || '';
        linkedobjects = linkedobjects || '';
        Timezone = Timezone || '';

        var promise = $http.get(
          '/services/{portalid}/calendar/getEventsCalendarMode?f=json' +
            '&where=' +
            where +
            '&start_datetime=' +
            start_datetime +
            '&end_datetime=' +
            end_datetime +
            '&Timezone=' +
            Timezone +
            '&linkedobjects=' +
            linkedobjects
        );
        promise
          .then((res) => {
            resources.events = res.data.features;
          })
          .catch((err) => {
            err.stack;
          });
        return promise;
      }
    }
    /**
     * Function: getevents
     */
    function getevents(
      where,
      start_datetime,
      end_datetime,
      Timezone,
      linkedobjects
    ) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        return defer.promise;
      } else {
        where = where || '1=1';

        /*  var prevDate = new Date(),
                nextDate = new Date();
            prevDate.setMonth(prevDate.getMonth() - 3);
            nextDate.setMonth(nextDate.getMonth() + 36);

            start_datetime = start_datetime || prevDate.toISOString();
            end_datetime = end_datetime || nextDate.toISOString();*/
        start_datetime = start_datetime || '';
        end_datetime = end_datetime || '';
        linkedobjects = linkedobjects || '';
        Timezone = Timezone || '';

        var promise = $http.get(
          '/services/{portalid}/calendar/getEvents?f=json' +
            '&where=' +
            where +
            '&start_datetime=' +
            start_datetime +
            '&end_datetime=' +
            end_datetime +
            '&Timezone=' +
            Timezone +
            '&linkedobjects=' +
            linkedobjects
        );
        promise
          .then((res) => {
            resources.events = res.data.features;
          })
          .catch((err) => {
            err.stack;
          });
        return promise;
      }
    }

    /**
     * Function: getevents
     */
    function getEventsAllData(where, start_datetime, end_datetime, Timezone) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        return defer.promise;
      } else {
        where = where || '1=1';
        start_datetime = start_datetime || '';
        end_datetime = end_datetime || '';
        Timezone = Timezone || '';
        var promise = $http.get(
          '/services/{portalid}/calendar/getEventsAllData?f=json' +
            '&where=' +
            where +
            '&start_datetime=' +
            start_datetime +
            '&end_datetime=' +
            end_datetime +
            '&Timezone=' +
            Timezone
        );
        promise
          .then((res) => {
            resources.events = res.data.features;
          })
          .catch((err) => {
            err.stack;
          });
        return promise;
      }
    }

    /**
     * Function: getcountevents
     */
    function getcountevents(where, start_datetime, end_datetime, Timezone) {
      var promise = $http.get(
        '/services/{portalid}/calendar/getCountEvents?f=json' +
          '&where=' +
          where +
          '&start_datetime=' +
          start_datetime +
          '&end_datetime=' +
          end_datetime +
          '&Timezone=' +
          Timezone
      );

      return promise;
    }
    /**
     * Function: removeevent
     */
    function removeevent(id) {
      var promise = $http.get(
        '/services/{portalid}/calendar/removeEvent?f=json' + '&id=' + id
      );

      return promise;
    }
    /**
     * Function: removeevent
     */
    function removeeventdetails(id) {
      var promise = $http.get(
        '/services/{portalid}/calendar/removeEventDetails?f=json' + '&id=' + id
      );

      return promise;
    }

    /**
     * Function: updateevent
     */
    function updateevent(senddata) {
      // old events
      var toSend = {};
      if (!angular.isDefined(senddata.collection)) {
        toSend = { collection: senddata };
      } else {
        toSend = senddata;
      }

      var promise = $http.post(
        '/services/{portalid}/calendar/updateEvent?f=json',
        toSend
      );

      return promise;
    }
    /**
     * Function: updateevent
     */
    function updateeventdetails(senddata) {
      // old events
      var toSend = {};
      if (!angular.isDefined(senddata)) {
        toSend = { collection: senddata };
      } else {
        toSend = senddata;
      }

      var promise = $http.post(
        '/services/{portalid}/calendar/updateEventDetails?f=json',
        toSend
      );

      return promise;
    }
    /**
     * Function: geteventtypes
     */
    function geteventtypes(where) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        return defer.promise;
      } else {
        where = where || '1=1';
        var promise = $http.get(
          '/services/{portalid}/calendar/getEventTypes?f=json' +
            '&where=' +
            where
        );
        promise
          .then(function (res) {
            resources.event_types = res.data.features;
          })
          .catch((err) => {
            err.stack;
          });
        return promise;
      }
    }
    /**
     * Function: geteventadditionalinfo
     */
    function geteventadditionaldetails(where) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        return defer.promise;
      } else {
        where = where || '1=1';
        var promise = $http.get(
          '/services/{portalid}/calendar/getEventsAdditionalDetails?f=json' +
            '&where=' +
            where
        );
        promise
          .then(function (res) {
            resources.events.details = res.data.details;
          })
          .catch((err) => {
            err.stack;
          });
        return promise;
      }
    }
    /**
     * Function: geteventadditionalinfo
     */
    function geteventagent(eventId) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/calendar/getEventAgent?f=json' +
            '&eventId=' +
            eventId
        );

        return promise;
      }
    }

    /**
     * Function: addeventtype
     */
    const addeventtype = (eventType) =>  {
      formatEventTypeColorForDB(eventType.features);
      var promise = $http.post(
        '/services/{portalid}/calendar/addEventType?f=json',
        eventType
      );
      promise
        .then(function () {
          $rootScope.$broadcast('editCalendarEventTypes');
        })
        .catch((err) => {
          err.stack;
        });
      return promise;
    }

    /**
     * Function: updateeventtype
     */
    const updateeventtype = (eventType) => {
      formatEventTypeColorForDB(eventType);
      var promise = $http.post(
        '/services/{portalid}/calendar/updateEventType?f=json',
        eventType
      );

      return promise;
    }

    const removeeventtype = (eventTypeId) => {
      return $http.get(
          '/services/{portalid}/calendar/removeEventType?f=json&id=' +
          eventTypeId
      );
    }

    /**
     * Function: updateeventtime
     */
    function updateeventtime(senddata) {
      var promise = $http.post(
        '/services/{portalid}/calendar/updateEventTime?f=json',
        senddata
      );

      return promise;
    }

    /**
     * Function: exporticalendar
     */
    function exporticalendar() {
      var promise = $http.get(
        '/services/{portalid}/calendar/exportICalendar?f=json'
      );

      return promise;
    }

    /**
     * Function: geteventrelations
     */
    function geteventrelations(id) {
      var promise = $http.get(
        '/services/{portalid}/calendar/getEventRelations?f=json' + '&id=' + id
      );

      return promise;
    }

    /**
     * Function: getalerts
     */
    function getalerts() {
      var promise = $http.get('/services/{portalid}/calendar/getAlerts?f=json');
      promise
        .then(function (res) {
          // service level logic if any
          resources.alerts = res.data;
        })
        .catch((err) => {
          err.stack;
        });
      return promise;
    }

    /**
     * Function: getalertsbyeventid
     */
    function getalertsbyeventid(id, created_by) {
      var promise = $http.get(
        '/services/{portalid}/calendar/getAlertsByEventId?f=json' +
          '&id=' +
          id +
          '&created_by=' +
          created_by
      );

      return promise;
    }
    /**
     * Function: getevent
     */
    function getevent(id) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/calendar/getEvent?f=json' + '&id=' + id
        );
        return promise;
      }
    }
    /**
     * Function: getusersbyeventid
     */
    function getusersbyeventid(id) {
      var promise = $http.get(
        '/services/{portalid}/calendar/getUsersByEventId?f=json' + '&id=' + id
      );

      return promise;
    }
    /**
     * Function: cancelevent
     */
    function cancelevent(id,idDossier) {
      var promise = $http.get(
        '/services/{portalid}/calendar/cancelEvent?f=json' + '&id=' + id + '&idDossier=' + idDossier.split('.')[1]
      );

      return promise;
    }
    /**
     * Function: getinvitedevents
     */
    function getinvitedevents(user) {
      user = user || '';
      var promise = $http.get(
        '/services/{portalid}/calendar/getInvitedEvents?f=json' +
          '&user=' +
          user
      );

      return promise;
    }
    /**
     * Function: seteventuserstatus
     */
    function seteventuserstatus(user, id_event, type) {
      user = user || '';
      var promise = $http.get(
        '/services/{portalid}/calendar/setEventUserStatus?f=json' +
          '&user=' +
          user +
          '&id_event=' +
          id_event +
          '&type=' +
          type
      );

      return promise;
    }
    /**
     * Function: updateeventstatus
     */
    function updateeventstatus(senddata) {
      var promise = $http.post(
        '/services/{portalid}/calendar/updateEventStatus?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: addcalendarworkhours
     */
    function addcalendarworkhours(senddata) {
      var promise = $http.post(
        '/services/{portalid}/calendar/addCalendarWorkHours?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: getcalendarworkhours
     */
    function getcalendarworkhours() {
      var promise = $http.get(
        '/services/{portalid}/calendar/getCalendarWorkHours?f=json'
      );

      return promise;
    }
    /**
     * Function: updatecalendarworkhours
     */
    function updatecalendarworkhours(senddata) {
      var promise = $http.post(
        '/services/{portalid}/calendar/updateCalendarWorkHours?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: exportcalendarpdf
     */
    function exportcalendarpdf() {
      var promise = $http.get(
        '/services/{portalid}/calendar/exportCalendarPDF?f=json'
      );

      return promise;
    }
    /**
     * Function: gettaskbyeventid
     */
    function gettaskbyeventid(id_event) {
      var promise = $http.get(
        '/services/{portalid}/calendar/getTaskByEventId?f=json' +
          '&id_event=' +
          id_event
      );

      return promise;
    }
    /**
     * Function: transferteventuser
     */
    function transferteventuser(
      user_from,
      user_to,
      dateFromTimeInMillis,
      dateToTimeInMillis
    ) {
      var promise = $http.get(
        '/services/{portalid}/calendar/transfertEventUser?f=json' +
          '&user_from=' +
          user_from +
          '&user_to=' +
          user_to +
          '&dateFromTimeInMillis=' +
          dateFromTimeInMillis +
          '&dateToTimeInMillis=' +
          dateToTimeInMillis
      );

      return promise;
    }
    /**
     * Function: getEventsByAgent
     */
    function getEventsByAgent(agent, start_datetime, end_datetime) {
      start_datetime = start_datetime || '';
      end_datetime = end_datetime || '';

      var promise = $http.get(
        '/services/{portalid}/calendar/getEventsByAgent?f=json' +
          '&agent=' +
          agent +
          '&start_datetime=' +
          start_datetime +
          '&end_datetime=' +
          end_datetime
      );
      promise
        .then(function (res) {
          resources.events = res.data.features;
        })
        .catch((err) => {
          err.stack;
        });
      return promise;
    }
    /**
     * Function: getEventByControl
     */
    function getEventByControl(controleId) {
      var promise = $http.get(
        '/services/{portalid}/calendar/getEventByControl?f=json' +
          '&controleId=' +
          controleId
      );
      promise
        .then(function (res) {
          resources.events = res.data.features;
        })
        .catch((err) => {
          err.stack;
        });
      return promise;
    }
    /**
     * Function: updatecalendarworkhours
     */
    function priseRdvsAuto(senddata) {
      // retrait des jours de weekend
      if (Object.keys(senddata).includes('interval')) {
        if (Object.keys(senddata.interval).includes('SATURDAY')) {
          delete senddata.interval.SATURDAY
        }
        if (Object.keys(senddata.interval).includes('SUNDAY')) {
          delete senddata.interval.SUNDAY
        }
      }
      var urlAppName = '&appname=' + gaJsUtils.getAppName();
      var promise = $http.post(
        '/services/{portalid}/calendar/priseRdvsAuto?f=json' + urlAppName,
        senddata
      );

      return promise;
    }
    /**
     * Function: updatecalendarworkhours
     */
    function getAvailableSlots(senddata) {
      var promise = $http.post(
        '/services/{portalid}/calendar/getAvailableSlots?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: updatecalendarworkhours
     */
    function cancelRdvsAuto(senddata) {
      var promise = $http.post(
        '/services/{portalid}/calendar/cancelRdvsAuto?f=json' +
          '&appname=' +
          gaJsUtils.getAppName(),
        senddata
      );

      return promise;
    }
    /**
     * Function: updatecalendarworkhours
     */
    function saveComment(senddata, commentType, commentDay) {
      var promise = $http.post(
        '/services/{portalid}/calendar/saveComments?f=json' +
          '&commenttype=' +
          commentType +
          '&commentday=' +
          commentDay,
        senddata
      );
      return promise;
    }
    /**
     * Function: updatecalendarworkhours
     */
    function getComment(commentType, commentDay) {
      var promise = $http.get(
        '/services/{portalid}/calendar/getComments?f=json' +
          '&commenttype=' +
          commentType +
          '&commentday=' +
          commentDay
      );

      return promise;
    }

    // the type may be the id of the event
    function getCommentByType(commentType) {
      var promise = $http.get(
        '/services/{portalid}/calendar/getCommentsByType?f=json' +
          '&commenttype=' +
          commentType
      );

      return promise;
    }
    // Function to get the hours of the last added event
    const getLastAddedHoursEvent = (id) => {
      const promise = $http.get(
        '/services/{portalid}/calendar/getLastAddedHoursEvent?f=json' +
          '&id=' +
          id
      )
      return promise;
    }
    /*
    * Suppression des "relations" des rdv annulés
    */
    const deleteEventRelation = (idOfEventToDelete, idControle, idDossier) => {
      const promise =   $http.get(
        '/services/{portalid}/calendar/deleteEventRelation?f=json' +
          '&idEvent=' + idOfEventToDelete + '&idControle=' +idControle + '&idDossier=' +idDossier
      )
      return promise;
    }
    // Fonction qui verifie si une creneau choisi en mode automatique est déjà occupé par un autre event
    const checkSameTimeEvent = (agent, dateDebut, dateFin) => {
      let promise = $http.post(
        '/services/{portalid}/calendar/checkSameTimeEvent?f=json' +
          '&agent=' +
          agent +
          '&dateDebut=' +
          dateDebut +
          '&dateFin=' +
          dateFin 
      )
      return promise;
    }

    return {
      CalendarFactory: CalendarFactory,
      resources: resources,
      addevent: addevent,
      createeventtables: createeventtables,
      /*    getcalendardatastore:getcalendardatastore,*/
      getevents: getevents,
      getEventsAllData:getEventsAllData,
      getcountevents: getcountevents,
      removeevent: removeevent,
      removeeventdetails: removeeventdetails,
      updateevent: updateevent,
      updateeventdetails: updateeventdetails,
      geteventtypes: geteventtypes,
      geteventadditionaldetails: geteventadditionaldetails,
      geteventagent: geteventagent,
      addeventtype: addeventtype,
      updateeventtype: updateeventtype,
      removeeventtype: removeeventtype,
      updateeventtime: updateeventtime,
      exporticalendar: exporticalendar,
      geteventrelations: geteventrelations,
      getalerts: getalerts,
      getalertsbyeventid: getalertsbyeventid,
      getevent: getevent,
      getusersbyeventid: getusersbyeventid,
      cancelevent: cancelevent,
      getinvitedevents: getinvitedevents,
      seteventuserstatus: seteventuserstatus,
      updateeventstatus: updateeventstatus,
      addcalendarworkhours: addcalendarworkhours,
      getcalendarworkhours: getcalendarworkhours,
      updatecalendarworkhours: updatecalendarworkhours,
      exportcalendarpdf: exportcalendarpdf,
      gettaskbyeventid: gettaskbyeventid,
      transferteventuser: transferteventuser,
      getEventsByAgent: getEventsByAgent,
      getEventByControl: getEventByControl,
      priseRdvsAuto: priseRdvsAuto,
      getAvailableSlots: getAvailableSlots,
      cancelRdvsAuto: cancelRdvsAuto,
      getComment: getComment,
      getCommentByType: getCommentByType,
      saveComment: saveComment,
      fixEventTypesColor: fixEventTypesColor,
      geteventsCalendarMode: geteventsCalendarMode,
      getLastAddedHoursEvent: getLastAddedHoursEvent,
      deleteEventRelation: deleteEventRelation,
      checkSameTimeEvent:checkSameTimeEvent
    };
  };
  CalendarFactory.$inject = ['$http', '$rootScope', '$q', 'gaJsUtils'];
  return CalendarFactory;
});
