'use strict';

define(['angular', 'modules/translations/controllers/LangCtrl'], function(
  angular,
  LangCtrl
) {
  // module
  var mod = angular.module('translation', ['pascalprecht.translate']);

  // TODO : Inject those correctly...
  mod.controller('LangCtrl', [
    '$scope',
    '$translate',
    '$rootScope',
    'ngDialog',
    '$http',
    'gaJsUtils',
    'tmhDynamicLocale',
    function(
      $scope,
      $translate,
      $rootScope,
      ngDialog,
      $http,
      gaJsUtils,
      tmhDynamicLocale
    ) {
      $scope.translateToIso = {
        en: 'gb',
        de: 'de',
        fr: 'fr',
        es: 'es',
        pl: 'pl',
        km: 'kh',
        'zh-CN': 'cn',
        ar: false,
      };

      $scope.currentLanguage =
        $scope.translateToIso[$translate.preferredLanguage()] || 'fr';

      $scope.changeLang = function(key) {
        $translate.use(key);
        localStorage.setItem('current_language', key);
        $scope.currentLanguage = $scope.translateToIso[key];
        $rootScope.$broadcast('localeChanged');
        tmhDynamicLocale.set(key);
      };

      $scope.dropdown = [
        {
          text: "<i class='flag flag-gb'></i> English",
          click: "changeLang('en')",
        },
        {
          text: "<i class='flag flag-de'></i> Deutsch",
          click: "changeLang('de')",
        },
        {
          text: "<i class='flag flag-fr'></i> Français",
          click: "changeLang('fr')",
        },
        {
          text: "<i class='flag flag-pl'></i> Polski",
          click: "changeLang('pl')",
        },
        {
          text: "<i class='flag flag-es'></i> Español",
          click: "changeLang('es')",
        },
        {
          text: "<i class='flag flag-kh'></i> ភាសាខ្មែរ",
          click: "changeLang('km')",
        },
        {
          text: "<i class='flag flag-cn'></i> 中文",
          click: "changeLang('zh-CN')",
        },
        {
          text: ' اللغة العربية‎',
          click: "changeLang('ar', false)",
        },
      ];

      // test rb @ change language on the fly
      $scope.toggleEditLanguageMode = function() {
        $rootScope.xgos.editlanguage = !$rootScope.xgos.editlanguage;
      };
      $rootScope.$on('languageEdition', function(event, args) {
        $scope.editLanguage = args.id;

        // get translations
        // Todo: this is just an example, MAKE IT LOAD ONLY ONCE :o
        $http
          .get('js/XG/modules/translations/locale-fr.json')
          .then(function(res) {
            $scope.fr = gaJsUtils.checkNestedProperty(
              $scope.editLanguage,
              res.data
            );
          });
        $http
          .get('js/XG/modules/translations/locale-en.json')
          .then(function(res) {
            $scope.en = gaJsUtils.checkNestedProperty(
              $scope.editLanguage,
              res.data
            );
          });
        $http
          .get('js/XG/modules/translations/locale-de.json')
          .then(function(res) {
            $scope.de = gaJsUtils.checkNestedProperty(
              $scope.editLanguage,
              res.data
            );
          });
        $http
          .get('js/XG/modules/translations/locale-pl.json')
          .then(function(res) {
            $scope.pl = gaJsUtils.checkNestedProperty(
              $scope.editLanguage,
              res.data
            );
          });
        $http
          .get('js/XG/modules/translations/locale-es.json')
          .then(function(res) {
            $scope.es = gaJsUtils.checkNestedProperty(
              $scope.editLanguage,
              res.data
            );
          });
        $http
          .get('js/XG/modules/translations/locale-zh-CN.json')
          .then(function(res) {
            $scope.cn = gaJsUtils.checkNestedProperty(
              $scope.editLanguage,
              res.data
            );
          });

        ngDialog.open({
          template:
            'js/XG/modules/translations/views/modals/language.editor.html',
          className: 'ngdialog-theme-plain width800',
          closeByDocument: false,
          scope: $scope,
        });
      });
    },
  ]);

  mod.config([
    '$translateProvider',
    '$translatePartialLoaderProvider',
    function($translateProvider, $translatePartialLoaderProvider, $rootScope) {
      if (typeof ftiFactory !== 'undefined') {
        $translatePartialLoaderProvider.addPart(
          'js/XG/modules/translations/locale'
        );
        $translateProvider.useLoader('$translatePartialLoader', {
          urlTemplate: '{part}-{lang}.json',
        });
        //var response = ftiFactory.getTranslate();
      } else {
        $translatePartialLoaderProvider.addPart(
          'js/XG/modules/translations/locale'
        );
        /*$rootScope.$watch('portalChosen',function(portalChosen){
            console.log(portalChosen);
        });*/

        $translatePartialLoaderProvider.addPart(
          '/services/{portalid}/translation/model'
        );
        $translateProvider.useLoader('$translatePartialLoader', {
          urlTemplate: '{part}-{lang}.json',
        });
        /*$translateProvider.useStaticFilesLoader({
         prefix: 'js/XG/modules/translations/locale-',
         suffix: '.json'
         });*/
      }

      var preferredLanguage = localStorage.getItem('current_language')
        ? localStorage.getItem('current_language')
        : 'fr';
      $translateProvider.preferredLanguage(preferredLanguage);
      $translateProvider.fallbackLanguage('fr');
      $translateProvider.useMissingTranslationHandlerLog();
      $translateProvider.useMissingTranslationHandler();
      //$translateProvider.useSanitizeValueStrategy('escape');

      //console.log($translateProvider);
    },
  ]);

  return mod;
});