'use strict';

define(function() {
  var adminCtrl = function(
    $scope,
    AncAppFactory,
    $location,
    FeatureTypeFactory,
    $timeout,
    ngDialog,
    gaDomUtils,
    $window,
    EditFactory,
    QueryFactory,
    $sce,
    $filter,
    $translate,
    extendedNgDialog,
    $rootScope,
    FilesFactory,
    StyleFactory,
    IndicatorParamsFactory,
    gaJsUtils,
    $q,
    ElasticFactory,
    ParametersFactory,
    AncAppSearchFactory,
    $interval,
    GeoserverFactory,
    PortalsFactory
  ) {
    // admins only
    if (!AncAppFactory.appCfg.isAdmin) $location.path('/anc/');

    if ($location.search()['initdb']) {
      $location.search('initdb', null);
      $timeout(function() {
        $window.location.reload();
      });
    }

    // kinda hacky but we cannot use  table-fill-page="true"
    // on the datatables because they are not displayed on load
    $timeout(function() {
      $scope.adminTableHeights = window.innerHeight - 300;
    });

    var userRoles = $rootScope.xgos.user.roles.map(function(x) {
      return x.name;
    });

    var moduleFactu = {
      title: 'Facturation',
      key: 'facturation',
      content:
        'js/XG/widgets/ancapp/main/views/admin/admin.facturationPeriode.html',
    };

    if (AncAppFactory.appCfg.main.properties.dolibarr.active) {
      moduleFactu = {
        title: 'Facturation',
        key: 'facturation',
        content:
          'js/XG/widgets/ancapp/main/views/admin/admin.facturation.dolibarr.html',
      };
    }

    $scope.items = [
      { name: 'foo', id: 1, eligible: true },
      { name: 'bar', id: 2, eligible: false },
      { name: 'test', id: 3, eligible: true },
    ];

    // tabs
    $scope.adminTabs = [
      {
        title: 'Origine des données',
        key: 'liaison',
        content:
          'js/XG/widgets/ancapp/main/views/admin/admin.liaison_tables.html',
      },
      {
        title: 'SPANC',
        key: 'spanc',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.spanc.html',
      },
      {
        title: 'Communes',
        key: 'villes',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.villes.html',
      },
      {
        title: 'Dossiers',
        key: 'dossiers',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.dossiers.html',
      },
      {
        title: 'Contrôles',
        key: 'controles',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.controles.html',
      },
      {
        title: 'Parcelles',
        key: 'parcelles',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.parcelles.html',
      },
      {
        title: 'Organismes',
        key: 'organismes',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.entreprises.html',
      },
      {
        title: 'Demandeurs',
        key: 'demandeurs',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.demandeurs.html',
      },
      {
        title: 'Personnes',
        key: 'personnes',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.personnes.html',
      },
      {
        title: 'Filières',
        key: 'filieres',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.filieres.html',
      },
      {
        title: 'Vidanges',
        key: 'vidange',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.vidanges.html',
      },
      {
        title: 'Cartes',
        key: 'cartes',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.map.html',
      },
      moduleFactu,
      {
        title: 'Documents',
        key: 'tableau_bord',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.dashboard.html',
      },
      {
        title: 'Recherche',
        key: 'recherche',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.recherche.html',
      },
      {
        title: 'Tableaux de bord',
        key: 'tab_bord',
        content:
          'js/XG/widgets/ancapp/main/views/admin/admin.tableau_bord.html',
      },
      {
        title: 'Modèles des éléments de filière',
        key: 'templates',
        content:
          'js/XG/widgets/ancapp/main/views/admin/admin.template_filiere.html',
      },
      {
        title: 'Agenda',
        key: 'calendar',
        content:
          'js/XG/widgets/ancapp/main/views/admin/admin.calendar_directive.html',
      },
    ];

    if (AncAppFactory.appCfg.main.properties.gestionCivilites === true) {
      $scope.adminTabs.splice(1, 0, {
        title: 'Gestion des civilités',
        key: 'general',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.general.html',
      });
    }

    if (
      AncAppFactory.appCfg.main.properties.gestionListesDeroulantes === true
    ) {
      $scope.listesDeroulantesTab = {
        title: 'Listes déroulantes',
        key: 'listes_deroulantes',
        content:
          'js/XG/modules/common/views/admin.listes_deroulantes.tabs.html',
        childrenTabsNames: {
          0: 'listesDeroulantesFiliere',
          1: 'listesDeroulantesDossierEtControles',
        },
        childrenTabsData: [
          {
            title: 'Listes déroulantes des éléments de filière',
            key: 'listesDeroulantesFiliere',
            content: 'js/XG/modules/common/views/admin.listes_deroulantes.html',
          },
          {
            title: 'Listes déroulantes des dossiers/contrôles',
            key: 'listesDeroulantesDossierEtControles',
            content: 'js/XG/modules/common/views/admin.listes_deroulantes.html',
          },
        ],
      };

      $scope.listeDeroulantesSources = {
        listesDeroulantesFiliere: [
          {
            name: 'Listes déroulantes des éléments de filière',
            value: [],
          },
        ],
        listesDeroulantesDossierEtControles: [
          {
            name: 'Listes déroulantes des dossiers',
            value: [
              'kis_anc_dossier',
              'kis_anc_vidange',
              'kis_anc_dossier_proprietaire',
            ],
          },
          {
            name: 'Listes déroulantes des contrôles',
            value: ['kis_anc_listes_deroulantes_controles'],
          },
        ],
      };

      AncAppFactory.getElementFiliereData('element').then(response => {
        let listeElementsFiliere = response.data.features;
        listeElementsFiliere.forEach(element => {
          let identifiant = element.properties.identifiant;
          $scope.listeDeroulantesSources.listesDeroulantesFiliere[0].value.push(
            identifiant
          );
        });
        $scope.adminTabs.push($scope.listesDeroulantesTab);
      });
    }

    // Pas sur que ca soit tjrs d'actualité ?!
    if (
      userRoles.indexOf('ANCadmin') === -1 &&
      userRoles.indexOf('rootUser') === -1
    ) {
      $scope.adminTabs.splice($scope.adminTabs.length - 1, 1);
    }

    if ($rootScope.xgos.isroot === true) {
      $scope.editAncObj = {
        data: angular.copy(AncAppFactory.appCfg.main),
        options: { mode: 'tree' },
      };
      $scope.adminTabs.push({
        title: '[ROOT] Paramétrage super admin g2c',
        key: 'supervision',
        content: 'js/XG/widgets/ancapp/main/views/admin/admin.supervision.html',
      });
    }

    $scope.civilites = angular.copy(
      AncAppFactory.appCfg.main.properties.civilites
    );

    $scope.saveFullCfg = function() {
      // Mise à jour du appCfg.main au cas où le billingQuery aurait changé
      AncAppFactory.appCfg.main = angular.copy($scope.editAncObj.data);
      AncAppFactory.updateAppCfg();
      require('toastr').success('Configuration mise à jour');
    };

    $scope.apptype = 'anc';

    // tab actif selon hash (key) ex : #recherche pour aller a l'onglet recherche
    var activeTab = 0;
    if ($location.hash() != null) {
      for (var i in $scope.adminTabs) {
        if ($scope.adminTabs[i].key == $location.hash()) {
          activeTab = i;
          break;
        }
      }
    }

    $scope.adminTabs.activeTab = activeTab;
    let addedValueToFeature = false;

    var triggerAutoSave = function(tab) {
      switch (tab) {
        case 'vidange':
          $scope.saveVidangeCfg(true);
          break;
        case 'cartes':
          $scope.$broadcast('checkIfDirtyMapCfg');
          break;
        case 'spanc':
        case 'villes':
          $scope.enregistrerInfoSpanc(true);
          break;
        case 'dossiers':
          $scope.$broadcast('checkIfDirtyDossierCfg');
          break;
        case 'listes_deroulantes':
          $scope.reloadPageValueAdded(addedValueToFeature);
        // case "tableau_bord":
        //     $scope.$broadcast('checkIfDirtyDocumentCfg');
        //     break;
        case 'controles':
          $scope.$broadcast('checkIfDirtyControleCfg');
          break;
        // case "facturation":
        //     $scope.$broadcast('checkIfDirtyFacturationCfg');
      }
    };

    $rootScope.$on('modelValueChanged', function(event, data) {
      addedValueToFeature = true;
    });

    $rootScope.$on('$routeChangeStart', function(event, next, curent) {
      if (
        angular.isDefined($scope.adminTabs.activeTab) &&
        $scope.adminTabs.activeTab !== -1
      )
        triggerAutoSave($scope.adminTabs[$scope.adminTabs.activeTab].key);
    });

    // empeche de fermer la fenetre / changer de page si indexation en cours
    $scope.$on('$locationChangeStart', function(event, next, current) {
      if ($scope.indexationEncours) {
        var ans = confirm(
          'Attention ! Indexation en cours ! Êtes-vous certain de vouloir continuer ? '
        );
        if (!ans) event.preventDefault();
      }
    });

    var dontCheckActiveTab = false;
    $timeout(function() {
      $scope.$watch('adminTabs.activeTab', function(next, previous) {
        // on vient d'annuler le changement d'onglet, skip le fonctionnement ce tour
        if (dontCheckActiveTab) {
          dontCheckActiveTab = false;
          return;
        }
        // ssi indexation en cours
        if ($scope.indexationEncours) {
          var ans = confirm(
            'Attention ! Indexation en cours ! Êtes-vous certain de vouloir continuer ? '
          );
          // continue index
          if (!ans) {
            $scope.adminTabs.activeTab = previous;
            dontCheckActiveTab = true;
            return;
            // stop index
          } else {
            $scope.indexationEncours = false;
          }
        }

        // auto save
        triggerAutoSave($scope.adminTabs[previous].key);
        $scope.adminTabs.activeTab = next;
      });
    });

    $scope.res = {};
    /*----------------------------------------------
     * PERSONNES
     *---------------------------------------------*/

    $scope.personnesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_personne'
    );

    $scope.personnesWhere = " nom <> '' AND nom IS NOT NULL";

    $scope.refreshPersonnes = function() {
      $rootScope.$broadcast('refreshDatatable', {
        uid: $scope.personnesFti.uid,
      });
    };

    var editPersonneModale;
    $scope.openEditPersonneModale = function(personne) {
      $scope.currentPerson = personne || {};
      editPersonneModale = ngDialog.open({
        template: 'js/XG/widgets/ancapp/main/views/modals/modal.person.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /** when a person is edited */
    $scope.editedPerson = function() {
      editPersonneModale.close();
      $scope.refreshPersonnes();
    };
    $scope.datatablePersonCrud = {
      create: { func: $scope.openEditPersonneModale },
      update: { func: $scope.openEditPersonneModale },
      remove: false,
    };

    $scope.entreprisesCfg = AncAppFactory.appCfg.main.entreprisesCfg;
    $scope.parcellesCfg = AncAppFactory.appCfg.main.parcellesCfg;

    /*
         LISTE DEMANDEURS
         */
    $scope.demandeursFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_demandeur'
    );

    $scope.demandeursWhere = " nom <> '' AND nom IS NOT NULL ";
    $scope.displayTiersCivil =
      AncAppFactory.appCfg.main.properties.dolibarr.active == true;

    var addDemandeurModal;
    $scope.openAddDemandeurModal = function(demandeur) {
      $scope.currentDemandeur = demandeur || {};
      $scope.labelToShow = 'Demandeur';
      addDemandeurModal = ngDialog.open({
        template: 'js/XG/widgets/ancapp/main/views/modals/modal.demandeur.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };
    $scope.datatableDemandeurCrud = {
      create: { func: $scope.openAddDemandeurModal },
      update: { func: $scope.openAddDemandeurModal },
      remove: false,
    };

    $scope.saveDemandeur = function() {
      var featureCollection = {
        type: 'FeatureCollection',
        features: [],
      };

      gaDomUtils.showGlobalLoader();

      if (angular.isUndefined($scope.currentDemandeur.id)) {
        featureCollection.features.push({
          type: 'Feature',
          properties: $scope.currentDemandeur.properties,
        });
        EditFactory.add($scope.demandeursFti.uid, featureCollection).then(
          function(res) {
            require('toastr').success('Enregistré');
            addDemandeurModal.close();
            gaDomUtils.hideGlobalLoader();
            $rootScope.$broadcast('refreshDatatable', {
              uid: $scope.demandeursFti.uid,
            });
          }
        );
      } else {
        featureCollection.features.push($scope.currentDemandeur);
        EditFactory.update($scope.demandeursFti.uid, featureCollection).then(
          function(res) {
            require('toastr').success('Enregistré');
            addDemandeurModal.close();
            gaDomUtils.hideGlobalLoader();
            $rootScope.$broadcast('refreshDatatable', {
              uid: $scope.demandeursFti.uid,
            });
          }
        );
      }
    };

    /*
         LISTE ENTREPRISE
         */

    if ($scope.entreprisesCfg) {
      $scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
        AncAppFactory.appCfg.main.datastore,
        $scope.entreprisesCfg.emplacement
      );

      $scope.displayAttributesEntreprise = [];
      if (Array.isArray($scope.entreprisesFti.attributes)) {
        $scope.entreprisesFti.attributes.forEach(function(att) {
          if (
            ~[
              'nom',
              'type',
              'siret',
              'num_tel',
              'num_port',
              'fax',
              'email',
              'adresse_num_rue',
              'adresse_num_rue_extra',
              'adresse_rue',
              'adresse_ville',
              'adresse_cp',
              'adresse_bp',
              'adresse_pays',
              'adresse_batiment',
              'adresse_appt',
              'adresse_etage',
              'adresse_escalier',
              'adresse_complement',
              'actif',
            ].indexOf(att.name)
          ) {
            if (att.name === 'type') {
              $scope.displayAttributesEntreprise.splice(0, 0, att);
            } else {
              $scope.displayAttributesEntreprise.push(att);
            }
          }
        });
      }
        

      $scope.entrepriseWhere =
        ' ' +
        $scope.entreprisesCfg.fields.nom +
        ' IS NOT NULL AND ' +
        $scope.entreprisesCfg.fields.nom +
        " <> '' ";

      var addEntrepriseModal;
      $scope.openAddEntrepriseModal = function(Entreprise) {
        $scope.currentEntreprise = Entreprise || {};
        if (!Entreprise) {
          $scope.currentEntreprise.properties = {};
          $scope.currentEntreprise.properties.actif = true;
        }

        addEntrepriseModal = ngDialog.open({
          template:
            'js/XG/widgets/ancapp/main/views/modals/modal.entreprise.html',
          className: 'ngdialog-theme-plain width800 miniclose nopadding',
          closeByDocument: false,
          scope: $scope,
        });
      };

      $scope.datatableEntrepriseCrud = {
        create: { func: $scope.openAddEntrepriseModal },
        update: { func: $scope.openAddEntrepriseModal },
        remove: false,
      };
    }

    $scope.saveEntreprise = function() {
      var featureCollection = {
        type: 'FeatureCollection',
        features: [],
      };

      gaDomUtils.showGlobalLoader();

      if (angular.isUndefined($scope.currentEntreprise.id)) {
        featureCollection.features.push({
          type: 'Feature',
          properties: $scope.currentEntreprise.properties,
        });
        EditFactory.add($scope.entreprisesFti.uid, featureCollection).then(
          function(res) {
            require('toastr').success('Enregistré');
            addEntrepriseModal.close();
            gaDomUtils.hideGlobalLoader();
            $rootScope.$broadcast('refreshDatatable', {
              uid: $scope.entreprisesFti.uid,
            });
          }
        );
      } else {
        featureCollection.features.push($scope.currentEntreprise);
        EditFactory.update($scope.entreprisesFti.uid, featureCollection).then(
          function(res) {
            require('toastr').success('Enregistré');
            addEntrepriseModal.close();
            gaDomUtils.hideGlobalLoader();
            $rootScope.$broadcast('refreshDatatable', {
              uid: $scope.entreprisesFti.uid,
            });
          }
        );
      }
    };

    /*----------------------------------------------
     * LISTE
     *---------------------------------------------*/

    if ($scope.parcellesCfg) {
      $scope.parcellesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
        AncAppFactory.appCfg.main.datastore,
        $scope.parcellesCfg.emplacement
      );

      var addParcelleModal;
      $scope.openAddParcelleModal = function(parcelle) {
        $scope.currentParcelle = parcelle || {};
        addParcelleModal = ngDialog.open({
          template:
            'js/XG/widgets/ancapp/main/views/modals/modal.parcelle.html',
          className: 'ngdialog-theme-plain width800 miniclose nopadding',
          closeByDocument: false,
          scope: $scope,
        });
      };

      $scope.datatableParcelleCrud = {
        create: { func: $scope.openAddParcelleModal },
        update: { func: $scope.openAddParcelleModal },
        remove: false,
      };
      $scope.editedParcelle = function() {
        addParcelleModal.close();
        $scope.refreshParcelles();
      };

      $scope.refreshParcelles = function() {
        $rootScope.$broadcast('refreshDatatable', {
          uid: $scope.parcellesFti.uid,
        });
      };
    }

    /*----------------------------------------------
     * FILIERES
     *---------------------------------------------*/

    $scope.elementFiliereGroupe = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_element_filiere_groupe'
    );
    $scope.elementFiliereType = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_element_filiere_type'
    );
    $scope.elementFiliere = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_element_filiere'
    );

    /*----------------------------------------------
     * Configuration Informations du SPANC
     *---------------------------------------------*/
    $scope.infosSpanc = {};
    $scope.infosSpancAreSet = false;

    var setInfosSpanc = function() {
      if (AncAppFactory.appCfg.main.infosSpanc) {
        $scope.infosSpanc = angular.copy(AncAppFactory.appCfg.main.infosSpanc);
        $scope.bkpInfosSpanc = angular.copy(
          AncAppFactory.appCfg.main.infosSpanc
        );
        $scope.infosSpancAreSet = true;

        $scope.infosSpancListeVillesCfg = angular.copy(
          AncAppFactory.appCfg.main.infosSpancListeVillesCfg
        );
        $scope.bkpInfosSpancListeVillesCfg = angular.copy(
          AncAppFactory.appCfg.main.infosSpancListeVillesCfg
        );
        $scope.listeDesVilles = $scope.infosSpancListeVillesCfg.filter(
          element => element.extra_ville !== true
        );
        $scope.listeDesVillesExtra = $scope.infosSpancListeVillesCfg.filter(
          element => element.extra_ville === true
        );
        $scope.select_dsp_regie = [
          { id: '0', title: 'DSP' },
          { id: '1', title: 'Régie' },
        ];
        if (!angular.isDefined($scope.listeDesVilles))
          $scope.listeDesVilles = [];

        $scope.listeDesCC = angular.copy(
          AncAppFactory.appCfg.main.properties.infosSpancListeCCCfg
        );
        $scope.bkpListeDesCC = angular.copy(
          AncAppFactory.appCfg.main.properties.infosSpancListeCCCfg
        );
        if (!angular.isDefined($scope.listeDesCC)) $scope.listeDesCC = [];
      }
    };

    $scope.getDspOrRegie = function(ville) {
      if (angular.isDefined(ville.dsp_regie)) {
        if (ville.dsp_regie == 0) {
          return 'DSP';
        } else if (ville.dsp_regie == 1) {
          return 'Régie';
        }
      }
    };

    setInfosSpanc();

    var testIfModified = function(tmpData, tmpNewData) {
      var cleanData = gaJsUtils.removeEmpty(tmpData, true);
      var cleanNewData = gaJsUtils.removeEmpty(tmpNewData, true);

      if (JSON.stringify(cleanData) != JSON.stringify(cleanNewData))
        return true;
      else return false;
    };

    $scope.enregistrerInfoSpanc = function(checkDirty) {
      if (angular.isDefined(checkDirty) && checkDirty) {
        if (
          testIfModified($scope.infosSpanc, $scope.bkpInfosSpanc) ||
          testIfModified(
            $scope.infosSpancListeVillesCfg,
            $scope.bkpInfosSpancListeVillesCfg
          ) ||
          testIfModified($scope.listeDesCC, $scope.bkpListeDesCC)
        )
          var ans = confirm(
            'Des données ne sont pas sauvegardées. Voulez-vous les enregistrer ?'
          );
      }

      if (angular.isUndefined(checkDirty) || (checkDirty && ans)) {
        AncAppFactory.appCfg.main.infosSpanc = $scope.infosSpanc;
        AncAppFactory.appCfg.main.infosSpancListeVillesCfg =
          $scope.infosSpancListeVillesCfg;
        AncAppFactory.appCfg.main.properties.infosSpancListeCCCfg =
          $scope.listeDesCC;
        AncAppFactory.updateAppCfg().then(function() {
          setInfosSpanc();
        });
      } else if (checkDirty && !ans) {
        setInfosSpanc();
      }
    };

    $scope.reloadPageValueAdded = function(addedValue) {
      if (addedValue) {
        alert('Des restrictions ont été ajoutées. La page va être rechargée.');
        $window.location.reload();
        addedValueToFeature = false;
      }
    };

    /**
     * uploadSpancLogo
     * @param input
     */
    $scope.uploadSpancLogo = function(input) {
      $scope.staticFile = input.files[0];

      if ($scope.staticFile.size >= 1024 * 100) {
        require('toastr').error(
          'Le poids du fichier est supérieur à la limite autorisée (100kb).'
        );
        return;
      }

      var fd = new FormData();
      fd.append('file', $scope.staticFile);

      gaDomUtils.showGlobalLoader();
      FilesFactory.uploadprocess(fd).then(function(data) {
        $scope.infosSpanc.logo =
          '/services/' +
          PortalsFactory.getPortalId() +
          '/files/getfile?fileName=' +
          $scope.staticFile.name;
        gaDomUtils.hideGlobalLoader();
      });
    };

    $scope.removeLogo = function() {
      delete $scope.infosSpanc.logo;
    };

    /*----------------------------------------------
     * datatable element Filiere Groupes Crud
     *---------------------------------------------*/
    var elementFiliereGroupesDialog;

    $scope.elementFiliereGroupesDialog = function(group) {
      $scope.currentGroup = group || {};

      elementFiliereGroupesDialog = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/modals/modal.elementFiliereGroupesDialog.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.datatableelementFiliereGroupesCrud = {
      create: { func: $scope.elementFiliereGroupesDialog },
      update: { func: $scope.elementFiliereGroupesDialog },
      remove: false,
    };

    $scope.addUpdateElementFiliereGroup = function() {
      if (angular.isUndefined($scope.currentGroup.properties)) {
        require('toastr').error('Il manque des informations.');
        return false;
      }

      if ($scope.currentGroup.properties.nom == '') {
        require('toastr').error('Il manque des informations.');
        return false;
      }

      var senddata = {
        type: 'FeatureCollection',
        features: [$scope.currentGroup],
      };

      if (!$scope.currentGroup.id) {
        EditFactory.add($scope.elementFiliereGroupe.uid, senddata).then(
          function(res) {
            require('toastr').success('Enregistré');
            updateElementFiliereGroupeAffichage();
            $rootScope.$broadcast('refreshDatatable', {
              uid: $scope.elementFiliereGroupe.uid,
            });
          }
        );
      } else {
        EditFactory.update($scope.elementFiliereGroupe.uid, senddata).then(
          function(res) {
            require('toastr').success('Enregistré');
            updateElementFiliereGroupeAffichage();
            $rootScope.$broadcast('refreshDatatable', {
              uid: $scope.elementFiliereGroupe.uid,
            });
          }
        );
      }

      elementFiliereGroupesDialog.close();
    };
    /*----------------------------------------------
     * datatable element Types de filière Crud
     *---------------------------------------------*/
    var elementFiliereTypeDialog;
    $scope.FiliereGroupIds = {};

    var elementFiliereGroupes = [];

    $scope.addLayerGroup = function() {
      if (
        angular.isDefined($scope.groupLayer.name) &&
        $scope.groupLayer.name != ''
      )
        GeoserverFactory.addlayergroup($scope.groupLayer).then(function(res) {
          console.log(res);
          delete $scope.groupLayer;
        });
    };

    var groupLayerDialog;
    $scope.addGroupLayerModal = function() {
      $scope.groupLayer = {
        workspaceName: $rootScope.portalChosen,
        layers: [],
        setStyle: false,
        name: '',
      };

      groupLayerDialog = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/modals/modal.addLayerGroupDialog.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    var updateElementFiliereGroupeAffichage = function() {
      QueryFactory.data($scope.elementFiliereGroupe.uid).then(function(res) {
        elementFiliereGroupes = res.data.features;
      });
    };
    updateElementFiliereGroupeAffichage();

    // used to render column values (see renderValue function)
    var remplaceIdGroupAvecNomGroupe = function(id_groupe) {
      var value = id_groupe;
      elementFiliereGroupes.forEach(function(efg) {
        if (efg.id == id_groupe) {
          value = efg.properties.nom;
        }
      });
      return value;
    };

    $scope.renduColonnesTypeFiliere = {
      id_groupe: remplaceIdGroupAvecNomGroupe,
    };

    $scope.elementFiliereTypeDialog = function(type) {
      QueryFactory.data($scope.elementFiliereGroupe.uid).then(function(res) {
        $scope.FiliereGroupFeatures = res.data.features;
      });
      QueryFactory.data($scope.elementFiliereType.uid).then(function(res) {
        $scope.FiliereTypeFeatures = res.data.features;
      });

      $scope.currentType = type || {};

      elementFiliereTypeDialog = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/modals/modal.elementFiliereTypeDialog.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.datatableelementFiliereTypeCrud = {
      create: { func: $scope.elementFiliereTypeDialog },
      update: { func: $scope.elementFiliereTypeDialog },
      remove: false,
    };

    $scope.addUpdateElementFiliereType = function() {
      if (angular.isUndefined($scope.currentType.properties)) {
        require('toastr').error('Il manque des informations.');
        return false;
      }

      if (
        $scope.currentType.properties.nom == '' ||
        $scope.currentType.properties.nom == undefined ||
        $scope.currentType.properties.id_groupe == undefined
      ) {
        require('toastr').error('Il manque des informations.');
        return false;
      }

      var senddata = {
        type: 'FeatureCollection',
        features: [$scope.currentType],
      };

      if (!$scope.currentType.id) {
        EditFactory.add($scope.elementFiliereType.uid, senddata).then(function(
          res
        ) {
          require('toastr').success('Enregistré');
          $rootScope.$broadcast('refreshDatatable', {
            uid: $scope.elementFiliereType.uid,
          });
          updateElementFiliereTypeAffichage();
        });
      } else {
        EditFactory.update($scope.elementFiliereType.uid, senddata).then(
          function(res) {
            require('toastr').success('Enregistré');
            $rootScope.$broadcast('refreshDatatable', {
              uid: $scope.elementFiliereType.uid,
            });
            updateElementFiliereTypeAffichage();
          }
        );
      }

      elementFiliereTypeDialog.close();
    };

    /*----------------------------------------------
     * datatable element filière Crud
     *---------------------------------------------*/

    var elementFiliereDialog, addVectorielFiliereDialog;

    $scope.FiliereTypeFeatures = {};

    var elementFiliereType = [];
    var updateElementFiliereTypeAffichage = function() {
      QueryFactory.data($scope.elementFiliereType.uid).then(function(res) {
        elementFiliereType = res.data.features;
      });
    };
    updateElementFiliereTypeAffichage();
    // used to render column values (see renderValue function)
    var remplaceIdGroupAvecNomType = function(id_Type) {
      var value = id_Type;
      elementFiliereType.forEach(function(efg) {
        if (efg.id == id_Type) {
          value = efg.properties.nom;
        }
      });
      return value;
    };

    /**
     * remplaceRepresentationImage
     * @param representation
     * @returns {*}
     */
    var remplaceRepresentationImage = function(representation) {
      var value = representation;

      if (representation != '') {
        var urls = representation.split(';');
        var html = '';
        if (urls.length) {
          for (var i = 0; i < urls.length; i++) {
            html =
              html +
              '<img width="16px" style="margin-right:3px" heigth="16px" src="' +
              urls[i] +
              '" >';
          }
        }
        value = $sce.trustAsHtml('<div>' + html + '</div>');
      } else {
        value = $sce.trustAsHtml(
          '<i class="fa fa-file-image-o disabled"  ></i>'
        );
      }
      return value;
    };
    /**
     * remplaceRepresentationVectorielle
     * @param representation
     * @returns {*}
     */
    var remplaceRepresentationVectorielle = function(representation) {
      var num = representation ? representation.split(';').length : 0;
      return $sce.trustAsHtml('' + num);
    };

    $scope.renduColonnesElementFiliere = {
      id_type: remplaceIdGroupAvecNomType,
      representation: remplaceRepresentationImage,
      representation_vectorielle: remplaceRepresentationVectorielle,
    };

    /**
     * elementFiliereDialog
     * @param element
     */
    $scope.elementFiliereDialog = function(element) {
      FeatureTypeFactory.get().then(function(res) {
        // adapte aux modification de FeatureFactory.get (doit utiliser res et non plus res.data)
        $scope.featureTypesList = res;
      });

      QueryFactory.data($scope.elementFiliereType.uid).then(function(res) {
        $scope.FiliereTypeFeatures = res.data.features;
      });

      $scope.currentElementRepresentationsVectorielles = [];
      if (element) {
        $scope.currentElement = element;
        $scope.currentElementRepresentations = element.properties.representation.split(
          ';'
        );
        if (element.properties.representation_vectorielle) {
          var _tmpx = element.properties.representation_vectorielle.split(';');
          for (var i in _tmpx) {
            var o = _tmpx[i].split(':');
            $scope.currentElementRepresentationsVectorielles.push({
              label: o[0],
              modele: o[1],
            });
          }
        }
      } else {
        $scope.currentElement = {};
        $scope.currentElementRepresentations = [''];
      }

      $scope.bkpCurrentElement = angular.copy($scope.currentElement);

      elementFiliereDialog = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/modals/modal.elementFiliereDialog.html',
        className: 'ngdialog-theme-plain fullScreen nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
        preCloseCallback: function() {
          delete $scope.bkpCurrentElement;
          delete $scope.currentElement;
        },
      });
    };

    /**
     * addRepresentationVectorielleToFiliere
     * Ajout d'une representation vectorielle a l'element de filière
     */
    $scope.addRepresentationVectorielleToFiliere = function() {
      console.log($scope.currentElement);

      addVectorielFiliereDialog = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/modals/modal.bibliothequeElementsFiliere.html',
        className: 'ngdialog-theme-plain fullScreen nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * addVectorielToEf
     * Ajout d'un vectoriel pour l'element de filiere en cours
     */
    $scope.addVectorielToEf = function(x) {
      $scope.currentElementRepresentationsVectorielles.push({
        modele: x.properties.identifiant,
        label: x.properties.nom,
      });
    };

    $scope.removeRepresentationVectorielle = function(index) {
      var ans = confirm(
        'Êtes-vous certain de vouloir supprimer la liaison avec ce symbole ?'
      );
      if (ans) {
        $scope.currentElementRepresentationsVectorielles.splice(index, 1);
      }
    };

    //elements de filiere
    $scope.addRepresentationToFiliere = function() {
      if ($scope.currentElementRepresentations.length <= 5) {
        $scope.currentElementRepresentations.push('');
      }
    };
    $scope.removeRepresentationToFiliere = function(index) {
      $scope.currentElementRepresentations.splice(index, 1);
    };

    var representationElementFiliereDialog;
    /**
     * pickRepresentationElementFiliere
     */
    var currentRepresentationElementFiliereIndex;
    $scope.pickRepresentationElementFiliere = function(index) {
      currentRepresentationElementFiliereIndex = index;
      // force reset image library first
      gaDomUtils.showGlobalLoader();
      StyleFactory.forceresetimagelibrary().then(function() {
        gaDomUtils.hideGlobalLoader();
        representationElementFiliereDialog = ngDialog.open({
          template:
            'js/XG/widgets/ancapp/main/views/modals/modal.element.filiere.representation.html',
          className: 'ngdialog-theme-plain width800 miniclose nopadding',
          closeByDocument: false,
          scope: $scope,
        });
      });
    };
    /**
     * set the image picked from the list
     * @param data
     */
    $scope.setRepresentationImage = function(data) {
      $scope.currentElementRepresentations[
        currentRepresentationElementFiliereIndex
      ] = data.url + '/' + data.img;
      currentRepresentationElementFiliereIndex = false;
      representationElementFiliereDialog.close();
    };

    $scope.datatableelementFiliereElementCrud = {
      create: { func: $scope.elementFiliereDialog },
      update: { func: $scope.elementFiliereDialog },
      remove: false,
    };

    $scope.oldGroupValue = null;
    $scope.setUpdateLayerGroup = function(oldVal) {
      $scope.oldGroupValue = oldVal;
    };

    //Ajouter ou Modifier un element filiere
    $scope.addUpdateElementFiliere = function() {
      if (angular.isUndefined($scope.currentElement.properties)) {
        require('toastr').error('Il manque des informations.');
        return false;
      }

      if (
        $scope.currentElement.properties.alias == '' ||
        $scope.currentElement.properties.alias == undefined ||
        $scope.currentElement.properties.id_type == undefined ||
        $scope.currentElement.properties.identifiant == undefined ||
        $scope.currentElement.properties.geometrie == undefined
      ) {
        require('toastr').error('Il manque des informations.');
        return false;
      }

      if ($scope.currentElementRepresentations.length) {
        $scope.currentElement.properties.representation = '';
        $scope.currentElementRepresentations.forEach(function(url) {
          if (url && url != '') {
            if ($scope.currentElement.properties.representation == '') {
              $scope.currentElement.properties.representation = url;
            } else {
              $scope.currentElement.properties.representation =
                $scope.currentElement.properties.representation + ';' + url;
            }
          }
        });
      }
      if ($scope.currentElementRepresentationsVectorielles.length) {
        $scope.currentElement.properties.representation_vectorielle = $scope.currentElementRepresentationsVectorielles
          .map(function(x) {
            return x.label.trim() + ':' + x.modele;
          })
          .join(';');
      } else {
        $scope.currentElement.properties.representation_vectorielle = '';
      }

      var senddata = {
        type: 'FeatureCollection',
        features: [$scope.currentElement],
      };

      if (!$scope.currentElement.id) {
        EditFactory.add($scope.elementFiliere.uid, senddata).then(function(
          res
        ) {
          require('toastr').success('Enregistré');
          $rootScope.$broadcast('refreshDatatable', {
            uid: $scope.elementFiliere.uid,
          });
        });
      } else {
        EditFactory.update($scope.elementFiliere.uid, senddata).then(function(
          res
        ) {
          require('toastr').success('Enregistré');
          $rootScope.$broadcast('refreshDatatable', {
            uid: $scope.elementFiliere.uid,
          });
        });
      }

      if ($scope.oldGroupValue != null) {
        var oldLayerGroup;
        var newLayerGroup;

        $scope.FiliereTypeFeatures.forEach(function(type) {
          if (type.id == $scope.currentElement.properties.id_type) {
            newLayerGroup = type.properties.layer_group;
          }
          if (type.id == $scope.oldGroupValue) {
            oldLayerGroup = type.properties.layer_group;
          }
        });

        GeoserverFactory.changelayergroupdestination(
          $scope.currentElement.properties.identifiant,
          oldLayerGroup,
          newLayerGroup
        ).then(function(res) {
          console.log(res);
        });

        $scope.oldGroupValue = null;
      }

      elementFiliereDialog.close();
    };

    // scroll to id on page (can't use $location)
    $scope.scrollTo = function(id) {
      $timeout(function() {
        document.getElementById(id).scrollIntoView();
      }, 1);
    };

    //ouvrirFormulaireTemplateDialog
    var nouveauFormulaireTemplateDialog;
    $scope.ouvrirFormulaireTemplateDialog = function() {
      nouveauFormulaireTemplateDialog = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/modals/modal.nouveauFormulaireTemplateDialog.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    //nouveau controletype
    $scope.nouveauEmplacementFormulaire = function(nouveauEmplacement) {
      if (
        angular.isUndefined(nouveauEmplacement) ||
        angular.isUndefined(nouveauEmplacement.label) ||
        angular.isUndefined(nouveauEmplacement.type) ||
        nouveauEmplacement.label == '' ||
        nouveauEmplacement.type == ''
      ) {
        require('toastr').error('Il manque des informations.');
        return false;
      }

      if (angular.isUndefined(nouveauEmplacement.document_types)) {
        nouveauEmplacement.document_types = [];
      }

      $scope.controletype.push(nouveauEmplacement);
      nouveauFormulaireTemplateDialog.close();
    };

    //Supprimer ControleType
    $scope.supprimerControleType = function(index) {
      var r = confirm('Êtes-vous sûr de vouloir supprimer ?');
      if (r == true) {
        AncAppFactory.appCfg.main.controleCfg.splice(index, 1);
      }
    };

    var documentTypeDialog, currentRownIndex, currentColumnIndex;

    $scope.ouvrirDocumentTypeDialog = function(
      rownIndex,
      columnIndex,
      currentDocumentType
    ) {
      currentRownIndex = rownIndex;

      $scope.currentDocumentType = {};

      if (currentDocumentType) {
        $scope.currentDocumentType = angular.copy(currentDocumentType);
        currentColumnIndex = columnIndex;
      }
      documentTypeDialog = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/modals/modal.documentTypeDialog.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    //Listen
    $rootScope.$on('ngDialog.closed', function(event, $dialog) {
      if (
        angular.isUndefined(documentTypeDialog) ||
        angular.isUndefined(documentTypeDialog.id)
      ) {
        return false;
      }

      if (documentTypeDialog.id != $dialog[0].id) {
        return false;
      }
      currentColumnIndex = undefined;
      currentRownIndex = undefined;
    });

    $scope.saveCurrentDocumentType = function() {
      if (currentColumnIndex == undefined) {
        $scope.controletype[currentRownIndex].document_types.push(
          $scope.currentDocumentType
        );
      } else {
        $scope.controletype[currentRownIndex].document_types[
          currentColumnIndex
        ] = $scope.currentDocumentType;
      }
      currentColumnIndex = undefined;
      currentRownIndex = undefined;
      documentTypeDialog.close();
    };

    $scope.supprimerDocumentType = function(rownIndex, columnIndex) {
      var r = confirm('Êtes-vous sûr de vouloir supprimer ?');
      if (r == true) {
        $scope.controletype[rownIndex].document_types.splice(columnIndex, 1);
      }
    };

    /*
         Dossier Doc Cfg
         */

    $scope.dossiersCfg = angular.copy(AncAppFactory.appCfg.main.dossierCfg);

    $scope.jasperIndicatorsTypes = [
      {
        key: 'text',
        label: 'Texte',
      },
      {
        key: 'real',
        label: 'Nombre réel',
      },
      {
        key: 'int',
        label: 'Entier positif',
      },
      {
        key: 'relativeint',
        label: 'Entier relatif',
      },
      {
        key: 'date',
        label: 'Date',
      },
    ];

    /**
     * setJasperIndicators
     */
    var jasperIndicatorsDialog;
    $scope.setJasperIndicators = function(rapport) {
      if (!angular.isDefined(rapport.indicateurs)) rapport.indicateurs = [];
      $scope.currentlyEditeRapport = rapport;
      $scope.indicateurs = angular.copy(rapport.indicateurs);

      jasperIndicatorsDialog = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/admin/modals/modal.jasperindicators.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * removeIndicator
     * @param index
     */
    $scope.removeIndicator = function(index) {
      var ans = confirm('Supprimer cet indicateur ?');
      if (ans) {
        $scope.indicateurs.splice(index, 1);
      }
    };

    /**
     * moveDashboardItem
     * @param index
     * @param direction
     * @returns {boolean}
     */
    $scope.moveDashboardItem = function(index, direction) {
      if (
        (index == 0 && direction == 'up') ||
        (index == $scope.dashboardCfg.length - 1 && direction == 'down')
      )
        return false;
      var newIndex = direction == 'up' ? index - 1 : index + 1;
      $scope.dashboardCfg.splice(
        index,
        0,
        $scope.dashboardCfg.splice(newIndex, 1)[0]
      );
    };

    /**
     * saveIndicators
     */
    $scope.saveIndicators = function() {
      $scope.currentlyEditeRapport.indicateurs = $scope.indicateurs;
      jasperIndicatorsDialog.close();
    };

    /**
     * generateJasperReport
     */
    $scope.generateJasperReport = function(rapport) {
      var jsonParameters = IndicatorParamsFactory.buildJsonParams(
        rapport.indicateurs
      );
      gaDomUtils.showGlobalLoader();

      AncAppFactory.generatereport(
        rapport.fichier.replace('.jasper', ''),
        jsonParameters
      ).then(
        function(res) {
          //AncAppFactory.generatereport(
          gaDomUtils.hideGlobalLoader();
          require('toastr').success(
            "La génération du rapport s'est correctement déroulée."
          );
        },
        function(reason) {
          gaDomUtils.hideGlobalLoader();
          require('toastr').error(
            'Erreur lors de la génération du rapport.\nLes images incluses dans le rapport ont elle été chargées ?'
          );
        }
      );
    };

    /**
     *  Vidanges
     */

    var loadConfigVidanges = function() {
      // liste des formulaires de l'appli
      $scope.controlesTypes = AncAppFactory.appCfg.main.controleCfg.map(
        function(x) {
          return x.type;
        }
      );
      $scope.vidangeTypes = {};
      $scope.vidangeElements = {};
      AncAppFactory.appCfg.main.properties.vidangesCfg.formulaires.map(function(
        x
      ) {
        if ($scope.controlesTypes.indexOf(x) !== -1)
          $scope.vidangeTypes[x] = true;
      });

      // liste des elements de filiere
      var promise = AncAppFactory.getElementFiliereData('*');
      promise.then(function(res) {
        $scope.vidangeEfEligibles = res.data.features;
        AncAppFactory.appCfg.main.properties.vidangesCfg.elements_filiere.map(
          function(x) {
            if (
              $scope.vidangeEfEligibles
                .map(function(x) {
                  return x.properties.identifiant;
                })
                .indexOf(x) !== -1
            ) {
              $scope.vidangeElements[x] = true;
            }
          }
        );
      });
    };

    loadConfigVidanges();
    /**
     * saveVidangeCfg
     * @checkDirty original config object
     */
    $scope.saveVidangeCfg = function(checkDirty) {
      var forms = [];
      for (var key in $scope.vidangeTypes) {
        if ($scope.vidangeTypes[key] == true) forms.push(key);
      }
      var eFs = [];
      for (var key in $scope.vidangeElements) {
        if ($scope.vidangeElements[key] == true) eFs.push(key);
      }

      var vidangesTmpCfg = { formulaires: forms, elements_filiere: eFs };

      if (angular.isDefined(checkDirty) && checkDirty) {
        if (
          !angular.equals(
            vidangesTmpCfg,
            AncAppFactory.appCfg.main.properties.vidangesCfg
          )
        ) {
          var ans = confirm(
            'Des données ne sont pas sauvegardées. Voulez-vous les enregistrer ?'
          );
          if (ans) {
            AncAppFactory.appCfg.main.properties.vidangesCfg = vidangesTmpCfg;
            AncAppFactory.updateAppCfg();
          } else {
            loadConfigVidanges();
            return;
          }
        }
      } else {
        AncAppFactory.appCfg.main.properties.vidangesCfg = vidangesTmpCfg;
        AncAppFactory.updateAppCfg();
      }
    };

    /**
     *  SpancInfo liste des villes
     */

    var nouvelleVilleModale;
    $scope.currentVilleIndex = false;
    var currentVilleIndex = false;
    let reader = new FileReader(),
      blob,
      file;
    let Papa = require('papaparse');

    /**
     * loadCsvFile
     *
     * @param input
     */
    $scope.loadCsvFile = function(input) {
      file = input.files[0];
      // csv only
      if (!~file.name.indexOf('.csv')) {
        require('toastr').error($filter('translate')('csvgeocoder.csv_only'));
        return;
      }
      if (file.size >= 5000000) {
        require('toastr').error(
          $filter('translate')('csvgeocoder.file_too_heavy')
        );
        return;
      }

      reader.readAsText(file, 'utf-8');

      reader.onload = function(e) {
        blob = new Blob([reader.result], {
          type: 'text/csv; charset=utf-8',
        });
        $scope.currentFileName = file.name;
        $scope.csvData = Papa.parse(reader.result, { header: true });

        const csvAttributes = $scope.csvData.data[0];

        $scope.openDialog(csvAttributes);

        // after we load the file we overwrite the input with an empty string so when we try to select the same file it will trigger on-change
        input.value = '';
      };
    };

    $scope.mapLiaisonsToCommunesCSVData = function(data, liaisons) {
      data.forEach(commune => {
        Object.keys(liaisons).forEach(item => {
          const mapId = liaisons[item];
          commune[mapId] = commune[item];
        });
      });

      return data;
    };

    // saving new communes received from a CSV file in the SPANC section
    $scope.save = function() {
      $timeout(function() {
        const liaisons = $scope.selectedLayer.importcfg.liaisons;
        const liaisonsArr = Object.values(liaisons);
        const attributes = $scope.ftisToUse[0].attributes;
        const data = $scope.mapLiaisonsToCommunesCSVData(
          $scope.csvData.data,
          liaisons
        );

        let missingAttributes = [];

        attributes.forEach(attribute => {
          if (attribute.mandatory && liaisonsArr.indexOf(attribute.name) < 0)
            missingAttributes.push(attribute.alias);
        });

        if (missingAttributes.length) {
          require('toastr').error(
            $filter('translate')('modaladdcommune.import_csv.error', {
              fields: missingAttributes.join(', '),
            }),
            '',
            {
              positionClass: 'toast-bottom-left',
            }
          );
        } else {
          let csvFormData = new FormData();
          csvFormData.append('file', JSON.stringify(data));
          gaDomUtils.showGlobalLoader();
          FilesFactory.importcommunescsv(csvFormData).then(function (res) {
            if (res && res.data && res.data.infosSpancListeVillesCfg) {
              $scope.infosSpancListeVillesCfg =
                res.data.infosSpancListeVillesCfg;
              AncAppFactory.appCfg.main.infosSpancListeVillesCfg =
                $scope.infosSpancListeVillesCfg;
              AncAppFactory.updateAppCfg().then(function () {
                setInfosSpanc();
              });
              require('toastr').success(
                $filter('translate')('modaladdcommune.import_csv.success', {
                  added: res.data.inserted,
                  total: res.data.received,
                }),
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
              dialog.close();
              gaDomUtils.hideGlobalLoader();
            }
          });
        }
      });
    };

    let dialog;
    $scope.openDialog = function(csvAttributes) {
      if (dialog) dialog.close();

      let layer = {
        geojson: {
          features: [
            {
              properties: csvAttributes,
            },
          ],
        },
      };

      $scope.selectedLayer = layer;
      $scope.ftid = 'fake-communes-json-ftid';
      $scope.selectedLayer.importcfg = {
        liaisons: {},
        values: {},
        maj: {},
        layer: layer,
        dateattributes: [],
        ftid: $scope.ftid,
        editable: false,
      };

      $scope.ftisToUse = [
        {
          alias: 'Commune JSON',
          attributes: [
            {
              alias: $filter('translate')('modaladdcommune.name'),
              autoCalcul: null,
              isNillable: true,
              mandatory: true,
              name: 'communeName',
              popup: false,
              restrictions: [],
              size: 500,
              type: 'java.lang.String',
            },
            {
              alias: $filter('translate')('modaladdcommune.country'),
              autoCalcul: null,
              isNillable: true,
              mandatory: true,
              name: 'pays',
              popup: false,
              restrictions: [],
              size: 500,
              type: 'java.lang.String',
            },
            {
              alias: $filter('translate')('modaladdcommune.code_insee'),
              autoCalcul: null,
              isNillable: true,
              mandatory: false,
              name: 'insee',
              popup: false,
              restrictions: [],
              size: 500,
              type: 'java.lang.String',
            },
            {
              alias: $filter('translate')('modaladdcommune.postal_code'),
              autoCalcul: null,
              isNillable: true,
              mandatory: false,
              name: 'postalCodes',
              popup: false,
              restrictions: [],
              size: 500,
              type: 'java.lang.String',
            },
            {
              alias: $filter('translate')('modaladdcommune.dsp_regie'),
              autoCalcul: null,
              isNillable: false,
              mandatory: false,
              name: 'dspRegie',
              popup: true,
              restrictions: [],
              size: 1,
              type: 'java.lang.Boolean',
            },
          ],
          name: 'Commune JSON',
          uid: $scope.ftid,
        },
      ];

      $scope.layerAttributes = Object.keys(
        layer.geojson.features[0].properties
      );

      dialog = extendedNgDialog.open({
        template:
          'js/XG/widgets/mapapp/importdxf/views/importdxftemplate.html',
        className:
          'ngdialog-theme-plain overflowY width600 max-height500 nopadding miniclose grayed-background',
        closeByDocument: false,
        scope: $scope,
        title: $filter('translate')('common.import_csv'),
        draggable: true,
      });
    };

    /**
     *
     * @param v
     * @param index
     * @param update
     */
    $scope.openNouvelleVilleDialog = function(v, index, update) {
      if (v) {
        $scope.nouvelle_ville = angular.copy(v);
        let arrayName =
          $scope.nouvelle_ville.extra_ville === true
            ? 'listeDesVillesExtra'
            : 'listeDesVilles';
        currentVilleIndex = $scope[arrayName]
          .map(function(v) {
            return v.value;
          })
          .indexOf(v.value);
      } else {
        $scope.nouvelle_ville = { cp: [''] };
        currentVilleIndex = false;
      }

      $scope.currentVilleIndex = update;
      $scope.openVilleDialog();
    };

    $scope.openNouvelleExtraVilleDialog = function(v, index, update) {
      $scope.nouvelle_ville = { extra_ville: true, cp: [''] };
      $scope.openVilleDialog();
    };

    $scope.openVilleDialog = function() {
      if (nouvelleVilleModale) nouvelleVilleModale.close();

      nouvelleVilleModale = ngDialog.open({
        template: 'js/XG/widgets/ancapp/main/views/modals/modal.ville.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.add_ville_cp = function(cp) {
      $scope.nouvelle_ville.cp.push(undefined);
    };

    $scope.remove_ville_cp = function(index) {
      $scope.nouvelle_ville.cp.splice(index, 1);
    };

    /**
     *
     */
    $scope.updateVille = function() {
      let isExtraVille = $scope.nouvelle_ville.extra_ville === true;
      let arrayName = isExtraVille ? 'listeDesVillesExtra' : 'listeDesVilles';
      let oldVilleName = $scope[arrayName][currentVilleIndex].value;
      let copyVille = angular.copy($scope.nouvelle_ville);
      $scope[arrayName][currentVilleIndex] = copyVille;
      $scope.currentVilleIndex = false;
      let oldVilleIndex = $scope.infosSpancListeVillesCfg.findIndex(
        element =>
          element.value === oldVilleName &&
          ((isExtraVille && element.extra_ville === true) ||
            (!isExtraVille && element.extra_ville !== true))
      );
      $scope.infosSpancListeVillesCfg[oldVilleIndex] = copyVille;
      nouvelleVilleModale.close();
      currentVilleIndex = false;
    };

    /**
     * nouvelleVille
     */
    $scope.nouvelleVille = function() {
      let isExtraVille = $scope.nouvelle_ville.extra_ville === true;
      if (!isExtraVille) {
        $scope.nouvelle_ville.gere_spanc = true;
        $scope.listeDesVilles.push($scope.nouvelle_ville);
      } else {
        $scope.listeDesVillesExtra.push($scope.nouvelle_ville);
      }
      $scope.infosSpancListeVillesCfg.push($scope.nouvelle_ville);
      nouvelleVilleModale.close();
    };

    /**
     *
     * @param index
     */
    $scope.supprimer_ville_spanc = function(ville) {
      let isExtraVille = ville.extra_ville === true;
      let arrayName = isExtraVille ? 'listeDesVillesExtra' : 'listeDesVilles';
      var index = $scope[arrayName].indexOf(ville);
      $scope[arrayName].splice(index, 1);
      let oldVilleIndex = $scope.infosSpancListeVillesCfg.findIndex(
        element =>
          element.value === ville.value &&
          ((isExtraVille && element.extra_ville === true) ||
            (!isExtraVille && element.extra_ville !== true))
      );
      $scope.infosSpancListeVillesCfg.splice(oldVilleIndex, 1);
    };

    $scope.setGereSpanc = function(ville) {
      let isExtraVille = ville.extra_ville === true;
      let oldVilleIndex = $scope.infosSpancListeVillesCfg.findIndex(
        element =>
          element.value === ville.value &&
          ((isExtraVille && element.extra_ville === true) ||
            (!isExtraVille && element.extra_ville !== true))
      );
      $scope.infosSpancListeVillesCfg[oldVilleIndex].gere_spanc =
        ville.gere_spanc;
    };
    /*
            Filtres sur la liste des villes
    */
    $scope.setDefaultVillesFilter = function() {
      $scope.villesfilter = {};
      $scope.extraVillesfilter = {};
    };
    $scope.setDefaultVillesFilter();

    $scope.setGereSpancFilter = function() {
      if ($scope.villesfilter.gere_spanc == 'whatever') {
        delete $scope.villesfilter.gere_spanc;
      }
    };
    $scope.gestionSpancOptions = [
      { k: 'whatever', v: 'Indifférent' },
      { k: true, v: 'Oui' },
      { k: false, v: 'Non' },
    ];

    // Sorting
    $scope.villesExtraOrderBy = { field: 'value', reverse: false };
    $scope.villesOrderBy = { field: 'value', reverse: false };

    $scope.sortBy = function(field, sortObject) {
      if (sortObject.field === field) {
        sortObject.reverse = !sortObject.reverse;
      } else {
        sortObject.field = field;
        sortObject.reverse = false;
      }
    };

    $scope.liste_ville = [];
    AncAppFactory.getdossier_villes().then(function(res) {
      res.data.forEach(function(v) {
        var v_upper = v.charAt(0).toUpperCase() + v.slice(1);
        $scope.liste_ville.push(v_upper);
      });
    });

    $scope.delaitypes = ['jour', 'semaine', 'mois', 'année'];

    /**
     * Communautés de communes
     */
    var nouvelleCCModale;
    var currentCCIndex = false;
    $scope.openNouvelleCCDialog = function(v, index, update) {
      if (v) {
        $scope.nouvelle_cc = angular.copy(v);
        currentCCIndex = $scope.listeDesCC
          .map(function(v) {
            return v.value;
          })
          .indexOf(v.value);
      } else {
        $scope.nouvelle_cc = { adresse_cp: [undefined] };
        currentCCIndex = false;
      }

      $scope.currentCCIndex = update;
      if (nouvelleCCModale) nouvelleCCModale.close();

      nouvelleCCModale = ngDialog.open({
        template: 'js/XG/widgets/ancapp/main/views/modals/modal.cc.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     *
     */
    $scope.updateCC = function() {
      $scope.listeDesCC[currentCCIndex] = angular.copy($scope.nouvelle_cc);
      $scope.currentCCIndex = false;
      nouvelleCCModale.close();
      currentCCIndex = false;
    };

    /**
     * nouvelleCC
     */
    $scope.nouvelleCC = function() {
      var res = true;

      if (res) {
        var slug =
          $scope.nouvelle_cc.value +
          $scope.nouvelle_cc.adresse_ville +
          $scope.nouvelle_cc.adresse_cp;
        $scope.nouvelle_cc.slug = gaJsUtils.slugify(slug);

        $scope.listeDesCC.push($scope.nouvelle_cc);
        nouvelleCCModale.close();
      }
    };

    /**
     *
     * @param index
     */
    $scope.supprimer_CC_spanc = function(cc) {
      $scope.villeDeLaCC = [];
      var ifAns = [];
      $scope.listeDesVilles.map(function(x) {
        ifAns.push(x);
        if (x.communaute_commune === cc.slug) {
          $scope.villeDeLaCC.push(x);
          ifAns[ifAns.length - 1].communaute_commune = '';
        }
      });

      if ($scope.villeDeLaCC.length > 0) {
        var nomVilles = '';

        $scope.villeDeLaCC.forEach(function(ville) {
          nomVilles += ville.value + ' ';
        });

        var ans = confirm(
          'Les ville suivantes : ' +
            nomVilles +
            'font partie de la CC. Êtes-vous sur de vouloir la supprimer ?'
        );

        if (ans) {
          $scope.listeDesVilles = ifAns;
          var index = $scope.listeDesCC.indexOf(cc);
          $scope.listeDesCC.splice(index, 1);
        }
      } else {
        var index = $scope.listeDesCC.indexOf(cc);
        $scope.listeDesCC.splice(index, 1);
      }
    };

    /**
     * Filtres sur la liste des villes
     */
    $scope.setDefaultCCFilter = function() {
      $scope.ccfilter = {};
    };
    $scope.setDefaultCCFilter();

    /*
     * Reglementaire ANC à déplacer dans une directive sans doute
     */

    /*
     * Retrieve list of reglementaire elements
     */
    var svgElementsFiliere;
    var getReglementaire = function() {
      AncAppFactory.getreglementaire('elements').then(function(res0) {
        $scope.reglementaireinfos = 'jamais faite';
        if (res0.data.user_maj != null) {
          $scope.reglementaireinfos =
            res0.data.date_maj + ' par ' + res0.data.user_maj;
        }

        QueryFactory.data($scope.elementFiliere.uid).then(function(res) {
          $scope.listeReglementaire = res0.data;
          svgElementsFiliere = angular.copy(res.data.features);
          $scope.listElementForReg = res.data.features;

          $scope.listeReglementairePourElement = [];
          $scope.currentElementReglementaire = '';
          setSelectableElementReglementaire();
          gaDomUtils.hideGlobalLoader();
        });
      });
    };
    getReglementaire();

    $scope.getElementFiliereAlias = function(name) {
      var alias = '';
      svgElementsFiliere.forEach(function(x) {
        if (x.properties.identifiant == name) alias = x.properties.alias;
      });
      return alias;
    };

    $scope.repVectorielleEfActive =
      angular.isDefined(
        AncAppFactory.appCfg.main.properties.filieresVectorielles
      ) &&
      AncAppFactory.appCfg.main.properties.filieresVectorielles.active == true;

    // colonnes affichees dans l'admin
    $scope.efAttributes = [];
    if (Array.isArray($scope.elementFiliere.attributes)) {
      $scope.elementFiliere.attributes.forEach(function(att) {
        // on ne push pas representation vectorielle si pas activé pour le portail
        if (
          $scope.repVectorielleEfActive ||
          att.name !== 'representation_vectorielle'
        ) {
          $scope.efAttributes.push(att);
        }
      });
    }
      
    /**
     * filieresVectorielles
     */
    $scope.activerFilieresVectorielles = function() {
      if (
        confirm(
          'Êtes-vous certain de vouloir activer le dessin vectoriel des filières'
        )
      ) {
        gaDomUtils.showGlobalLoader();

        var setTypeCana = [];
        if (
          angular.isDefined(AncAppFactory.appCfg.main.properties.configCanas) &&
          AncAppFactory.appCfg.main.properties.configCanas.liste.length > 0
        ) {
          AncAppFactory.appCfg.main.properties.configCanas.liste.forEach(
            function(cana) {
              if (cana.lib != '') {
                if (angular.isUndefined(cana.color)) cana.color = '#000000';
                var x = {};
                x[cana.lib] = cana.color;
                setTypeCana.push(x);
              }
            }
          );

          AncAppFactory.setrepresentationcanavectorielle(setTypeCana).then(
            function(res) {
              if (res.data) {
                AncAppFactory.appCfg.main.mapConfiguration.canaVectorielle = true;
                AncAppFactory.updateAppCfg();

                AncAppFactory.appCfg.main.mapConfiguration.canaVectorielle = true;
                require('toastr').success(
                  'Représentation vectorielle des canalisations activées.',
                  '',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
              } else {
                require('toastr').error(
                  "Erreur à l'activation de la représentation vectorielle des canalisations.",
                  '',
                  {
                    positionClass: 'toast-bottom-left',
                  }
                );
              }
            }
          );
        } else {
          require('toastr').error(
            "Il n'existe pas de représentation des canalisations.",
            '',
            {
              positionClass: 'toast-bottom-left',
            }
          );
        }

        AncAppFactory.activatevectoriel().then(
          function() {
            // activation ok on change dans la config
            AncAppFactory.appCfg.main.properties.filieresVectorielles.active = true;
            AncAppFactory.updateAppCfg();
            require('toastr').success('Activation OK, rechargement en cours.');
            $timeout(function() {
              $window.location.reload();
            }, 3000);
            gaDomUtils.hideGlobalLoader();
          },
          function() {
            require('toastr').error(
              "Une erreur s'est produite lors de l'activation du dessin vectoriel des filières."
            );
            gaDomUtils.hideGlobalLoader();
          }
        );
      }
    };

    /**
     *  Réinitialiser la configuration des symboles
     */
     $scope.reinitialiserConfigurationSymboles = () => {
      gaDomUtils.showGlobalLoader();
      AncAppFactory.reinitialiserConfigurationSymboles().then(
        () => {
          // reset list
          require('toastr').success(
            $filter('translate')('configurationSymbole.succes')
          );
          $timeout(() => {
            $window.location.reload();
          }, 3000);
          gaDomUtils.hideGlobalLoader();
        },
        () => {
          require('toastr').error(
            $filter('translate')('configurationSymbole.error')
          );
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    /**
     * refreshNationalReglementaire
     */
    $scope.refreshNationalReglementaire = function() {
      gaDomUtils.showGlobalLoader();
      AncAppFactory.refreshnationalreglementaire().then(
        function(res) {
          // reset list
          require('toastr').success(
            'Mis à jour avec les valeurs du fichier national.'
          );
          getReglementaire();
        },
        function() {
          require('toastr').error(
            "Une erreur s'est produite lors de la récupération du fichier national."
          );
          gaDomUtils.hideGlobalLoader();
        }
      );
    };
    /**
     * only unsused element can be added to the list
     */
    var setSelectableElementReglementaire = function() {
      var used = $scope.listeReglementaire.elements.map(function(lr) {
        return lr.name;
      });
      if (used.length) {
        var newlist = [];
        $scope.listElementForReg.forEach(function(x, idx) {
          var found = used.indexOf(x.properties.identifiant) != -1;
          if (!found) newlist.push($scope.listElementForReg[idx]);
        });
        $scope.listElementForReg = newlist;
      }
    };

    /**
     * * fetchElementDetail
     */
    $scope.fetchElementDetail = function(element) {
      $scope.currentElementReglementaire = element.name;

      AncAppFactory.getreglementaire(element.name).then(function(res) {
        $scope.listeReglementairePourElement = res.data;
      });
    };

    $scope.pickElementForReg = { v: false };

    /**
     * addElementToReglementaire and remove it from the listElementForReg
     */
    $scope.addElementToReglementaire = function() {
      gaDomUtils.showGlobalLoader();
      var toAdd = { name: $scope.pickElementForReg.v, origine: 'local' };
      AncAppFactory.addreglementaire(toAdd, 'elements', -1).then(
        function() {
          // add to the list so we dont have to reload it form the server
          $scope.listeReglementaire.elements.push(toAdd);
          gaDomUtils.hideGlobalLoader();
          $scope.pickElementForReg = { v: false };
          $('.popover').remove();
          setSelectableElementReglementaire();
        },
        function() {
          gaDomUtils.hideGlobalLoader();
          $scope.pickElementForReg = { v: false };
          $('.popover').remove();
        }
      );
    };

    /**
     * Edit a local model
     */
    var modeleReglementaireDialog, currentModeleReglementaireSave;
    $scope.editModeleReglementaireDialog = function(m) {
      var attributeReglementaire = [];
      var checkRestrict = [];

      // retrieve ftid from name
      $scope.modelefti = FeatureTypeFactory.getFeatureByNameAndDatastore(
        AncAppFactory.appCfg.main.datastore,
        $scope.currentElementReglementaire
      );

      // edit fti to delete restriction
      $scope.ftiWithoutRestrict = angular.copy($scope.modelefti);

      if (angular.isDefined(m)) {
        Object.keys(m.properties).forEach(function(x) {
          attributeReglementaire.push(x);
        });
      }

      attributeReglementaire.forEach(function(attReg) {
        $scope.ftiWithoutRestrict.attributes.forEach(function(attFti, i) {
          if (attFti.name == attReg) {
            checkRestrict.push(i);
          }
        });
      });

      // reset restriction
      checkRestrict.forEach(function(i) {
        if ($scope.ftiWithoutRestrict.attributes[i].restrictions.length > 0) {
          $scope.ftiWithoutRestrict.attributes[i].restrictions = [];
        }
      });

      $scope.newCurrentModel = !m ? true : false;
      $scope.allowEditModele = $scope.newCurrentModel || m.origine == 'local';
      $scope.currentModeleReglementaire = angular.copy(m) || {};
      currentModeleReglementaireSave = angular.copy(
        $scope.currentModeleReglementaire
      );

      modeleReglementaireDialog = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/admin/modals/modal.modele.reglementaire.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * Return whether the user can submit the form
     */
    $scope.checkCanEditModeleReglementaire = function() {
      $scope.modeleReglementaireErrors = { errors: { name_exists: 0 } };
      var canEdit = true;
      if (
        !$scope.currentModeleReglementaire.name ||
        $scope.currentModeleReglementaire.name == ''
      ) {
        canEdit = false;
      }
      $scope.listeReglementairePourElement.elements.forEach(function(e) {
        if (
          e.name == $scope.currentModeleReglementaire.name &&
          e.name != currentModeleReglementaireSave.name
        ) {
          $scope.modeleReglementaireErrors.errors.name_exists = 1;
          canEdit = false;
        }
      });

      return canEdit;
    };

    /**
     * update liste locale
     */
    $scope.editModeleReglementaire = function() {
      var toSubmit = angular.copy($scope.currentModeleReglementaire);
      $scope.modeleReglementaireErrors = false;
      var removeindex = -1;

      // add in the list
      if ($scope.newCurrentModel) {
        toSubmit.origine = 'local';
        $scope.listeReglementairePourElement.elements.push(toSubmit);
      } else {
        // replace in the list
        var nbNational = 0;
        removeindex = $scope.listeReglementairePourElement.elements
          .map(function(x) {
            if (x.origine == 'national') nbNational++;
            return x.name;
          })
          .indexOf(currentModeleReglementaireSave.name);
        $scope.listeReglementairePourElement.elements[removeindex] = toSubmit;
        removeindex -= nbNational;
      }

      modeleReglementaireDialog.close();

      gaDomUtils.showGlobalLoader();
      AncAppFactory.addreglementaire(
        toSubmit,
        $scope.currentElementReglementaire,
        removeindex
      ).then(
        function() {
          gaDomUtils.hideGlobalLoader();
        },
        function() {
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    var controleConfig = AncAppFactory.appCfg.main.controleCfg.map(function(x) {
      return x.type;
    });
    /**
     * Retrieve the list of applicable arguments
     * @param attribute
     * @returns {boolean}
     */
    $scope.displayAttributeForModeleReglementaire = function(attribute) {
      var display = true;
      var beginByCtrl = new RegExp('^ctrl*');
      controleConfig.forEach(function(o) {
        if (
          attribute.name.indexOf(o.toLowerCase() + '_') == 0 ||
          attribute.name.indexOf('ctrl' + o.toLowerCase() + '_') == 0 ||
          attribute.name.indexOf('caj_id_') == 0 ||
          beginByCtrl.test(attribute.name) ||
          attribute.name == 'commentaire'
        ) {
          display = false;
        }
      });
      return display;
    };

    /**
     * removeElementReglementaire
     * @param filename
     * @param removeindex
     */
    $scope.removeElementReglementaire = function(filename, removeindex) {
      var ans = confirm('Confirmer la suppression ?');
      if (ans) {
        var cible =
          filename == 'elements'
            ? $scope.listeReglementaire.elements
            : $scope.listeReglementairePourElement.elements;
        var relativeIndex = 0;
        cible.map(function(x) {
          if (x.origine == 'national') relativeIndex += 1;
        });

        gaDomUtils.showGlobalLoader();
        AncAppFactory.removereglementaire(
          filename,
          removeindex - relativeIndex
        ).then(
          function() {
            cible.splice(removeindex, 1);
            gaDomUtils.hideGlobalLoader();
          },
          function() {
            gaDomUtils.hideGlobalLoader();
          }
        );
      }
    };

    /**
     * check Enchainement
     * @param Enchainement
     */
    $scope.checkEnchainement = function(enchainement, type, index) {
      for (var i = 0; i < $scope.controlesWorkflow.length; i++) {
        if (
          $scope.controlesWorkflow[i].current_controle ==
            enchainement.current_controle &&
          $scope.controlesWorkflow[i].avis == enchainement.avis &&
          index != i
        ) {
          var r = confirm(
            'Un enchaînement de contrôle existe déjà pour ce type de contrôle et cet avis.\n Etes vous sur de vouloir continuer ? '
          );
        }
      }
    };

    /** recherche **/
    $scope.dossierFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_dossier'
    );
    $scope.controleFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_dossier_controle'
    );
    $scope.filiereFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_dossier_filiere'
    );
    $scope.filiereElementFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_dossier_filiere_element'
    );
    $scope.vidangeFormulaireFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_vidange_formulaire'
    );
    $scope.fosseToutesEauxFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
      AncAppFactory.appCfg.main.datastore,
      'kis_anc_ef_fosse_toutes_eaux'
    );

    $scope.showSearch = true;

    $scope.visibleSearch = function() {
      $scope.showSearch = !$scope.showSearch;
    };

    $scope.searchquerydb = undefined;
    $scope.$on('resultelastic', function(event, q, t, r) {
      $scope.searchquerydb = q;
      $scope.searchType = t;
      $scope.searchconfig = r;
      $scope.showSearch = false;
    });

    $scope.resultatElastic = {};
    $scope.resultatElasticdb = {};

    var hgl = function() {
      gaDomUtils.hideGlobalLoader();
    };

    $scope.indexProgress = {
      dossiers: -1,
      controles: -1,
      filieres: -1,
      elemsfiliere: -1,
      vidanges: -1,
      ef: -1,
      json: -1,
    };
    $scope.indexProgressQuantites = angular.copy($scope.indexProgress);

    /**
     * showProgression
     * @param {*} type
     * @param {*} def
     * @param {*} ftiname
     */
    var showProgression = function(type, def, ftiname) {
      var stop = $interval(function() {
        //console.log(def);

        var portalid = PortalsFactory.getPortalId();
        ElasticFactory.getprogressiondetaillee(portalid, ftiname).then(
          function(res) {
            $scope.indexProgressQuantites[type] = res.data.qte;
            var prcent = res.data.prcent;
            // controles
            if (ftiname == 'kis_anc_dossier_controle_reponse' && prcent == 99)
              prcent = 100;

            if (prcent < 100) {
              var p = parseInt(prcent);
              $scope.indexProgress[type] = p;
            } else if (prcent == 100) {
              $interval.cancel(stop);
              $timeout(function() {
                $scope.indexProgress[type] = 100;
                def.resolve();
              }, 100);
            }
          },
          function() {
            $interval.cancel(stop);
          }
        );
      }, 1000);
    };

    var fastIndexing = true;
    /**
     * pre_indexcontroles
     */
    $scope.pre_indexcontroles = function() {
      var def = $q.defer();

      AncAppFactory.setindexation().then(
        function() {
          ElasticFactory.createCompleteType(
            $scope.dossierFTI.name,
            $scope.dossierFTI.srid,
            fastIndexing
          ).then(
            function() {
              showProgression('dossiers', def, $scope.dossierFTI.name);
            },
            function() {
              def.reject();
            }
          );
        },
        function() {
          def.reject();
        }
      );
      return def.promise;
    };

    /**
     * indexcontroles
     */
    $scope.indexControle = function() {
      var def = $q.defer();
      ElasticFactory.createCompleteType(
        $scope.controleFTI.name,
        $scope.controleFTI.srid,
        fastIndexing
      ).then(
        function() {
          showProgression('controles', def, $scope.controleFTI.name);
        },
        function() {
          def.reject();
        }
      );
      return def.promise;
    };
    $scope.indexVidangesFormulaires = function() {
      var def = $q.defer();
      ElasticFactory.createCompleteType(
        $scope.vidangeFormulaireFTI.name,
        $scope.vidangeFormulaireFTI.srid,
        fastIndexing
      ).then(
        function() {
          showProgression('vidanges', def, $scope.vidangeFormulaireFTI.name);
        },
        function() {
          def.reject();
        }
      );
      return def.promise;
    };

    $scope.indexFilieres = function() {
      var def = $q.defer();
      ElasticFactory.createCompleteType(
        $scope.filiereFTI.name,
        $scope.filiereFTI.srid,
        fastIndexing
      ).then(
        function() {
          showProgression('filieres', def, $scope.filiereFTI.name);
        },
        function() {
          def.reject();
        }
      );
      return def.promise;
    };

    $scope.indexFiliereElements = function() {
      var def = $q.defer();
      ElasticFactory.createCompleteType(
        $scope.filiereElementFTI.name,
        $scope.filiereElementFTI.srid,
        fastIndexing
      ).then(
        function() {
          showProgression('elemsfiliere', def, $scope.filiereElementFTI.name);
        },
        function() {
          def.reject();
        }
      );
      return def.promise;
    };

    /**
     * doIndexControles
     */
    $scope.doIndexControles = function() {
      var def = $q.defer();
      showProgression('json', def, 'kis_anc_dossier_controle_reponse');
      AncAppFactory.indexcontroles().then(
        function(res) {
          // def.resolve();
          $scope.showSearch = true;
        },
        function() {
          def.reject();
        }
      );
      return def.promise;
    };

    $scope.filiereElementSFTI = FeatureTypeFactory.resources.featuretypes
      .map(function(x) {
        if (x.name.startsWith('kis_anc_ef_')) return x;
      })
      .filter(function(x) {
        if (x) return x;
      });

    /**
     * getEtatAvancementIndexationElementsFiliere
     */
    var getEtatAvancementIndexationElementsFiliere = function() {
      $scope.indexationEfData = {
        total: 0,
        totalIndex: 0,
        toutIndexe: false,
      };
      FeatureTypeFactory.resources.featuretypes.map(function(x) {
        if (x.name.startsWith('kis_anc_ef_')) {
          $scope.indexationEfData.total += 1;
          if (x.inElasticSearch) {
            $scope.indexationEfData.totalIndex += 1;
          }
        }
      });
      var prcentIndexation = Math.round(
        ($scope.indexationEfData.totalIndex * 100) /
          $scope.indexationEfData.total
      );
      $scope.indexProgress.ef = prcentIndexation;
      $scope.indexationEfData.toutIndexe =
        $scope.indexationEfData.total == $scope.indexationEfData.totalIndex &&
        $scope.indexationEfData.total != 0;
    };
    getEtatAvancementIndexationElementsFiliere();

    /**
     * createAllFiliereElements
     */
    function createAllFiliereElements(idx, def) {
      if (!def) def = $q.defer();

      ElasticFactory.createCompleteType(
        $scope.filiereElementSFTI[idx].name,
        $scope.filiereElementSFTI[idx].srid,
        fastIndexing
      ).then(
        function() {
          var stop = $interval(function() {
            var portalid = PortalsFactory.getPortalId();
            ElasticFactory.getprogressiondetaillee(
              portalid,
              $scope.filiereElementSFTI[idx].name
            ).then(
              function(res) {
                if (res.data.prcent < 100) {
                } else if (res.data.prcent == 100) {
                  var prcentIndexation = Math.round(
                    ((idx + 1) * 100) / $scope.filiereElementSFTI.length
                  );
                  $scope.indexProgressQuantites.ef += res.data.qte;

                  $scope.indexProgress.ef = prcentIndexation;

                  if (idx == $scope.filiereElementSFTI.length - 1) {
                    console.log('Tous les ef ont été indexés, proceed!');
                    def.resolve();
                  } else {
                    console.log(
                      'il reste des elements de filiere a indexer',
                      idx,
                      $scope.filiereElementSFTI.length
                    );
                    createAllFiliereElements(idx + 1, def);
                  }
                  $interval.cancel(stop);
                }
              },
              function() {
                $interval.cancel(stop);
                def.reject();
              }
            );
          }, 300);
        },
        function() {
          createAllFiliereElements(idx + 1, def);
          require('toastr').warning(
            'Attention : le composant ' +
              $scope.filiereElementSFTI[idx].name +
              " ne s'est pas indexé correctement."
          );
        }
      );

      return def.promise;
    }

    /**
     * lancerIndexationAnc
     */
    $scope.indexationEncours = false;
    $scope.noEfIndexing = $location.search().pas_index_ef;
    $scope.lancerIndexationAnc = function() {
      $scope.indexationEncours = true;

      // dossier
      $scope.pre_indexcontroles().then(function() {
        // controles
        $scope.indexControle().then(function() {
          // filieres

          $scope.indexFilieres().then(function() {
            // elements

            $scope.indexFiliereElements().then(function() {
              // vidanges
              $scope.indexVidangesFormulaires().then(function() {
                // elements de filiere
                if ($scope.noEfIndexing) {
                  $scope.indexationCtrlEnCours = true;
                  $scope.doIndexControles().then(function() {
                    $scope.indexProgress.json = 100;
                    $scope.indexationEncours = false;
                    $scope.indexationCtrlEnCours = false;
                    require('toastr').success('Indexation terminée.');
                  });
                } else {
                  createAllFiliereElements(0).then(function() {
                    // controles
                    $scope.indexationCtrlEnCours = true;
                    $scope.doIndexControles().then(function() {
                      $scope.indexProgress.json = 100;
                      $scope.indexationEncours = false;
                      $scope.indexationCtrlEnCours = false;
                      require('toastr').success('Indexation terminée.');
                    });
                  });
                }
              });
            });
          });
        });
      });
    };

    /**
     * supprimeIndexationPortail
     */
    $scope.supprimeIndexationPortail = function() {
      var ans = confirm($filter('translate')('common.confirm_action'));
      gaDomUtils.showGlobalLoader();

      if (ans) {
        var portalid = PortalsFactory.getPortalId();
        if (portalid)
          ElasticFactory.deleteIndex(portalid).then(
            function() {
              $window.location.reload();
              require('toastr').success(
                $filter('translate')('portals.elastic.ok')
              );
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                $filter('translate')('portals.elastic.nok')
              );
            }
          );
      } else {
        gaDomUtils.hideGlobalLoader();
      }
    };
    /**
     * getEtatAllIndexByType
     */
    $scope.etatIndexationGeneral = [];
    $scope.getEtatAllIndexByType = function() {
      AncAppFactory.getEtatAllIndexByType().then(
        function(res) {
          $scope.etatIndexationGeneral = res.data;
        },
        function() {
          require('toastr').error(
            "Un problème TimeOut est survenu lors d'une recherche Elastic",
            'Erreur',
            {
              positionClass: 'toast-bottom-left',
            }
          );
        }
      );
    };

    $scope.showTableAfterSearch = function() {
      $scope.showSearch = false;
    };

    $scope.showGraphic = function() {
      $location.path($location.path().replace('admin', 'dashboard'));
      $location.replace($location.url());
    };

    $scope.addGraphicalDashbord = function() {
      var dashbord = {
        id: Math.floor(Math.random() * 10000000000),
        position: $scope.dashboards.length + 1,
        configdashboardsearch: false,
        configdashboardgraphic: false,
        showSearch: true,
        attributes: [],
        relations: [],
        resultsearch: {},
        fti: undefined,
        ftid: undefined,
      };
      $scope.dashboards.push(dashbord);
      getParametersConf();
    };

    $scope.removeChartDashboard = function(idx) {
      var ans = confirm(
        'Êtes-vous sûr de vouloir supprimer définitivement cette configuration ?'
      );
      if (ans) {
        var position = $scope.dashboards[idx].position;
        $scope.dashboards.splice(idx, 1);
        $scope.dashboards.map(function(x) {
          if (x.position > position) {
            x.position = position;
            position += 1;
          }
        });
      }
    };

    $scope.dashboards = [];

    ParametersFactory.getbytype('relationalElastic').then(
      function(res) {
        if (res.data.length > 0) {
          $scope.searchdatas = res.data;
          $scope.saved = {
            realNames: $scope.searchdatas,
            queries: $scope.searchdatas
              .map(function(x) {
                return x.name;
              })
              .filter(function(x) {
                if (x) return x;
              }),
            query: '',
          };
        }
        AncAppSearchFactory.getConfig().then(
          function(res) {
            if (res.data.etat === 'fini')
              $scope.dashboards = JSON.parse(res.data.content);
          },
          function() {
            console.info('aucune configuration du dashboard');
          }
        );
      },
      function() {
        throw new error('pas de config');
      }
    );

    function getParametersConf() {
      ParametersFactory.getbytype('relationalElastic').then(
        function(res) {
          if (res.data.length > 0) {
            $scope.searchdatas = res.data;
            $scope.saved = {
              realNames: $scope.searchdatas,
              queries: $scope.searchdatas
                .map(function(x) {
                  return x.name;
                })
                .filter(function(x) {
                  if (x) return x;
                }),
              query: '',
            };
          }
        },
        function() {
          throw new error('pas de config');
        }
      );
    }

    $scope.changedQuerySelect = function(idx) {
      getParametersConf();
      var filename = $scope.dashboards[idx].query;
      var filenames = $scope.searchdatas.map(function(x) {
        return x.name;
      });
      var index = filenames.indexOf(filename);
      var datas = $scope.searchdatas[index].data.relations;
      $scope.dashboards[idx].relations = [];
      datas.map(function(x) {
        $scope.dashboards[idx].relations.push(x);
      });

      if (
        $scope.searchdatas[index].data.jointure &&
        $scope.searchdatas[index].data.jointure.length > 0
      ) {
        $scope.dashboards[idx].parsedElementsForRelationDashbord =
          $scope.searchdatas[index].data.jointure;
      } else {
        $scope.dashboards[idx].parsedElementsForRelationDashbord = undefined;
      }

      $scope.editQueryDashboard(idx, $scope.dashBoardType);
      $scope.$broadcast('changedQueryDashboard', {
        query: $scope.dashboards[idx].query,
        cfg: $scope.searchdatas[index].data,
      });
    };

    $scope.refreshQueryDashboard = function(idx, type) {
      $scope.dashBoardType = type;
      $scope.dashBoardIndex = idx;
      $scope.dashboards.map(function(x, i) {
        x.configdashboardgraphic = false;
        x.configdashboardsearch = false;
      });
      getParametersConf();
      $scope.dashboards[idx].configdashboardgraphic = false;
      $scope.dashboards[idx].configdashboardsearch = true;

      gaDomUtils.showGlobalLoader();
      ParametersFactory.getbytype('relationalElastic').then(
        function(res) {
          if (res && res.data && res.data.length > 0) {
            try {
              for (var i = 0; i < res.data.length; i++) {
                if (
                  res.data[i] &&
                  res.data[i].name &&
                  res.data[i].name === $scope.dashboards[idx].query
                ) {
                  var q = res.data[i].data;
                  $scope.dashboards[idx].parsedElementsForRelationDashbord =
                    q.jointure;
                  $scope.dashboards[idx].relations = q.relations;
                  require('toastr').success('Tableau de bord rafraîchi.');
                  break;
                }
              }
              gaDomUtils.hideGlobalLoader();
            } catch (e) {
              e.stack;
              gaDomUtils.hideGlobalLoader();
            }
          } else {
            gaDomUtils.hideGlobalLoader();
          }
        },
        function(res) {
          gaDomUtils.hideGlobalLoader();
        }
      );
      $scope.dashboards[idx].showSearch = true;
    };

    $scope.editQueryDashboard = function(idx, type) {
      $scope.dashBoardType = type;
      $scope.dashBoardIndex = idx;
      $scope.dashboards.map(function(x, i) {
        x.configdashboardgraphic = false;
        x.configdashboardsearch = false;
      });
      getParametersConf();
      $scope.dashboards[idx].configdashboardgraphic = false;
      $scope.dashboards[idx].configdashboardsearch = true;
      $scope.dashboards[idx].showSearch = true;
    };

    $scope.editChartDashboard = function(idx, type) {
      $scope.dashBoardType = type;
      $scope.dashBoardIndex = idx;
      $scope.dashboards.map(function(x, i) {
        x.configdashboardgraphic = false;
        x.configdashboardsearch = false;
      });
      getParametersConf();
      $scope.dashboards[idx].configdashboardgraphic = true;
      $scope.dashboards[idx].configdashboardsearch = false;
    };

    $scope.visibleSearchResult = function(idx, type) {
      $scope.dashBoardType = type;
      $scope.dashBoardIndex = idx;
      $scope.dashboards.map(function(x, i) {
        x.configdashboardgraphic = false;
        x.configdashboardsearch = false;
      });
      getParametersConf();
      $scope.dashboards[idx].configdashboardgraphic = false;
      $scope.dashboards[idx].configdashboardsearch = true;
      $scope.dashboards[idx].showSearch = false;
    };

    $scope.reduceQueryDashboard = function(idx, type) {
      $scope.dashBoardType = type;
      $scope.dashBoardIndex = idx;
      getParametersConf();
      $scope.dashboards[idx].configdashboardgraphic = false;
      $scope.dashboards[idx].configdashboardsearch = false;
      $scope.dashboards[idx].showSearch = false;
    };

    $scope.confirm = function() {
      $scope.elementsHasNoconfigName.map(function(x, i) {
        var saveData = {
          user: $rootScope.xgos.user.login,
          relations: x.dashboard.relations,
        };

        ParametersFactory.getbytype('relationalElastic').then(function(res) {
          var nameSaved = res.data.map(function(x) {
            return x.name;
          });
          if (nameSaved.indexOf(x.dashboard.query) !== -1) {
            var idx = res.data
              .map(function(x) {
                return x.name;
              })
              .indexOf(x.dashboard.query);
            var id = res.data[idx].id;
            var ans = confirm(
              $filter('translate')('elastic.search.existsconf')
            );
            if (ans)
              ParametersFactory.remove(id).then(
                function() {
                  ParametersFactory.add(
                    saveData,
                    'relationalElastic',
                    x.dashboard.query
                  ).then(
                    function() {
                      getParametersConf();
                      AncAppSearchFactory.saveConfig($scope.dashboards).then(
                        function() {
                          require('toastr').success(
                            'Tableau de bord enregistré'
                          );
                        },
                        function() {
                          require('toastr').error(
                            "erreur d'enregistrement du tableau de bord"
                          );
                        }
                      );
                    },
                    function() {
                      require('toastr').info(
                        $filter('translate')('elastic.search.save_nok')
                      );
                    }
                  );
                },
                function() {
                  require('toastr').info(
                    $filter('translate')('elastic.search.save_nok')
                  );
                }
              );
          } else {
            ParametersFactory.add(
              saveData,
              'relationalElastic',
              x.dashboard.query
            ).then(
              function() {
                getParametersConf();
                AncAppSearchFactory.saveConfig($scope.dashboards).then(
                  function() {
                    require('toastr').success('Tableau de bord enregistré');
                  },
                  function() {
                    require('toastr').error(
                      "erreur d'enregistrement du tableau de bord"
                    );
                  }
                );
              },
              function() {
                require('toastr').info(
                  $filter('translate')('elastic.search.save_nok')
                );
              }
            );
          }
        });
      });
    };

    $scope.$on('searchsuccesssahbord', function(evt, args) {
      $scope.visibleSearchResult(args, 'datatable');
    });

    $scope.saveQueryDashboard = function() {
      $scope.elementsHasNoconfigName = [];
      var parametersCompleted = true;
      $scope.dashboards.map(function(x, i) {
        x.configdashboardgraphic = false;
        x.configdashboardsearch = false;
        if (!x.searchquery || !x.chartconfig || !x.chartoptions || !x.name) {
          if (!x.searchquery)
            require('toastr').error(
              'Recherche non enregistrée pour la configuration Numéro ' +
                (i + 1) +
                "<br> Lancer la recherche pour l'enregistrer."
            );
          if (!x.chartconfig || !x.chartoptions)
            require('toastr').error(
              'Graphe non enregistrée pour la configuration Numéro ' +
                (i + 1) +
                "<br> Créez un graphe et lancez la récupération des données pour l'enregistrer."
            );
          if (!x.name)
            require('toastr').error(
              'Graphe non enregistrée pour la configuration Numéro ' +
                (i + 1) +
                '<br> Renseignez le nom du graphe.'
            );
          parametersCompleted = false;
        } else {
          require('toastr').info(
            'Configuration Numéro ' + (i + 1) + ' est correcte.'
          );
          if (parametersCompleted) parametersCompleted = true;
        }

        if ((!x.query || !x.name) && x.searchquery && x.searchquery.query)
          $scope.elementsHasNoconfigName.push({
            index: x.position,
            dashboard: x,
          });
      });
      if (parametersCompleted) {
        if ($scope.elementsHasNoconfigName.length > 0) {
          ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/admin/modals/modal.dashboard.saveconf.html',
            className: 'ngdialog-theme-plain width600 miniclose nopadding',
            closeByDocument: false,
            scope: $scope,
          });
        } else {
          AncAppSearchFactory.saveConfig($scope.dashboards).then(
            function() {
              require('toastr').success('Tableau de bord enregistré');
              $scope.dashBoardType = undefined;
              $scope.dashBoardIndex = -1;
            },
            function() {
              require('toastr').error(
                "erreur d'enregistrement du tableau de bord"
              );
              $scope.dashBoardType = undefined;
              $scope.dashBoardIndex = -1;
            }
          );
        }
      } else {
        require('toastr').error(
          "Echec de la sauvegarde. Remplissez les champs manquants d'abord."
        );
        $scope.dashBoardType = undefined;
        $scope.dashBoardIndex = -1;
      }
    };

    $scope.$on('resultsavednewsearch', function(event, data) {
      $scope.nomRequeteEnCours = data.name;
      if (data.place == 'dashboard') {
        getParametersConf();
        if (
          relnewname &&
          angular.isDefined($scope.dashBoardIndex) &&
          $scope.dashboards &&
          $scope.dashboards[$scope.dashBoardIndex]
        )
          $scope.dashboards[$scope.dashBoardIndex].query = data.name;
      }
    });

    $scope.dashboardMove = function(idx, d) {
      if (idx !== -1) {
        if (d === 'up') {
          var dashboard = $scope.dashboards[idx];
          dashboard.position = dashboard.position - 1;
          $scope.dashboards.map(function(x) {
            if (x.id !== dashboard.id && x.position == dashboard.position) {
              x.position = x.position + 1;
            }
          });
          $scope.dashboards.splice(idx, 1);
          $scope.dashboards.splice(idx - 1, 0, dashboard);
        } else {
          var dashboard = $scope.dashboards[idx];
          dashboard.position = dashboard.position + 1;
          $scope.dashboards.map(function(x) {
            if (x.id !== dashboard.id && x.position == dashboard.position) {
              x.position = x.position - 1;
            }
          });
          $scope.dashboards.splice(idx, 1);
          $scope.dashboards.splice(idx + 1, 0, dashboard);
        }
      }
    };
  };

  adminCtrl.$inject = [
    '$scope',
    'AncAppFactory',
    '$location',
    'FeatureTypeFactory',
    '$timeout',
    'ngDialog',
    'gaDomUtils',
    '$window',
    'EditFactory',
    'QueryFactory',
    '$sce',
    '$filter',
    '$translate',
    'extendedNgDialog',
    '$rootScope',
    'FilesFactory',
    'StyleFactory',
    'IndicatorParamsFactory',
    'gaJsUtils',
    '$q',
    'ElasticFactory',
    'ParametersFactory',
    'AncAppSearchFactory',
    '$interval',
    'GeoserverFactory',
    'PortalsFactory',
  ];
  return adminCtrl;
});
