'use strict';
define(function() {
  var ancDossierParcelle = function(
    FeatureTypeFactory,
    AncAppFactory,
    BacAppFactory,
    ngDialog,
    gaDomUtils,
    $timeout,
    $rootScope,
    ogcFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_dossier_parcelle.html',
      restrict: 'EA',
      scope: {
        type: '@',
        idDossier: '=',
        ancparcelle: '=',
        refreshListeParcelles: '&',
        adresseDossier: '=?',
        apptype: '=?',
        commune: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;
        var parcellesCfg = CurrentAppFactory.appCfg.main.parcellesCfg;
        scope.parcelleFields = parcellesCfg.fields;

        // retrieve parcelle fti
        scope.parcellesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          parcellesCfg.emplacement
        );

        // break two way binding because we will now use complete parcel object
        scope.parcelle = angular.copy(scope.ancparcelle);

        if (typeof AppAndroid !== 'undefined') scope.AppAndroid = AppAndroid;

        /**
         * broadCastParcelleDisponible
         * @param message
         * @param type
         * @param idDossier
         * @param parcelle
         */
        var broadCastParcelleDisponible = function(
          message,
          type,
          idDossier,
          parcelle
        ) {
          // broadcast
          $rootScope.$broadcast(message, {
            element: {
              type: type,
              curentParcelle: parcelle,
              idDossier: idDossier,
            },
          });
        };

        // retrieve all parcelle infos
        if (scope.ancparcelle != null) {
          scope.retrievingParcelle = true;

          // todo remove timeout
          $timeout(function() {
            CurrentAppFactory.getparcelle(scope.parcelle.id).then(function(
              res
            ) {
              scope.retrievingParcelle = false;
              scope.parcelle = res.data.features[0];

              broadCastParcelleDisponible(
                'parcelleDisponible',
                scope.type,
                scope.idDossier,
                res.data.features[0]
              );
            });
          }, 1000);
        }

        scope.getParcelleFromAdresse = function() {
          if (scope.adresseDossier) {
            // if (parcelle.geometry.type == 'MultiPolygon') {
            //     var coords_parcelle = parcelle.geometry.coordinates[0][0];
            // } else if (parcelle.geometry.type == 'Polygon') {
            //     var coords_parcelle = parcelle.geometry.coordinates[0];
            // }

            // multipoint

            // user getfeatures
            var x = scope.adresseDossier.coordinates[0];
            // multipoints
            var y;
            if (angular.isArray(x)) {
              y = x[1];
              x = x[0];
            } else {
              y = scope.adresseDossier.coordinates[1];
            }

            // multipoints

            var leftX = x - 3;
            var rightX = x + 3;
            var bottomY = y - 3;
            var topY = y + 3;

            var promise = ogcFactory
              .getfeatures(
                'GetFeature',
                'WFS',
                '1.0.0',
                scope.parcellesFti.uid,
                'json',
                'EPSG:3857',
                'INTERSECTS(geom, POLYGON((' +
                  leftX +
                  ' ' +
                  bottomY +
                  ',' +
                  rightX +
                  ' ' +
                  bottomY +
                  ',' +
                  rightX +
                  ' ' +
                  topY +
                  ',' +
                  leftX +
                  ' ' +
                  topY +
                  ',' +
                  leftX +
                  ' ' +
                  bottomY +
                  ')))'
              )
              .then(
                function(res) {
                  if (!res.data.features.length) {
                    //  require('toastr').error("Aucune parcelle sur l'emplacement du dossier.");
                    require('toastr').error(
                      "Aucune parcelle sur l'emplacement du dossier.",
                      '',
                      {
                        positionClass: 'toast-bottom-left',
                      }
                    );
                  } else {
                    //scope.parcelle = res.data.features[0];
                    // require('toastr').success("Parcelle "+scope.parcelle.properties[scope.parcelleFields.numero]+" associée au dossier");
                    //  broadCastParcelleDisponible('parcelleDisponible',scope.type,scope.idDossier,res.data.features[0]);
                    addParcelle(
                      scope.type,
                      scope.idDossier,
                      res.data.features[0].id
                    );
                  }
                  //
                },
                function() {
                  require('toastr').error(
                    'Erreur lors de la récupération de la position du dossier.',
                    '',
                    {
                      positionClass: 'toast-bottom-left',
                    }
                  );
                }
              );
          }
        };

        /*

                 PARCELLE FORM

                 */

        var addParcelleModal;
        scope.openAddParcelleModal = function() {
          scope.currentParcelle = {};
          addParcelleModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.parcelle.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * once the parcelle is edited
         */
        scope.editedParcelle = function(id) {
          addParcelleModal.close();
          scope.choisirParcelle(id);
        };

        var seachParcelleModal;
        scope.openSearchParcelleModal = function() {
          scope.selectedParcelle = { data: [] };

          seachParcelleModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.parcelle.search.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * addParcelle
         */
        var addParcelle = function(type, idDossier, parcelle_id) {
          gaDomUtils.showGlobalLoader();

          CurrentAppFactory.checkparcellealreadyused(
            type,
            idDossier,
            parcelle_id
          ).then(
            function(res) {
              var isAlreadyUsed = res.data != 'ok' && res.data.features.length;

              var ans = 1;
              if (isAlreadyUsed) {
                ans = confirm(
                  'Cette parcelle est déja associée au dossier ' +
                    res.data.features[0].properties.ref_dossier +
                    " !\nVoulez-vous l'associer à ce dossier également ?"
                );
              }

              if (ans) {
                CurrentAppFactory.addparcelletodossier(
                  type,
                  idDossier,
                  parcelle_id
                ).then(
                  function(res) {
                    scope.parcelle = res.data.features[0];

                    gaDomUtils.hideGlobalLoader();
                    if (seachParcelleModal) seachParcelleModal.close();

                    //   require('toastr').success("Parcelle "+res.data.features[0].properties[scope.parcelleFields.numero]+" associée au dossier");
                    require('toastr').success(
                      'Parcelle ' +
                        res.data.features[0].properties[
                          scope.parcelleFields.numero
                        ] +
                        ' associée au dossier',
                      '',
                      {
                        positionClass: 'toast-bottom-left',
                      }
                    );
                    broadCastParcelleDisponible(
                      'parcelleDisponible',
                      scope.type,
                      scope.idDossier,
                      res.data.features[0]
                    );

                    $timeout(function() {
                      scope.refreshListeParcelles();
                      scope.ancparcelle = {
                        id: res.data.features[0].id,
                        numero:
                          res.data.features[0].properties[
                            scope.parcelleFields.numero
                          ],
                        section:
                          res.data.features[0].properties[
                            scope.parcelleFields.section
                          ],
                      };
                      $rootScope.$broadcast('modificationParcellesDossier');
                    });
                  },
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    if (seachParcelleModal) seachParcelleModal.close();
                  }
                );
              } else {
                gaDomUtils.hideGlobalLoader();
              }
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };
        /**
         * Import updated parcelles in the list
         */
        scope.importParcelles = () => {
          if (parcellesCfg.emplacement.toLowerCase() != 'parcelles') {
            return require('toastr').error(
              "Le nom de la table pour l'import n'est pas configuré correctement. Veuillez contacter l'administrateur.",
              '',
              {
                positionClass: 'toast-bottom-left',
              }
            );
          }
          if (!parcellesCfg.api_cadastre || !parcellesCfg.api_cadastre.url) {
            return require('toastr').error(
              "L'URL pour l'import n'est pas configuré dans l'Administration. Veuillez contacter l'administrateur.",
              '',
              {
                positionClass: 'toast-bottom-left',
              }
            );
          }
          let importParcelleDialog;
          importParcelleDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.parcelle.import.html',
            controller: 'importParcelleCtrl',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
          importParcelleDialog.closePromise.then(() => {
            scope.refreshListeParcelles();
          });
        };
        /**
         * Pick a parcelle in the list
         */
        scope.choisirParcelle = function(parcelle_id) {
          // selected from search modal
          if (!parcelle_id) {
            var parcelle_id = scope.selectedParcelle.data[0].id;
          }

          addParcelle(scope.type, scope.idDossier, parcelle_id);
        };

        //broadcast
        var currentIdDossier, currentAncparcelle, currentType;
        scope.autreParcelleDisponible = false;

        scope.$on('parcelleDisponible', function(event, args) {
          if (
            args.element.idDossier == scope.idDossier &&
            args.element.type != scope.type
          ) {
            scope.autreParcelleDisponible = true;
            currentIdDossier = args.element.idDossier;
            currentAncparcelle = args.element.curentParcelle;
            currentType = args.element.type;
          }
        });

        scope.$on('supprimerParcelle', function(event, args) {
          if (
            args.element.idDossier == scope.idDossier &&
            args.element.type != scope.type
          ) {
            scope.autreParcelleDisponible = false;
          }
        });
        scope.$on('addParcelleToDossier', function(event, args) {
          if (
            args.element.idDossier == scope.idDossier &&
            args.element.type == scope.type
          ) {
            addParcelle(
              args.element.type,
              args.element.idDossier,
              args.element.parcelle.id
            );
          }
        });

        /*
                 Copier une parcelle
                 */
        scope.copierParcelle = function() {
          addParcelle(scope.type, currentIdDossier, currentAncparcelle.id);
        };

        /*
                
                 */
        /*
                 Supprimer une Parcelle
                 */

        scope.supprimerParcelleChoisie = function() {
          var r = confirm(
            'Êtes-vous sûr de vouloir supprimer la liaison entre cette parcelle et le dossier ?'
          );
          if (r == true) {
            CurrentAppFactory.removeparcellefromdossier(
              scope.type,
              scope.idDossier,
              scope.parcelle.id
            ).then(function() {
              scope.refreshListeParcelles();

              $rootScope.$broadcast('modificationParcellesDossier');
              scope.parcelle = false;

              scope.ancparcelle = null;

              // broadcast
              broadCastParcelleDisponible(
                'supprimerParcelle',
                scope.type,
                scope.idDossier,
                null
              );
            });
          }
        };

        /**
         * transformTypeToLabel
         * @param type
         * @returns {*}
         */
        scope.transformTypeToLabel = function(type) {
          var label;
          switch (type) {
            case 'habitation':
              //label = "Parcelle de l'habitation";
              label = "Référence cadastrale de l'habitation assainie";
              break;
            case 'filiere':
              //label = "Parcelle de la filière";
              label = "Référence cadastrale de l'implantation de la filière";
              break;
          }
          return label;
        };
        /**
         * transformAucuneToLabel
         * @param type
         * @returns {*}
         */
        scope.transformAucuneToLabel = function(type) {
          var label;
          switch (type) {
            case 'habitation':
              label = "Aucune parcelle n'est associée à l'habitation";
              break;
            case 'filiere':
              label = "Aucune parcelle n'est associée à la filière";
              break;
          }
          return label;
        };

        //Render tooltip on modal.parcelle.search
        scope.tooltipTitle = {};
        scope.tooltipTitle.titleEdit = 'Editer la parcelle';
        scope.tooltipTitle.titleFilter = 'Appliquer un filtre';
        scope.tooltipTitle.save = 'Sauvegarder la parcelle';
        scope.tooltipTitle.class = 'cursorHelp';
      },
    };
  };

  ancDossierParcelle.$inject = [
    'FeatureTypeFactory',
    'AncAppFactory',
    'BacAppFactory',
    'ngDialog',
    'gaDomUtils',
    '$timeout',
    '$rootScope',
    'ogcFactory',
  ];
  return ancDossierParcelle;
});
