'use strict';
define(function() {
  var ancBacExtraFormFields = function(
    AncAppFactory,
    BacAppFactory,
    $rootScope,
    gaJsUtils,
    $timeout,
    FeatureTypeFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_extra_form_fields.html',
      restrict: 'EA',
      scope: {
        apptype: '=',
        currentControle: '=',
        cdata: '=',
        ctrlClos: '=',
      },
      link: function(scope, elt, attrs, ctrl, testCtrl) {
        var CurrentAppFactory =
          scope.apptype == 'anc' ? AncAppFactory : BacAppFactory;
        var extraFields =
          CurrentAppFactory.appCfg.main.properties.extraFormFields;

        // fakefti
        var _fakeFti = {
          name: 'fakeFti',
          alias: 'fakeFti',
          attributes: [],
        };
        scope.dataIsSet = false;

        // si extrafields
        if (angular.isDefined(extraFields)) {
          // si extrafields du bon type de controle
          console.log(scope.currentControle.properties.type);

          var _fields = angular.copy(extraFields).fields.filter(function(x) {
            return (
              x.controles.indexOf(scope.currentControle.properties.type) != -1
            );
          });

          _fields.map(function(z) {
            // preparation de l'objet a passer a la directive form-field
            var tmp = z.model.replace('cdata.', '').split('.');

            var target = tmp.join('.');

            // set l' entree dans cdata si n'existe pas encore
            if (!gaJsUtils.checkNestedProperty(target, scope.cdata)) {
              gaJsUtils.setNestedProperty(target, scope.cdata, {});
            }
            z.res = target;

            var type = 'java.lang.String';
            if (z.type == 'entier') type = 'java.lang.Integer';
            if (z.type == 'date') type = 'java.sql.Timestamp';

            // alimentation du fakeFti passe au form-field
            if (!angular.isDefined(z.origine)) {
              _fakeFti.attributes.push({
                alias: z.label,
                name: z.attribute,
                type: type,
                restrictions: [],
              });
            }
          });

          scope.extraFields = _fields;

          $timeout(function() {
            scope.dataIsSet = true;
          }, 0);
        }

        /**
         * Retourne l'objet à passer au form field en tant que res
         * @param {*} res
         */
        scope.getRes = function(field) {
          return gaJsUtils.checkNestedProperty(field.res, scope.cdata);
        };

        /**
         * Retourne l'objet à passer au form field en tant que fti
         * @param {*} res
         */
        scope.getFti = function(field) {
          if (!angular.isDefined(field.origine)) {
            return _fakeFti;
          } else {
            return FeatureTypeFactory.getFeatureByUid(field.origine);
          }
        };
      },
    };
  };

  ancBacExtraFormFields.$inject = [
    'AncAppFactory',
    'BacAppFactory',
    '$rootScope',
    'gaJsUtils',
    '$timeout',
    'FeatureTypeFactory',
  ];
  return ancBacExtraFormFields;
});
