'use strict';
define(function() {
  var adminTableHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    EditFactory,
    $rootScope,
    $filter,
    ngDialog,
    $timeout,
    ParametersFactory,
    gaDomUtils,
    HpoAppServices,
    ImportExportFactory,
    licenceFactory,
    InitProvider,
    ConfigFactory,
    $q
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/admin_table_hpo.html',
      restrict: 'EA',
      scope: {
        ftis: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        var config = InitProvider.getHpoConfig();
        scope.configureName = HpoCarteAppFactory.getAppFactory();
        scope.description3 = $filter('translate')(
          'hpo.admin.table.description'
        );
        scope.hidechantier = false;
        scope.selected = {};
        scope.attr = {};

        if (angular.isDefined(scope.ftis) && scope.ftis.length > 0) {
          scope.selected.fti = scope.ftis[0];
        }

        var initConfig = function(hardReset) {
          if (angular.isUndefined(hardReset)) hardReset = false;
          if (
            angular.isDefined(config) &&
            angular.isDefined(config.attrToShow) &&
            Object.keys(config.attrToShow).length > 0 &&
            !hardReset
          ) {
            scope.attr = angular.copy(config.attrToShow);
          } else {
            scope.ftis.forEach(function(fti) {
              scope.attr[fti.name] = {};
              fti.attributes.forEach(function(attr) {
                scope.attr[fti.name][attr.name] = true;
              });
            });
          }
        };

        initConfig();

        scope.saveCfg = function() {
          if (
            angular.isDefined(scope.attr) &&
            Object.keys(scope.attr).length > 0
          ) {
            config.attrToShow = scope.attr;
            $rootScope.$broadcast('saveConfig', true);
          }
        };

        scope.reinitCfg = function() {
          initConfig(true);
          scope.saveCfg();
        };
      },
    };
  };

  adminTableHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'EditFactory',
    '$rootScope',
    '$filter',
    'ngDialog',
    '$timeout',
    'ParametersFactory',
    'gaDomUtils',
    'HpoAppServices',
    'ImportExportFactory',
    'licenceFactory',
    'InitProvider',
    'ConfigFactory',
    '$q',
  ];
  return adminTableHpo;
});
