'use strict';
define(function() {
  var changeAttributeValue = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/change_attribute_value.html',
      restrict: 'EA',
      scope: {
        attr: '=',
        fti: '=',
        res: '=?',
        fromdrag: '=?',
        dragEnded: '=?',
        renderValue: '=?',
        attributes: '=?',
        usespecialfilters: '=?',
        clign: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        ///////////////// Gestion de l'arbre des règles /////////////////////////
        var initialValue = [
          {
            label: $filter('translate')(
              'hpo.data.prepare.correctiontools.correctallvalues.rules'
            ),
            children: [
              {
                type: 'value',
                label: $filter('translate')(
                  'hpo.data.prepare.correctiontools.correctallvalues.value'
                ),
              },
            ],
          },
        ];

        if (
          HpoCarteAppFactory.getAppFactory()
            .getDateTypes()
            .indexOf(scope.attr.type) === -1
        ) {
          initialValue[0].children.push({
            type: 'regroupement',
            label: $filter('translate')(
              'hpo.data.prepare.correctiontools.correctallvalues.regroupement'
            ),
          });

          initialValue[0].children.push({
            type: 'calculator',
            label: $filter('translate')(
              'hpo.data.prepare.correctiontools.correctallvalues.calculator'
            ),
          });
        }

        scope.ruleNameTree = angular.copy(initialValue);
        scope.treeControl = [];
        /**
         * Handler de sélection d'une règle dans l'arbre de navigation des règles.
         * @param {type} branch
         * @returns {undefined}
         */
        scope.rules_tree_handler = function(branch) {
          //scope.treeControl.reset_rows();
          //scope.treeControl.select_branch(branch);
          var selected = branch;
          //Si la branche sélectionnée est bien une terminaison, il s'agit bien d'une règle.
          if (selected.classes[0] == 'leaf') {
            //instanciation d'un nouvel objet règle qui sera édité par la directive de la règle en question.
            //nouvelle instance de règle pour que le tableau ng-table puisse differncier les règles de meme nom grâce à leur réference d'objet
            //Si probleme de representation avec le ng-table, ajouter une propriété id= nombre aléatoire (Math.random())
            refreshCurrentRule();
            scope.currentEditedRule.type = selected.type;
            scope.currentEditedRule.label = selected.label;
          }
        };

        var refreshCurrentRule = function() {
          scope.currentEditedRule = new Object();
          scope.currentEditedRule.id = Math.random();
        };

        scope.getUniqueValues = function() {
          var analysis = {
            analysistool: 'distributionanalysis',
            tableselected: scope.fti,
            result: [],
            geoj: {},
            operands: [],
            attributestoselect: {},
            expression: '',
            interpreteattributes: 'and',
            interpreteconditions: 'and',
            selectedall: false,
            attributestouseindatatable: [],
            supplementAttributes: null,
          };
          analysis.attributestoselect[scope.attr.name] = true;
          gaDomUtils.showGlobalLoader();
          HpoAppServices.analyseData(analysis).then(
            function(res) {
              if (res.data && res.data.status) {
                scope.results = res.data.result;
                try {
                  if (scope.results && scope.results.length === 0) {
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.success'),
                      $filter('translate')(
                        'hpo.data.prepare.analysissuccessbutnodata'
                      ),
                      true,
                      'info'
                    );
                  }
                } catch (e) {
                  console.error(e.stack);
                }
              } else {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.data.prepare.succes'),
                  $filter('translate')('hpo.data.prepare.analysissuccess'),
                  false
                );
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        var ngDialogPromise;
        scope.results = undefined;
        var openDialog = function() {
          ngDialogPromise = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/utilities/attribute_general_value.html',
            scope: scope,
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
          });
          ngDialogPromise.then(
            function(data) {
              scope.res = scope.rules;
            },
            function(data) {
              require('toastr').info(
                $filter('translate')('elastic.search.annuler')
              );
            }
          );
        };

        scope.description = $filter('translate')(
          'hpo.data.prepare.correctiontools.correctallvalues.description'
        );
        if (scope.fromdrag) {
          scope.newattribute = true;
          openDialog();
          scope.dragEnded();
        }

        scope.editRule = function() {
          scope.newattribute = false;
          openDialog();
        };

        scope.rules = scope.res || {
          description: undefined,
          list: [],
        };

        /**
         * Paramètres du tableau listant les règles associées au currentfeaturetype passé à cette directive
         */
        scope.tableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.rules.list.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              params.total(scope.rules.list.length); // set total for recalc pagination
              $defer.resolve(displayedTab);
            },
          }
        );

        scope.selectActionIdx = null;
        scope.selectAction = function(idx) {
          if (idx === scope.selectActionIdx) scope.selectActionIdx = null;
          else scope.selectActionIdx = idx;
        };

        scope.actionMoveDown = (idx) => {
          if (idx !== -1) {
            let rule = scope.rules.list[idx];
            rule.$selected = false;
            scope.rules.list.splice(idx, 1);
            scope.rules.list.splice(idx + 1, 0, rule);
          }
          scope.tableParams.reload();
        };

        scope.actionMoveUp = (idx) => {
          if (idx !== -1) {
            let rule = scope.rules.list[idx];
            rule.$selected = false;
            scope.rules.list.splice(idx, 1);
            scope.rules.list.splice(idx - 1, 0, rule);
          }
          scope.tableParams.reload();
        };

        scope.onDropg2c = function(target, source) {
          target =
            (scope.tableParams.page() - 1) * scope.tableParams.$params.count +
            target;
          var index = source == '' ? 0 : source;
          index =
            (scope.tableParams.page() - 1) * scope.tableParams.$params.count +
            index;
          var actionragged = scope.rules.list[index];
          scope.rules.list.splice(index, 1);
          scope.rules.list.splice(target, 0, actionragged);
          scope.tableParams.reload();
        };

        var ngDialogPromiseRule;
        var openDialogRule = function() {
          console.log(scope);
          scope.results = undefined;
          if (scope.newRule) {
            scope.ruleNameTree = angular.copy(initialValue);
            refreshCurrentRule();
          } else {
            scope.ruleNameTree = angular.copy(initialValue);
            var idx = scope.ruleNameTree[0].children
              .map(function(x) {
                if (x.type !== scope.currentEditedRule.type) x.selected = false;
                else {
                  x.selected = true;
                }
                return x.type;
              })
              .indexOf(scope.currentEditedRule.type);
            scope.ruleNameTree[0].label = $filter('translate')(
              'hpo.data.prepare.correctiontools.correctallvalues.rules'
            );
          }
          scope.newcondition = {
            conditions: undefined,
          };
          ngDialogPromiseRule = ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/utilities/attribute_general_value_rule.html',
            scope: scope,
            className: 'ngdialog-theme-plain width95pct nopadding miniclose',
          });
        };

        scope.addNewRule = function() {
          scope.newRule = true;
          openDialogRule();
        };

        /**
         * Supprime du tableau des règles du featureType, toutes celles sélectionnées.
         * @returns {undefined}
         */
        scope.removeRuleFromList = function() {
          var callback = function(isconfirm) {
            if (isconfirm) {
              scope.rules.list.splice(scope.selectActionIdx, 1);
              scope.tableParams.reload();
            }
          };
          var message = $filter('translate')(
            'hpo.data.prepare.correctiontools.correctallvalues.removeRule'
          );
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            message,
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        scope.updateAction = function(action) {
          scope.newRule = false;
          scope.currentEditedRule = angular.copy(action);
          openDialogRule();
        };

        scope.addOrUpdateRule = function(rule) {
          rule.result = scope.newcondition.conditions;
          if (scope.newRule) scope.rules.list.push(rule);
          else {
            var idx = scope.rules.list
              .map(function(x) {
                if (x) return x.id;
              })
              .indexOf(rule.id);
            if (idx !== -1) scope.rules.list[idx] = rule;
          }
          scope.tableParams.reload();
          if (ngDialogPromiseRule) ngDialogPromiseRule.close();
        };

        scope.auto =
          $filter('translate')(
            'hpo.data.prepare.correctiontools.correctallvalues.generatedescription'
          ) + scope.attr.alias;
        scope.generateAuto = function() {
          scope.rules.description = scope.auto;
        };

        if (angular.isDefined(scope.clign) && scope.clign)
          setTimeout(function() {
            scope.clign = false;
          }, 2000);
      },
    };
  };

  changeAttributeValue.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
  ];
  return changeAttributeValue;
});
