'use strict';
define(function() {
  var HpoUserAppFactory = function(
    $http,
    FeatureTypeFactory,
    $filter,
    $rootScope,
    $location,
    HpoCarteAppFactory
  ) {
    function getUser() {
      return HpoCarteAppFactory.getInitProvider().getUser();
    }

    function getUserRoles() {
      var user = HpoCarteAppFactory.getInitProvider().getUser();
      return user.roles;
    }

    function isKisRootUser() {
      var user = HpoCarteAppFactory.getInitProvider().getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return user.name === 'root';
    }

    function isRootUser() {
      var user = HpoCarteAppFactory.getInitProvider().getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return rolesNames.indexOf('rootUser') !== -1;
    }

    function isSuperRootUser() {
      var user = CarteInitProvider.getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return rolesNames.indexOf('sRootUser') !== -1;
    }

    function isDbMutualiseAdmin() {
      var user = HpoCarteAppFactory.getInitProvider().getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return rolesNames.indexOf('dbMutualiseAdmin') !== -1;
    }

    function isDbMutualiseClient() {
      var user = HpoCarteAppFactory.getInitProvider().getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return rolesNames.indexOf('dbMutualiseClient') !== -1;
    }

    function isHpoExpertClient() {
      var user = HpoCarteAppFactory.getInitProvider().getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return rolesNames.indexOf('HpoExpertClient') !== -1;
    }

    function isHpoClient() {
      var user = HpoCarteAppFactory.getInitProvider().getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return rolesNames.indexOf('HpoClient') !== -1;
    }

    function getNavigationHpo() {
      var navigations = [];

      var title = {
        main_title: 'hpo.home.title',
        label: 'hpo.home.title',
        icon: 'home',
        template: 'js/XG/widgets/hpoapp/main/views/templates/hpo.home.tpl.html',
        visible: true,
        description: '',
      };

      var admin = {
        main_title: 'hpo.admin.title',
        label: 'hpo.admin.title',
        icon: 'cogs',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/hpo.admin.tpl.html',
        visible: true,
        description: '',
      };

      var dataCheck = {
        label: 'hpo.data.check.title',
        icon: 'table',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.check.tpl.html',
        visible: true,
        description: '',
      };
      var dataExchange = {
        label: 'hpo.data.exchange.title',
        icon: 'exchange',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.exchange.tpl.html',
        visible: true,
        description: '',
      };
      var dataPrepare = {
        label: 'hpo.data.prepare.title',
        icon: 'pencil',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.tpl.html',
        visible: true,
        description: '',
      };
      var dataAnalyse = {
        label: 'hpo.data.analyse.title',
        icon: 'pie-chart',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.analyse.tpl.html',
        visible: true,
        description: '',
      };
      var dataValidation = {
        label: 'hpo.data.validation.title',
        icon: 'exchange',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.validation.tpl.html',
        visible: true,
        description: '',
      };
      var checkvalidation = {
        label: 'hpo.data.checkvalidation.title',
        icon: 'check',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.checkvalidation.tpl.html',
        visible: true,
        description: '',
      };
      var data = {
        main_title: 'hpo.data.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'database',
        subs: [],
      };

      var jeuChoice = {
        label: 'hpo.model.jeu.title',
        icon: 'list',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/model/hpo.model.jeu.tpl.html',
        visible: true,
        description: '',
      };
      var modelChoice = {
        label: 'hpo.model.choice.title',
        icon: 'table',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/model/hpo.model.choice.tpl.html',
        visible: true,
        description: '',
      };
      var modelCalage = {
        label: 'hpo.model.calage.title',
        icon: 'edit',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/model/hpo.model.calage.tpl.html',
        visible: true,
        description: '',
      };
      var modelValidation = {
        label: 'hpo.model.validation.title',
        icon: 'check',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/model/hpo.model.validation.tpl.html',
        visible: true,
        description: '',
      };
      var modelPrevision = {
        label: 'hpo.model.prevision.title',
        icon: 'area-chart',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/model/hpo.model.prevision.tpl.html',
        visible: true,
        description: '',
      };
      var model = {
        main_title: 'hpo.model.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'line-chart',
        subs: [],
      };
      var multicritereComposantFilter = {
        label: 'hpo.multicritere.filter.title',
        icon: 'filter',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.filter.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereAutomatisation = {
        label: 'hpo.multicritere.automatisation.title',
        icon: 'laptop',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.automatisation.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereParameters = {
        label: 'hpo.multicritere.parameters.title',
        icon: 'cog',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.parameters.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereConstruct = {
        label: 'hpo.multicritere.construct.title',
        icon: 'plus',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.construct.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereAnalyse = {
        label: 'hpo.multicritere.analyse.title',
        icon: 'edit',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.analyse.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereIndicateur = {
        label: 'hpo.multicritere.indicateur.title',
        icon: 'plus-square',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.indicateur.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereCompare = {
        label: 'hpo.multicritere.compare.title',
        icon: 'line-chart',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.compare.tpl.html',
        visible: true,
        description: '',
      };

      var multicritereCorrespondance = {
        label: 'hpo.multicritere.correspondance.title',
        icon: 'arrows-h',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.correspondance.tpl.html',
        visible: true,
        description: '',
      };

      var multicritereRetenu = {
        label: 'hpo.multicritere.retenu.title',
        icon: 'mouse-pointer',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.retenu.tpl.html',
        visible: true,
        description: '',
      };

      var multicritere = {
        main_title: 'hpo.multicritere.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'code-fork',
        subs: [],
      };

      var chantiersCreate = {
        label: 'hpo.chantiers.creation.title',
        icon: 'plus',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/chantiers/chantiers.tpl.html',
        visible: true,
        description: '',
      };
      var chantiersListe = {
        label: 'hpo.chantiers.liste.title',
        icon: 'list',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/chantiers/liste.chantiers.tpl.html',
        visible: true,
        description: '',
      };
      var chantiers = {
        main_title: 'hpo.chantiers.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'cubes',
        subs: [],
      };

      if (isKisRootUser()) {
        data.subs = data.subs.concat([
          dataCheck,
          dataExchange,
          dataPrepare,
          dataValidation,
          dataAnalyse,
        ]);
        model.subs = model.subs.concat([
          checkvalidation,
          jeuChoice,
          modelChoice,
          modelCalage,
          modelValidation,
          modelPrevision,
        ]);
        multicritere.subs = multicritere.subs.concat([
          multicritereComposantFilter,
          multicritereAutomatisation,
          multicritereParameters,
          multicritereConstruct,
          multicritereIndicateur,
          multicritereAnalyse,
          multicritereCompare,
          multicritereRetenu,
        ]);
        chantiers.subs = chantiers.subs.concat([
          multicritereCorrespondance,
          chantiersCreate,
          chantiersListe,
        ]);
        navigations = navigations.concat([
          title,
          admin,
          data,
          model,
          multicritere,
          chantiers,
        ]);
        return navigations;
      } else if (isRootUser()) {
        data.subs = data.subs.concat([
          dataCheck,
          dataExchange,
          dataPrepare,
          dataValidation,
          dataAnalyse,
        ]);
        model.subs = model.subs.concat([
          checkvalidation,
          jeuChoice,
          modelChoice,
          modelCalage,
          modelValidation,
          modelPrevision,
        ]);
        multicritere.subs = multicritere.subs.concat([
          multicritereComposantFilter,
          multicritereAutomatisation,
          multicritereParameters,
          multicritereConstruct,
          multicritereIndicateur,
          multicritereAnalyse,
          multicritereCompare,
          multicritereRetenu,
        ]);
        chantiers.subs = chantiers.subs.concat([
          multicritereCorrespondance,
          chantiersCreate,
          chantiersListe,
        ]);
        navigations = navigations.concat([
          title,
          admin,
          data,
          model,
          multicritere,
          chantiers,
        ]);
        return navigations;
      } else if (isDbMutualiseAdmin() || isHpoExpertClient()) {
        data.subs = data.subs.concat([
          dataCheck,
          dataExchange,
          dataPrepare,
          dataValidation,
          dataAnalyse,
        ]);
        model.subs = model.subs.concat([
          checkvalidation,
          jeuChoice,
          modelChoice,
          modelCalage,
          modelValidation,
          modelPrevision,
        ]);
        multicritere.subs = multicritere.subs.concat([
          multicritereComposantFilter,
          multicritereAutomatisation,
          multicritereParameters,
          multicritereConstruct,
          multicritereIndicateur,
          multicritereAnalyse,
          multicritereCompare,
          multicritereRetenu,
        ]);
        chantiers.subs = chantiers.subs.concat([
          multicritereCorrespondance,
          chantiersCreate,
          chantiersListe,
        ]);
        navigations = navigations.concat([
          title,
          admin,
          data,
          model,
          multicritere,
          chantiers,
        ]);
        return navigations;
      } else if (isHpoClient() || isDbMutualiseClient()) {
        model.subs = model.subs.concat([
          checkvalidation,
          jeuChoice,
          modelChoice,
          modelCalage,
          modelValidation,
          modelPrevision,
        ]);
        multicritere.subs = multicritere.subs.concat([
          multicritereComposantFilter,
          multicritereAutomatisation,
          multicritereParameters,
          multicritereConstruct,
          multicritereIndicateur,
          multicritereAnalyse,
          multicritereCompare,
          multicritereRetenu,
        ]);
        chantiers.subs = chantiers.subs.concat([
          multicritereCorrespondance,
          chantiersCreate,
          chantiersListe,
        ]);
        navigations = navigations.concat([
          title,
          data,
          model,
          multicritere,
          chantiers,
        ]);
        return navigations;
      }
    }

    return {
      getUser: getUser,
      getUserRoles: getUserRoles,
      isRootUser: isRootUser,
      isDbMutualiseAdmin: isDbMutualiseAdmin,
      isDbMutualiseClient: isDbMutualiseClient,
      isHpoExpertClient: isHpoExpertClient,
      isHpoClient: isHpoClient,
      getNavigationHpo: getNavigationHpo,
    };
  };
  HpoUserAppFactory.$inject = [
    '$http',
    'FeatureTypeFactory',
    '$filter',
    '$rootScope',
    '$location',
    'HpoCarteAppFactory',
  ];
  return HpoUserAppFactory;
});
