'use strict';
define(function() {
  var modelJeuData = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    EditFactory,
    $rootScope,
    $filter,
    ngDialog,
    $timeout,
    ParametersFactory,
    gaDomUtils,
    HpoAppServices,
    ImportExportFactory,
    HpoAppModelServices,
    authFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/model/views/directives/utilities/model_jeu_data_hpo.html',
      restrict: 'EA',
      scope: {
        model: '=',
        tableName: '=?',
        isJeu: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoModelJeuDataConfig';
        if (angular.isUndefined(scope.fixedheader)) scope.fixedheader = true;
        if (angular.isUndefined(scope.autoadjustheight)) {
          scope.autoadjustheight = false;
          scope.datatableHeight =
            angular.element('.xgos_content').height() -
            angular.element('#xgos_nav').height() -
            110 +
            'px';
        }

        scope.ftijeudonnee = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'jeu_de_donnee'
        )[0];
        if (scope.tableName) var ftis = [scope.model.fti];
        else var ftis = [scope.model.fti, scope.model.ftidefail];
        scope.hpo = {
          analysistools: 'allanalysis',
          ftis: ftis,
          tableselected: ftis[0],
          operands: [],
          clauseWhere: '1=1',
          result: [],
          attributestoselect: {},
          interpreteattributes: 'and',
          interpreteconditions: 'and',
          currentsridName: undefined,
          activeTab: 0,
        };
        scope.lastWhere = {};
        var pagingstate = '';

        var first = true;
        var changeTable = function(newval) {
          scope.hpo.tableselected = scope.hpo.ftis[newval];
          scope.hpo.operands = [];
          scope.hpo.clauseWhere = '1=1';
          scope.hpo.interpreteattributes = 'and';
          scope.hpo.interpreteconditions = 'and';
          scope.hpo.attributestoselect = {};
          scope.hpo.currentsridName = undefined;
          pagingstate = '';
        };
        scope.$watch('hpo.activeTab', function(newval, oldval) {
          if (
            angular.isDefined(newval) &&
            angular.isDefined(oldval) &&
            newval === -1 &&
            newval !== oldval
          ) {
            scope.hpo.activeTab = oldval;
            return;
          }
          if (angular.isDefined(newval) && newval !== -1 && newval !== oldval) {
            changeTable(newval);
          }
        });

        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;
        scope.changedAnalysisToolOrFti = function(newval) {
          if (angular.isDefined(newval) && newval !== -1) {
            changeTable(newval);
          }
        };

        if (scope.fti)
          scope.$watch('fti', function(newval, oldval) {
            if (newval) {
              scope.hpo.ftis = [newval];
              scope.hpo.tableselected = newval;
            }
          });

        /**
         * function passed to the datable to retrieve dossiers data
         * @param p
         * @returns {*}
         */
        scope.getData = function(p) {
          if (p) {
            scope.dataTableParams = p;
          }
          if (scope.dataTableParams.filter) {
            scope.dataTableParams.filter = scope.dataTableParams.filter
              .replace('AND  1=1  AND', '')
              .replace('AND  1=1', '')
              .replace('1=1', '');
          }
          scope.hpoInfoNames = {
            identifiant: scope.model.identifiant,
            tablename: scope.tableName,
          };
          var promise = HpoAppModelServices.getData(
            scope.model.identifiant,
            scope.hpo.tableselected,
            scope.dataTableParams.filter,
            scope.dataTableParams.crs,
            scope.dataTableParams.page,
            scope.dataTableParams.count,
            scope.dataTableParams.liaisonFilter,
            scope.dataTableParams.case_sensitive,
            scope.dataTableParams.sort,
            pagingstate,
            scope.tableName
          );
          promise.then(
            function(res) {
              if (res.data && res.data.hasOwnProperty('pagingstate')) {
                pagingstate = res.data.pagingstate;
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
          return promise;
        };

        var dialog = null;
        scope.addFeature = function() {
          scope.featuretoadd = {
            type: 'Feature',
            properties: {},
          };
          scope.uploadfile = {};
          scope.currentProperties = {};
          scope.featuretoattach = {};

          scope.attributesAuthorised = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
            scope.hpo.tableselected,
            'w'
          );
          scope.attributesAuthorised.map(function(x) {
            scope.featuretoadd.properties[x.name] = null;
          });
          scope.newObj = true;

          dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.create.feature.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            scope: scope,
          });
          dialog.then(function(data) {
            var features = {
              type: 'FeatureCollection',
              features: [data],
            };
            HpoAppModelServices.addFeatures(
              scope.hpo.tableselected,
              features,
              scope.model.identifiant
            ).then(
              function(res) {
                if (res.data && JSON.parse(res.data)) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    $filter('translate')('hpo.data.exchange.adds'),
                    false
                  );
                  $rootScope.$broadcast(
                    'reloadDatatable',
                    scope.hpo.tableselected.uid,
                    true
                  );
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          });
        };
        scope.buttonEditIcon = [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'pencil-square-o' },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: 'Editer le dossier',
            },
          },
        ];
        scope.editFeature = function(obj) {
          scope.newObj = false;
          scope.featuretoadd = angular.copy(obj);
          if (scope.featuretoadd && scope.featuretoadd.properties)
            scope.featuretoadd.properties = {};
          scope.attributesAuthorised = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
            scope.hpo.tableselected,
            'w'
          );
          scope.attributesAuthorised.map(function(x) {
            scope.featuretoadd.properties[x.name] = obj.properties[x.name];
          });
          scope.uploadfile = {};
          scope.featuretoattach = {};

          dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.create.feature.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            scope: scope,
          });
          dialog.then(function(data) {
            var features = {
              type: 'FeatureCollection',
              features: [data],
            };
            HpoAppModelServices.updateFeatures(
              scope.hpo.tableselected,
              features,
              scope.model.identifiant
            ).then(
              function(res) {
                if (res.data && JSON.parse(res.data)) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    $filter('translate')('hpo.data.exchange.updates'),
                    false
                  );
                  $rootScope.$broadcast(
                    'reloadDatatable',
                    scope.hpo.tableselected.uid,
                    true
                  );
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          });
        };
        scope.copyFeatures = function() {
          var callback = function(confirmed) {
            if (confirmed) {
              var f = angular.copy(scope.hpo.result);
              var features = {
                type: 'FeatureCollection',
                features: f.map(function(x) {
                  if (x.id) delete x.id;
                  return x;
                }),
              };
              EditFactory.add(
                scope.hpo.tableselected.uid,
                features,
                scope.hpo.tableselected.srid
              ).then(function(res) {
                if (res.data.errors.length > 0) {
                  require('toastr').error(res.data.errors[0]);
                }
                if (res.data.create.length > 0) {
                  $rootScope.$broadcast('reloadDatatable');
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    scope.hpo.result.length +
                      ' ' +
                      $filter('translate')('hpo.data.exchange.add'),
                    false
                  );
                }
              });
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            $filter('translate')('hpo.data.check.add_copy'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        var csvdialog;
        scope.importCsvOrShape = function() {
          scope.isModule = false;
          csvdialog = ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.import.html',
            className:
              'ngdialog-theme-plain ngdialog-theme-plain-hpo width95 nopadding import-csv-hpo miniclose',
            closeByDocument: false,
            title: $filter('translate')('hpo.common.importcsvshp'),
            scope: scope,
          });
        };

        var ngDialogPromise;
        scope.addAttribute = function() {
          scope.currentFeatureTypeAttribute = {};
          scope.newattribute = true;
          ngDialogPromise = ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.addcolumn.html',
            scope: scope,
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
          });
        };

        scope.addOnecolumn = function(data) {
          gaDomUtils.showGlobalLoader();
          HpoAppServices.addAttribute(scope.hpo.tableselected.uid, data).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res && res.data) {
                scope.hpo.tableselected.attributes.push(res.data);
                authFactory.getcurrentuser().then(
                  function(res) {
                    $rootScope.$broadcast(
                      'reloadDatatable',
                      scope.hpo.tableselected.uid,
                      true
                    );
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.success'),
                      $filter('translate')('hpo.common.addsuccess'),
                      true
                    );
                  },
                  function(res) {
                    $rootScope.$broadcast(
                      'reloadDatatable',
                      scope.hpo.tableselected.uid,
                      true
                    );
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.success'),
                      $filter('translate')('hpo.common.addsuccess'),
                      true
                    );
                  }
                );
              } else {
                AlertHpoFactory.getSimpleFail(
                  $filter('translate')('hpo.common.fail'),
                  $filter('translate')('hpo.common.addfail'),
                  true
                );
                gaDomUtils.hideGlobalLoader();
              }
              ngDialogPromise.close();
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        var ngDialogFilter;
        scope.applyFilter = function() {
          scope.configNameModif =
            scope.configName + '_' + scope.hpo.tableselected.uid;
          ngDialogFilter = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.applyfilter.html',
            scope: scope,
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
          });
          ngDialogFilter.then(function(data) {
            gaDomUtils.showGlobalLoader();
            HpoAppServices.createFilter(data).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  scope.hpo.clauseWhere = res.data;
                  scope.lastWhere[scope.hpo.tableselected.uid] = {
                    filter: res.data,
                    operands: scope.hpo.operands,
                  };
                  if (scope.showToastr)
                    require('toastr').info(
                      $filter('translate')('hpo.common.utilisercefilter')
                    );
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                AlertHpoFactory.showErrorMessage(res);
                gaDomUtils.hideGlobalLoader();
              }
            );
          });
        };

        scope.removeFilter = function() {
          scope.hpo.clauseWhere = '1=1';
          scope.hpo.operands = [];
          if (scope.showToastr)
            require('toastr').info(
              $filter('translate')('hpo.common.utilisercefilter')
            );
        };

        scope.evaluateFitler = function() {
          if (scope.hpo.clauseWhere === '1=1') return true;
          else {
            return false;
          }
        };

        scope.getlastfilter = function() {
          scope.hpo.clauseWhere =
            scope.lastWhere[scope.hpo.tableselected.uid].filter;
          scope.hpo.operands =
            scope.lastWhere[scope.hpo.tableselected.uid].operands;
          if (scope.showToastr)
            require('toastr').info(
              $filter('translate')('hpo.common.utilisercefilter')
            );
        };

        scope.evaluatelastFitler = function() {
          if (
            !scope.hpo ||
            !scope.hpo.tableselected ||
            !scope.lastWhere.hasOwnProperty(scope.hpo.tableselected.uid) ||
            scope.lastWhere[scope.hpo.tableselected.uid].filter ===
              scope.hpo.clauseWhere
          )
            return true;
          else {
            return false;
          }
        };

        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            scope.hpo.operands = dataHpo.savedata;
            if (scope.hpo.tableselected && scope.hpo.tableselected.uid) {
              var idx = scope.hpo.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(scope.hpo.tableselected.uid);
              if (~idx) {
                scope.hpo.tableselected = scope.hpo.ftis[idx];
                var attributesName = scope.hpo.tableselected.attributes.map(
                  function(x) {
                    return x.name;
                  }
                );
                /**
                 * Case attributes
                 */
                if (scope.hpo.operands && scope.hpo.operands.length > 0) {
                  var todeleteAttributes = [];
                  scope.hpo.operands.map(function(x, i) {
                    if (x) {
                      var idx = attributesName.indexOf(x.name);
                      if (idx !== -1)
                        scope.hpo.operands[i] = Object.assign(
                          scope.hpo.operands[i],
                          scope.hpo.tableselected.attributes[idx]
                        );
                      else {
                        todeleteAttributes.push(i);
                      }
                    }
                  });
                  if (todeleteAttributes.length > 0) {
                    for (var i = todeleteAttributes.length - 1; i >= 0; i--)
                      scope.hpo.operands.splice(todeleteAttributes[i], 1);
                    AlertHpoFactory.showAlertTemplateUpdate();
                  }
                }
                // $rootScope.$broadcast("reloadDatatable");
              }
            }
          }
        };

        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';

        scope.exportShp = function() {
          var nscope = $rootScope.$new();
          nscope.hpo = angular.copy(scope.hpo);
          ngDialogFilter = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.exportSHP.html',
            scope: nscope,
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
          });
          ngDialogFilter.then(function(data) {
            var attrs = [];
            for (var att in data.attributestoselect) {
              if (
                att &&
                data.attributestoselect.hasOwnProperty(att) &&
                data.attributestoselect[att]
              )
                attrs.push(att);
            }
            var attributes = {
              fti: scope.hpo.tableselected,
              attributes: attrs.join(';'),
            };
            if (scope.dataTableParams.filter) {
              scope.dataTableParams.filter = scope.dataTableParams.filter
                .replace('AND  1=1  AND', '')
                .replace('AND  1=1', '')
                .replace('1=1', '');
            }
            gaDomUtils.showGlobalLoader();
            var tableName;
            if (scope.isJeu) {
              tableName = HpoCarteAppFactory.getAppFactory().getJeuTableName(
                scope.model.identifiant,
                scope.hpo.tableselected.name
              );
            } else {
              tableName = scope.tableName;
            }

            HpoAppModelServices.exportLayersFeatures(
              'SHAPEFILE',
              data.currentsridName,
              attributes,
              scope.dataTableParams.filter,
              scope.model.identifiant,
              tableName
            ).then(
              function(exportResult) {
                gaDomUtils.hideGlobalLoader();
                var resultFileName = exportResult.data;
                var downloadurl =
                  '/services/'+localStorage.getItem('portal')+'/export/downloadexportedfile?f=json' +
                  '&exportedFileId=' +
                  resultFileName;
                window.open(downloadurl);
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          });
        };

        scope.disableSelection = function(attributestoselect, currentsridName) {
          if (
            !attributestoselect ||
            Object.keys(attributestoselect).length === 0 ||
            !currentsridName
          )
            return true;
          else {
            return false;
          }
        };

        scope.removeFeature = function(name, id) {
          console.log(name, id);
          if (name && id && id.length > 0) {
            gaDomUtils.showGlobalLoader();
            var promise = HpoAppModelServices.removeFeatures(
              scope.model.identifiant,
              name,
              id.join(',')
            ).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res.data && JSON.parse(res.data)) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.data.exchange.succes'),
                    $filter('translate')('hpo.data.exchange.suppresse'),
                    false
                  );
                  $rootScope.$broadcast(
                    'reloadDatatable',
                    scope.hpo.tableselected.uid,
                    true
                  );
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };

        scope.updateWithLatest = function() {
          var callback = function(confirmed) {
            if (confirmed) {
              var sendata = {
                fti: scope.hpo.tableselected,
                identifiant: scope.model.identifiant,
                uid: scope.ftijeudonnee.uid,
              };
              gaDomUtils.showGlobalLoader();
              HpoAppModelServices.updateAllFeatures(sendata).then(
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  if (res.data && JSON.parse(res.data)) {
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.data.exchange.succes'),
                      $filter('translate')('hpo.data.exchange.updates'),
                      false
                    );
                    $rootScope.$broadcast(
                      'reloadDatatable',
                      scope.hpo.tableselected.uid,
                      true
                    );
                  } else {
                    AlertHpoFactory.showErrorMessage(res);
                  }
                },
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.showErrorMessage(res);
                }
              );
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            $filter('translate')('hpo.common.checkupdate'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        scope.evaluateFti = function() {
          var hide = true;
          if (
            scope.hpo.tableselected &&
            scope.hpo.tableselected.relations &&
            scope.hpo.tableselected.relations.length > 0 &&
            !HpoCarteAppFactory.getAppFactory().getFuiteTables(
              scope.hpo.tableselected
            )
          )
            hide = false;
          return hide;
        };

        if (scope.tableName) {
          scope.datatableCrudHpo = {
            extraActions: [
              {
                name: $filter('translate')('hpo.common.exportShp'),
                class: 'btn-default small-margin-left-right',
                func: scope.exportShp,
                special: true,
              },
            ],
          };
        } else {
          scope.datatableCrudHpo = {
            create: { func: scope.addFeature },
            update: { func: scope.editFeature },
            remove: { func: scope.removeFeature },
            extraActions: [
              {
                name: $filter('translate')('hpo.common.updatewithlatest'),
                class: 'btn-info small-margin-left-right',
                func: scope.updateWithLatest,
                specialhide: scope.evaluateFti,
                special: true,
              },
              {
                name: $filter('translate')('hpo.common.exportShp'),
                class: 'btn-default small-margin-left-right',
                func: scope.exportShp,
                special: true,
              },
            ],
          };
        }
        scope.finishedload = true;
      },
    };
  };

  modelJeuData.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'EditFactory',
    '$rootScope',
    '$filter',
    'ngDialog',
    '$timeout',
    'ParametersFactory',
    'gaDomUtils',
    'HpoAppServices',
    'ImportExportFactory',
    'HpoAppModelServices',
    'authFactory',
  ];
  return modelJeuData;
});
