'use strict';
define(function() {
  var dashboardCarte = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    CarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    UnitFactory,
    CalculFactory,
    HpoUserAppFactory,
    CarteInitProvider,
    HpoAppServices
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapappv2/home_admin_data/views/utilities/data/dashboard_carte.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.ftihistory = CarteAppFactory.getFeatureTypes('stat_hist')[0];
        scope.filter = '"USER" = \'' + CarteInitProvider.getUser().login + "'";
        if (CarteInitProvider.getUser() && CarteInitProvider.getUser().uid) {
          scope.filter +=
            ' AND "USERID" = \'' + CarteInitProvider.getUser().uid + "'";
        }
        scope.data = {};
        scope.currentheight = ($window.innerHeight * 1.2) / 2 + 'px';
        scope.getData = function() {
          gaDomUtils.showGlobalLoader();
          QueryFactory.data(
            scope.ftihistory.uid,
            scope.filter,
            CarteAppFactory.getSrid(),
            '',
            '',
            ''
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();

              if (res && res.data && res.data.features) {
                res.data.features.map(function(x) {
                  if (x) {
                    x.loaded = false;
                  }
                });
                scope.data = res.data.features;
                $timeout(function() {
                  HpoAppServices.getDashboards(
                    scope.ftihistory.uid,
                    res.data
                  ).then(
                    function(res) {
                      if (res && res.data) {
                        var ids = scope.data
                          .map(function(x) {
                            if (x) return x.id;
                          })
                          .filter(function(x) {
                            if (x) return x;
                          });
                        for (var id in res.data) {
                          if (id && res.data.hasOwnProperty(id)) {
                            var idx = ids.indexOf(id);
                            if (~idx) {
                              if (
                                res.data[id] &&
                                res.data[id].tableselected &&
                                res.data[id].tableselected.uid
                              )
                                res.data[
                                  id
                                ].tableselected = FeatureTypeFactory.getFeatureByUid(
                                  res.data[id].tableselected.uid
                                );
                              scope.data[idx].statistic = res.data[id];
                              scope.data[idx].loaded = true;
                              scope.data[idx].index = idx;
                            }
                          }
                        }
                      }
                    },
                    function(res) {
                      AlertHpoFactory.showErrorMessage(res);
                    }
                  );
                }, 5000);
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
        scope.getData();

        scope.ShowFullAnalyse = function(obj) {
          if (obj) {
            scope.selectedInfo = obj;
            scope.currentDashboard = angular.copy(obj);
            scope.noupdate = false;
            var dialog = ngDialog.openConfirm({
              template:
                'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.dashboard.html',
              className:
                'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
              scope: scope,
            });
            dialog.then(function(data) {
              if (data) {
                gaDomUtils.showGlobalLoader();
                HpoAppServices.updateDashboard(
                  scope.currentDashboard.historicfti,
                  scope.currentDashboard.id,
                  data
                ).then(
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    if (res.data && JSON.parse(res.data)) {
                      var ids = scope.data.map(function(x) {
                        return x.id;
                      });
                      var idx = ids.indexOf(data.id);
                      if (~idx) {
                        scope.data[idx].loaded = false;
                        $timeout(function() {
                          scope.data[idx].statistic = data;
                          scope.data[idx].loaded = true;
                        }, 300);
                      }
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.info'),
                        $filter('translate')('hpo.data.analyse.updated'),
                        false,
                        'success'
                      );
                    } else {
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('hpo.common.info'),
                        $filter('translate')('hpo.error.data.updatedashboard'),
                        true,
                        'error'
                      );
                    }
                  },
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
              }
            });
          }
        };
      },
    };
  };

  dashboardCarte.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'CarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'UnitFactory',
    'CalculFactory',
    'HpoUserAppFactory',
    'CarteInitProvider',
    'HpoAppServices',
  ];
  return dashboardCarte;
});
