'use strict';
define(function () {
  var atlas = function (
      SelectManager,
      gcStyleFactory,
      $filter,
      gaDomUtils,
      gcInteractions,
      AtlasService,
      gclayers,
      gaJsUtils
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/atlas/views/atlasSelection.html',
      restrict: 'E',
      scope: {
        map: '=',
        result: '=',
        model: '=',
        scale: '=',
        type: '=',
        layer: '=',
        toolbarwidget: '=?',
        ftid: '=?',
      },
      link: function (scope) {

        scope.ftid = [];
        scope.selection = {
          tovalidate: false,
          geometry: undefined,
          active: false
        };

        /**
         * Infos dessin ligne de selection
         */
        scope.lineDraw = new ol.interaction.Draw({
          type: 'LineString',
          style: gcStyleFactory.getStyle('select'),
        });
        scope.lineDraw.set('gctype', 'kis');
        scope.lineDraw.set('interaction', 'Draw');
        scope.lineDraw.set('widget', 'atlas');
        scope.lineDraw.setActive(false);
        scope.lineDraw.on('drawend', function (evt) {
          try {
            scope.layer.setVisible(true);
            scope.layer.setZIndex(gaJsUtils.getZIndexMax(scope.map) + 1);
            try {
              scope.layer.getSource().clear();
            } catch (e) {
              console.log(e);
            }
            scope.layer.getSource().addFeature(evt.feature.clone());
            scope.selection.geometry = evt.feature.getGeometry();
            scope.selection.tovalidate = true;
            require('toastr').info(
                $filter('translate')('atlas.validateselection')
            );
          } catch (e) {
            require('toastr').error(
                $filter('translate')('atlas.echechselection')
            );
            SelectManager.clear();
            scope.result = scope.selection.geometry = undefined;
          }
        });

        /**
         * Selection par ligne
         */
        scope.selectbypline = () => {
          scope.removeSelection();
          scope.selection.active = true;
          scope.lineDraw.setActive(true);
          gcInteractions.setCurrentToolBar(scope.toolbarwidget);
          scope.map.addInteraction(scope.lineDraw);
        };

        /**
         * Infos selection par polygone
         */
        scope.polygonDraw = new ol.interaction.Draw({
          source: gclayers.getDrawLayer().getSource(),
          type: 'Polygon',
          style: gcStyleFactory.getStyle('select')
        });
        scope.polygonDraw.set('gctype', 'kis');
        scope.polygonDraw.set('interaction', 'Draw');
        scope.polygonDraw.set('widget', 'atlas');
        scope.polygonDraw.setActive(false);
        scope.polygonDraw.on('drawend', (evt) => {
          try {
            scope.layer.setVisible(true);
            scope.layer.setZIndex(gaJsUtils.getZIndexMax(scope.map) + 1);
            try {
              scope.layer.getSource().clear();
            } catch (e) {
              console.log(e);
            }
            scope.layer.getSource().addFeature(evt.feature.clone());
            scope.selection.geometry = evt.feature.getGeometry();
            scope.selection.tovalidate = true;
            require('toastr').info(
                $filter('translate')('atlas.validateselection')
            );
            scope.map.removeLayer(gclayers.getDrawLayer());
          } catch (e) {
            require('toastr').error(
                $filter('translate')('atlas.echechselection')
            );
            try {
              scope.layer.getSource().clear();
            } catch (e) {
              console.log(e);
            }
            scope.result = scope.selection.geometry = undefined;
          }
        });

        /**
         * Selection par polygone
         */
        scope.selectbypolygon = () => {
          scope.removeSelection();
          scope.selection.active = true;
          scope.polygonDraw.setActive(true);
          gcInteractions.setCurrentToolBar(scope.toolbarwidget);
          scope.map.addInteraction(scope.polygonDraw);
        };

        /**
         * Infos selection par cadre
         */
        scope.dragBox = new ol.interaction.DragBox({
          type: 'Polygon',
          style: gcStyleFactory.getStyle('select')
        });
        scope.dragBox.set('gctype', 'kis');
        scope.dragBox.set('interaction', 'Select');
        scope.dragBox.set('widget', 'atlas');
        scope.dragBox.setActive(false);
        scope.dragBox.on('boxend', () => {
          try {
            scope.layer.setVisible(true);
            scope.layer.setZIndex(gaJsUtils.getZIndexMax(scope.map) + 1);
            try {
              scope.layer.getSource().clear();
            } catch (e) {
              console.log(e);
            }
            var feature = new ol.Feature({
              geometry: scope.dragBox.getGeometry(),
            });
            scope.layer.getSource().addFeature(feature);
            scope.selection.geometry = scope.dragBox.getGeometry();
            scope.selection.tovalidate = true;
            require('toastr').info(
                $filter('translate')('atlas.validateselection')
            );
          } catch (e) {
            require('toastr').error(
                $filter('translate')('atlas.echechselection')
            );
            try {
              scope.layer.getSource().clear();
            } catch (e) {
              console.log(e);
            }
            scope.result = scope.selection.geometry = undefined;
          }
        });

        /**
         * Selection par cadre
         */
        scope.selectbyframe = () => {
          scope.removeSelection();
          scope.selection.active = true;
          scope.dragBox.setActive(true);
          gcInteractions.setCurrentToolBar(scope.toolbarwidget);
          scope.map.addInteraction(scope.dragBox);
        };

        scope.selectionCourante = () => {
          try {
            gaDomUtils.showGlobalLoader();
            scope.type = 'selection';
            var sfc = SelectManager.getFeatures();
            if (sfc.features.length > 0) {
              var result = [];
              var format = new ol.format.GeoJSON();
              for (var i = 0; i < sfc.features.length; i++) {
                var f = sfc.features[i];
                if (f.id && scope.ftid.indexOf(f.id) === -1) {
                  scope.ftid.push(f.id);
                }
                var feat = format.readFeature(f);
                var e = feat.getGeometry().getExtent();
                if (AtlasService.indexOfExtent(result, e) === -1) {
                  result.push([e[0], e[1], e[2], e[3]]);
                }
              }
              scope.result = result;
              scope.layer.setVisible(false);
              scope.layer.getSource().clear();
            } else {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                  $filter('translate')('atlas.echechselection')
              );
              scope.layer.setVisible(false);
              scope.layer.getSource().clear();
              scope.result = scope.selection.geometry = undefined;
            }
          } catch (e) {
            gaDomUtils.hideGlobalLoader();
            require('toastr').error(
                $filter('translate')('atlas.echechselection')
            );
            scope.layer.setVisible(false);
            scope.layer.getSource().clear();
            scope.result = scope.selection.geometry = undefined;
          }
        };

        /**
         * Valide la selection en cours
         */
        scope.validerSelection = function () {
          scope.type = undefined;
          if (scope.lineDraw.getActive()) {
            scope.type = 'line';
          }
          if (scope.polygonDraw.getActive()) {
            scope.type = 'polygon';
          }
          if (scope.dragBox.getActive()) {
            scope.type = 'frame';
          }
          if (scope.selection.geometry) {
            scope.result = angular.copy(scope.selection.geometry);
          } else {
            gaDomUtils.hideGlobalLoader();
            require('toastr').error(
                $filter('translate')('itv.correspondance.nofeatureselected')
            );
            scope.result = scope.selection.geometry = undefined;
          }
          scope.removeSelection();
        };

        /**
         * Remove all selections
         */
        scope.removeSelection = () => {
          scope.selection.active = false;
          scope.selection.tovalidate = false;
          scope.lineDraw.setActive(false);
          scope.map.removeInteraction(scope.lineDraw);
          scope.dragBox.setActive(false);
          scope.map.removeInteraction(scope.dragBox);
          scope.polygonDraw.setActive(false);
          scope.map.removeInteraction(scope.polygonDraw);
          scope.layer.setVisible(false);
          try {
            scope.layer.getSource().clear();
          } catch (e) {
            console.error(e);
          }
          scope.selection.geometry = undefined;
          gaDomUtils.hideGlobalLoader();
        };

        scope.$on('removeSelection', scope.removeSelection);
      },
    };
  };

  atlas.$inject = [
    'SelectManager',
    'gcStyleFactory',
    '$filter',
    'gaDomUtils',
    'gcInteractions',
    'AtlasService',
    'gclayers',
    'gaJsUtils'
  ];
  return atlas;
});
