'use strict';
define(function() {
  var EsriSymbolFactory = function($http) {
    var EsriSymbolFactory = {};

    /**
     * Function: getFontClasses
     */
    function getFontClasses() {
      var promise = $http.get(
        '/services/{portalid}/symbolfonts/getclasses?f=json'
      );

      return promise;
    }

    /**
     * Function: getFontFiles
     */
    function getFontFiles() {
      var promise = $http.get(
        '/services/{portalid}/symbolfonts/getfonts?f=json'
      );

      return promise;
    }

    /**
     * Function: encodeFont
     */
    function encodeFont(fontClass, fontName, size, color) {
      var promise = $http.post(
        '/services/{portalid}/symbolfonts/encodefont?f=json' +
          '&fontClass=' +
          fontClass +
          '&fontName=' +
          fontName +
          '&size=' +
          size +
          '&color=' +
          color
      );

      return promise;
    }

    return {
      EsriSymbolFactory: EsriSymbolFactory,
      getFontClasses: getFontClasses,
      getFontFiles: getFontFiles,
      encodeFont: encodeFont,
    };
  };
  EsriSymbolFactory.$inject = ['$http'];
  return EsriSymbolFactory;
});
