'use strict';
define(function() {
  var GeopackageService = function($http) {
    var GeopackageService = {};

    /**
     * Class : GeopackageService
     * Factory WebServices
     */

    /**
     * Function: exportGeopackage
     */
    function exportGeopackage(data) {
      var promise = $http.post('/services/{portalid}/geopackage/export', data);
      return promise;
    }

    /**
     * Function: exportGeopackageMbtiles
     */
    function exportGeopackageMbtiles(data, from) {
      var promise = $http.post(
        '/services/{portalid}/geopackage/exportmulti?from=' + from,
        data
      );

      return promise;
    }

    /**
     * Function: getConfig
     * @param {string} format , geojson ou json
     */
    function getProgression(p) {
      var promise = $http.post(
        '/services/{portalid}/geopackage/get/progression?',
        p
      );

      return promise;
    }

    /**
     * Function: getFile
     * @param {string} format , geojson ou json
     */
    function getFile(p) {
      var promise = $http.post('/services/{portalid}/geopackage/getFile?', p);

      return promise;
    }

    /**
     * Function: getFile
     * @param {string} format , geojson ou json
     */
    function getZipFile(p) {
      var promise = $http.post(
        '/services/{portalid}/geopackage/getZipFile?',
        p
      );

      return promise;
    }

    /**
     * Function: getFile
     * @param {string} format , geojson ou json
     */
    function getTablesGeopackage(uid) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/getTablesGeopackage?f=json' +
          '&uid=' +
          uid
      );

      return promise;
    }
    /**
     * Function: getObjectsGeopackage
     * @param {string} format , geojson ou json
     */
    function getObjectsGeopackage(uid) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/getObjectsGeopackage?f=json' +
          '&uid=' +
          uid
      );

      return promise;
    }

    /**
     * Function: getObjectsGeopackage
     * @param {string} format , geojson ou json
     */
    function getAllObjectsGeopackage(uid) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/getAllObjectsGeopackage?f=json' +
          '&uid=' +
          uid
      );

      return promise;
    }
    /**
     * Function: getObjectsGeopackage
     * @param {string} format , geojson ou json
     */
    function getModifiedObjectById(uid, idObject, srid) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/getModifiedObjectById?f=json' +
          '&uid=' +
          uid +
          '&idObject=' +
          idObject +
          '&srid=' +
          srid
      );

      return promise;
    }
    /**
     * Function: synchroGeopackage
     * @param {string} format , geojson ou json
     */
    function synchroGeopackage(uid, mapCode) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/synchroGeopackage?f=json' +
          '&uid=' +
          uid +
          '&mapCode=' +
          mapCode
      );

      return promise;
    }
    /**
     * Function: getObjectsForUpdate
     * @param {string} format , geojson ou json
     */
    function getObjectsForUpdate(uid) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/getObjectsForUpdate?f=json' +
          '&uid=' +
          uid
      );

      return promise;
    }
    /**
     * Function: getObjectsForUpdate
     * @param {string} format , geojson ou json
     */
    function getObjectsForDelete(uid) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/getObjectsForDelete?f=json' +
          '&uid=' +
          uid
      );

      return promise;
    }
    /**
     * Function: addObjectsForComponent
     * @param {string} format , geojson ou json
     */
    function addObjectsForComponent(uid, name) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/addObjectsForComponent?f=json' +
          '&uid=' +
          uid +
          '&name=' +
          name
      );

      return promise;
    }
    /**
     * Function: addObjectsForComponent
     * @param {string} format , geojson ou json
     */
    function synchroByComponent(uid, tableName, mapCode) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/synchroByComponent?f=json' +
          '&uid=' +
          uid +
          '&tableName=' +
          tableName +
          '&mapCode=' +
          mapCode
      );

      return promise;
    }
    /**sss
     * Function: getObjectsForUpdate
     * @param {string} format , geojson ou json
     */
    function getObjectsForUpdateGeom(uid) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/getObjectsForUpdateGeom?f=json' +
          '&uid=' +
          uid
      );

      return promise;
    }
    /**sss
     * Function: checkAttachementsObject
     * @param {string} format , geojson ou json
     */
    function checkAttachementsObject(id, attC) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/checkAttachementsObject?f=json' +
          '&id=' +
          id +
          '&attC=' +
          attC
      );

      return promise;
    }
    /**
     * Function: getObjectsGeopackage
     * @param {string} format , geojson ou json
     */
    function updateAttachement(uid, idObject) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/updateAttachement?f=json' +
          '&uid=' +
          uid +
          '&idObject=' +
          idObject
      );

      return promise;
    }
    /**
     * Function: getObjectsForUpdate
     * @param {string} format , geojson ou json
     */
    function getObjectsForAdd(uid) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/getObjectsForAdd?f=json' +
          '&uid=' +
          uid
      );

      return promise;
    }
    /**
     * Function: getObjectsGeopackage
     * @param {string} format , geojson ou json
     */
    function getCollObjectByIds(uid, fids, tableName, srid) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/getCollObjectByIds?f=json' +
          '&uid=' +
          uid +
          '&fids=' +
          fids +
          '&tableName=' +
          tableName +
          '&srid=' +
          srid
      );

      return promise;
    }
    /**
     * Function: getObjectsGeopackage
     * @param {string} format , geojson ou json
     */
    function synchroAttachementForAddedobject(uid, tableName, newid) {
      var promise = $http.get(
        '/services/{portalid}/geopackage/synchroAttachementForNewObj?f=json' +
          '&uid=' +
          uid +
          '&tableName=' +
          tableName +
          '&newid=' +
          newid
      );

      return promise;
    }

    return {
      GeopackageService: GeopackageService,
      exportGeopackage: exportGeopackage,
      exportGeopackageMbtiles: exportGeopackageMbtiles,
      getProgression: getProgression,
      getFile: getFile,
      getZipFile: getZipFile,
      getTablesGeopackage: getTablesGeopackage,
      getObjectsGeopackage: getObjectsGeopackage,
      getAllObjectsGeopackage: getAllObjectsGeopackage,
      getModifiedObjectById: getModifiedObjectById,
      synchroGeopackage: synchroGeopackage,
      getObjectsForUpdate: getObjectsForUpdate,
      getObjectsForDelete: getObjectsForDelete,
      addObjectsForComponent: addObjectsForComponent,
      synchroByComponent: synchroByComponent,
      getObjectsForUpdateGeom: getObjectsForUpdateGeom,
      checkAttachementsObject: checkAttachementsObject,
      updateAttachement: updateAttachement,
      getObjectsForAdd: getObjectsForAdd,
      getCollObjectByIds: getCollObjectByIds,
      synchroAttachementForAddedobject: synchroAttachementForAddedobject,
    };
  };
  GeopackageService.$inject = ['$http'];
  return GeopackageService;
});
