'use strict';
define(function() {
  var toolbargeosignet = function(ParametersFactory, $filter, $rootScope) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/geosignet/views/toolbargeosignet.html',
      restrict: 'A',

      link: function(scope, element) {
        scope.popover = {};
        var map = scope.map;
        scope.currentuser = $rootScope.xgos.user.login;
        scope.places = [];

        /**
         * set the places
         */
        $rootScope.$watch('xgos.mouseposition.srid.name', srid => {
          ParametersFactory.getbytype('Geosignet', srid).then(res => {
            res.data.sort((a, b) => a.name.localeCompare(b.name));
            scope.places = res.data || [];
          });
        });

        /**
         * [add description]
         */
        scope.add = function() {
          if (scope.popover.content.currentname != '') {
            var size = map.getSize();
            var mapExtent = map.getView().calculateExtent(size);
            var p = {
              label: scope.popover.content.currentname,
              extent: mapExtent,
              srid: map
                .getView()
                .getProjection()
                .getCode(),
            };

            var found = scope.places
              .map(function(x) {
                return x.name;
              })
              .indexOf(scope.popover.content.currentname);
            if (found == -1) {
              ParametersFactory.add(p, 'Geosignet', p.label).then(function(
                res
              ) {
                scope.places.push(res.data);
                scope.popover.content.currentname = '';
              });
            } else {
              var ans = confirm(
                $filter('translate')('geosignet.confirm_update')
              );
              if (ans) {
                ParametersFactory.getbyid(scope.places[found].id).then(function(
                  res
                ) {
                  var newPlace = res.data;
                  newPlace.data = p;
                  ParametersFactory.update(
                    newPlace,
                    scope.places[found].id
                  ).then(
                    function() {
                      require('toastr').success(
                        $filter('translate')('common.saved')
                      );
                      scope.popover.content.currentname = '';
                      setPlaces();
                    },
                    function(reason) {
                      console.log(reason);
                    }
                  );
                });
              }
            }
          }
        };
        /**
         * [remove description]
         * @param  {[type]} place [description]
         * @return {[type]}       [description]
         */
        scope.remove = function(place) {
          var ans = confirm($filter('translate')('geosignet.confirm_delete'));
          if (ans) {
            ParametersFactory.remove(place.id).then(function() {
              var deleteIndex = scope.places
                .map(function(x) {
                  return x.name;
                })
                .indexOf(place.name);
              scope.places.splice(deleteIndex, 1);
            });
          }
        };
        scope.save = function() {};
        scope.go = function(place) {
          //console.log(place.extent);
          var size = map.getSize();
          var view = map.getView();

          view.fit(place.data.extent, size);
        };

        scope.filter = {};

        var btnElt = $(element.children()[0]);
        btnElt.bind('click', function() {
          if (scope.isActive) {
            btnElt.removeClass('btn-info');
            btnElt.addClass('btn-default');
            scope.isActive = false;
          } else {
            btnElt.removeClass('btn-default');
            btnElt.addClass('btn-info');
            scope.isActive = true;
          }
        });

        scope.$on('closeToolsBar_toolbargeosignet', function() {
          if (scope.isActive) $('#toolbar_geosignet_popover').click();
          btnElt.removeClass('btn-info');
          btnElt.addClass('btn-default');
          scope.isActive = false;
        });
      },
    };
  };

  toolbargeosignet.$inject = ['ParametersFactory', '$filter', '$rootScope'];
  return toolbargeosignet;
});
