'use strict';
define(function() {
  var basemapwidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    gcPopup,
    extendedNgDialog,
    gaDomUtils,
    GeoTreatmentFactory,
    $timeout,
    FeatureTypeFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/geotreatment/views/treatments/treatSetInfoToRelation.html',
      restrict: 'A',
      link: function(scope, elt, attrs, ctrl) {
        var map = scope.map;
        scope.activetreatment = '';
        scope.res = {};
        scope.attributes_select = [];
        scope.inprogress = false;
        scope.interrupt = false;
        scope.geoLimit = GeoTreatmentFactory.DATABASE;
        scope.typeOfGeotreatment = 'setInfoToRelation';
        scope.attributesTochange = '';
        scope.relation = '';
        scope.insertNew = false;

        let handlePromiseError= () =>{
          scope.inprogress = false;
        };

        function getAttrListOfFtilink() {
          var aliases = [];
          if (!scope.insertNew) {
            aliases.push('ID');
            aliases.push(scope.attributelink);
            aliases.push(scope.attributelink + ' NEW');
          } else {
            aliases.push(
              scope.relation.fieldStart +
                '(' +
                scope.relation.componentStart +
                ')'
            );
            aliases.push(
              scope.relation.fieldEnd + '(' + scope.relation.componentEnd + ')'
            );
          }
          return aliases;
        }

        scope.stop = function() {
          GeoTreatmentFactory.stoptreatment(scope.state).then(function() {
            scope.inprogress = false;
            scope.interrupt = true;
          }).catch(handlePromiseError);
        };

        scope.correction = function(obj) {
          scope.currentobj = obj;
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/geotreatment/views/modals/modal.correct.fusionLine.html',
            className: 'ngdialog-theme-plain width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: {
              title: 'Corrections',
            },
          });
        };

        scope.attributeChse2 = '';
        scope.$watch('relation', function(rel, oldVal) {
          if (angular.isDefined(rel) && angular.isDefined(rel.idEnd))
            scope.ftilink = FeatureTypeFactory.getFeatureByUid(rel.idEnd);
        });

        scope.run = function(fti1, relation) {
          scope.relation = relation;
          scope.attributesTochange =
            scope.ExternalSource == 'fromAttribute'
              ? scope.attributelink
              : relation.fieldEnd + '(' + relation.componentEnd + ')';
          scope.insertNew =
            scope.ExternalSource == 'fromAttribute' ? false : true;
          scope.inprogress = true;
          const featureCollections = [];
          const spatialClause = 
            GeoTreatmentFactory.getSpatialClause(
              scope.geoLimit,
              scope.map,
              scope.limitZoneGeometry,
              [fti1.name],
              featureCollections);
          var param = {
            spatialclause: spatialClause,
            featureCollections: featureCollections,
            fti1: fti1.uid,
            constanteValue:
              scope.ComponentSource == 'fromAttribute' ? false : true,
            attributetoset:
              scope.ComponentSource == 'fromAttribute'
                ? scope.attributetoset
                : scope.attributeTosetConstante,
            relationname: relation.name,
            ftilink: scope.ftilink.uid,
            insertNew: scope.insertNew,
            attributelink: scope.insertNew ? '' : scope.attributelink,
            srid: scope.map.getView().getProjection().getCode()
          };
          GeoTreatmentFactory.treatment(
            param,
            'SetInfoToRelation'
          ).then(function(data) {
            scope.state = data.data;
            scope.httpStatus=data.status;
            GeoTreatmentFactory.tick(scope, getAttrListOfFtilink());
          }).catch(handlePromiseError);
        };
      },
    };
  };
  basemapwidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    'gcPopup',
    'extendedNgDialog',
    'gaDomUtils',
    'GeoTreatmentFactory',
    '$timeout',
    'FeatureTypeFactory',
  ];
  return basemapwidget;
});
