'use strict';
define(function() {
  var templatebasewidget = function(FeatureTypeFactory) {
    return {
      templateUrl:'js/XG/widgets/mapapp/layerManager/views/zoomOnLayer.html',
      restrict: 'A',
      scope: {
        layer: '=',
        map: '=',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.zoomOnExtent = function() {
          FeatureTypeFactory.getExtent(
            scope.layer.fti.uid,
            scope.map
              .getView()
              .getProjection()
              .getCode()
          ).then(
            function(res) {
              var bbox = res.data;
              scope.map.getView().fit(bbox, scope.map.getSize());
            },
            function(data) {
              require('toastr').info(data);
            }
          );
        };
      },
    };
  };

  templatebasewidget.$inject = ['FeatureTypeFactory'];
  return templatebasewidget;
});
