'use strict';
define(function() {
  var statistiqueWidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    FilesFactory,
    FeatureTypeFactory,
    ChartLocaliseFactory,
    SelectManager,
    QueryFactory,
    StyleFactory,
    ngDialog,
    gaDomUtils,
    PortalsFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/statistiques/views/stat.html',

      restrict: 'A',
      //dataattribute
      link: function(scope, elt, attrs, ctrl) {
        var mode = '';
        var map = scope.map;
        var portalid = angular.module('gcMain').portalid;

        if (portalid == undefined || portalid == '') {
          portalid = PortalsFactory.getPortalId();
        }

        scope.myfilter = {};
        scope.myfilter.typeInfo = 'POLYGON';

        //Config chart
        scope.selectChart = { config: {}, data: {}, styles: [] };
        scope.component = FeatureTypeFactory.resources.featuretypes;
        scope.componentlink = [];
        scope.selectedcomponent;
        scope.selectedcomponentsupport;
        scope.selectedcomponentlink;
        scope.selectedattribut;
        scope.attributssupport;
        scope.selectedrelation;
        scope.selectedRepresentation;
        scope.selectedOperation;
        scope.current = {};
        scope.ftidata = null;
        scope.selectChart.config.filters = [];
        scope.resomap = 0;
        scope.iteration = 5;

        /**
         * Open Palette Library
         */
        scope.currentPalette = {
          data: {
            id: 'tol-dv',
            nb: scope.iteration,
          },
          symbolType: 'POLYGON',
        };
        //scope.selectFeatures =

        /////// Fonctions CHLORROPLETH ////
        ////// CAS VALEUR DIRECTE/////////
        /**
         * [calcdiscrete calcul de la legende cas chloro /valeurs directes/ discrete]
         * @return
         */
        scope.calcdiscrete = function() {
          gaDomUtils.showGlobalLoader();
          scope.selectChart.styles = [];
          var fti = scope.selectedcomponentsupport;
          QueryFactory.dataattribute(
            fti.uid,
            scope.selectedattribut.att.name
          ).then(function(res) {
            //console.log(res.data);
            var sizel = res.data.length;
            scope.currentPalette.data.nb = sizel;
            scope.current.gpalette = StyleFactory.paletteGenerator(
              scope.currentPalette.data
            );
            for (var i = 0; i < res.data.length; i++) {
              scope.selectChart.styles.push({
                hexa: '#' + scope.current.gpalette[i],
                color: hexToRgb(scope.current.gpalette[i]),
                val: res.data[i],
                name: res.data[i],
              });
            }
            gaDomUtils.hideGlobalLoader();
          });
        };

        // Interval regulier calculer les intervales en fonction du nombre de classe donnée de manière à avoir un écart identique entre chaque intervale
        /**
         * [calcinterv calcul de la legende cas chloro /valeurs directes/ intervale regulier]
         * @param   iteration
         * @return
         */
        scope.calcinterv = function(iteration) {
          scope.selectChart.styles = [];
          var fti = scope.selectedcomponentsupport;
          QueryFactory.dataattribute(
            fti.uid,
            scope.selectedattribut.att.name
          ).then(function(res) {
            var min = 0;
            var max = 0;
            angular.forEach(res.data, function(value) {
              if (min > Number(value)) {
                min = Number(value);
              }

              if (max < Number(value)) {
                max = Number(value);
              }
            });
            var amplitude = Math.abs(max - min);
            var variant = amplitude / iteration;
            var current_value = angular.copy(min);
            scope.current.interv = [];
            scope.current.interv.push(current_value);
            scope.currentPalette.data.nb = iteration;
            scope.current.gpalette = StyleFactory.paletteGenerator(
              scope.currentPalette.data
            );
            var i = 0;
            while (current_value < max) {
              var maxv = current_value + variant;
              scope.selectChart.styles.push({
                hexa: '#' + scope.current.gpalette[i],
                color: hexToRgb(scope.current.gpalette[i]),
                max: Math.round((maxv * 100) / 100),
                min: Math.round((current_value * 100) / 100),
                name:
                  '[' +
                  Math.round(current_value) +
                  ',' +
                  Math.round(maxv) +
                  ']',
              });
              current_value = current_value + variant;
              i++;
            }
          });
        };
        /**
         * [compare description]
         * @param  {[type]} x [description]
         * @param  {[type]} y [description]
         * @return {[type]}   [description]
         */
        function compare(x, y) {
          return x - y;
        }
        // Interval population identique: calculer les intervales en fonction du nombre de classe donnée de manière à avoir le nombre d'objets identique dans chauqe interval
        /**
         * [calcintervPop dcalcul de la legende cas chloro /valeurs directes/ intervale à population identique]
         * @param  {[type]} iteration [description]
         * @return {[type]}           [description]
         */
        scope.calcintervPop = function(iteration) {
          gaDomUtils.showGlobalLoader();
          scope.selectChart.styles = [];
          var fti = scope.selectedcomponentsupport;
          //QueryFactory.data(fti.uid, "1=1", undefined, undefined, undefined,undefined).then(function(res){
          if (scope.selectChart.config.datasource == 'DB') {
            scope.selectChart.data = {};
          } else {
            scope.selectChart.data = SelectManager.getFeaturesByftiType(
              scope.selectedcomponentsupport.name
            );
          }
          ChartLocaliseFactory.dataStyle(scope.selectChart).then(function(res) {
            var atts = [];
            for (var j = 0; j < res.data.features.length; j++) {
              // atts.push(res.data.features[j].properties[scope.selectedattribut.att.name]);
              atts.push(res.data.features[j].properties['value']);
            }
            var min = 0;
            var max = 0;
            angular.forEach(atts, function(value) {
              if (min > Number(value)) {
                min = Number(value);
              }
              if (max < Number(value)) {
                max = Number(value);
              }
            });
            var tab = atts;
            tab.sort(compare);
            var X = Math.round(res.data.features.length / iteration);
            scope.currentPalette.data.nb = iteration;
            scope.current.gpalette = StyleFactory.paletteGenerator(
              scope.currentPalette.data
            );
            for (var i = 1; i <= iteration; i++) {
              var intMin = tab[(i - 1) * X];
              var intMax = tab[i * X - 1];
              if (i == iteration && (intMax < max || intMax == undefined)) {
                intMax = max;
              }
              scope.selectChart.styles.push({
                hexa: '#' + scope.current.gpalette[i - 1],
                color: hexToRgb(scope.current.gpalette[i - 1]),
                min: Math.round(intMin),
                max: Math.round(intMax),
                name: '[' + Math.round(intMin) + ',' + Math.round(intMax) + ']',
              });
            }
            gaDomUtils.hideGlobalLoader();
          });
        };

        ////// CAS VALEUR liées/////////
        /**
         * [countDiscret generation des styles dans le cas de link value en mode discret]
         * @return {[type]} [description]
         */
        scope.countDiscret = function() {
          gaDomUtils.showGlobalLoader();
          scope.selectChart.styles = [];
          var fti = scope.selectedcomponentlink;
          if (scope.selectChart.config.datasource == 'DB') {
            scope.selectChart.data = {};
          } else {
            scope.selectChart.data = SelectManager.getFeaturesByftiType(
              scope.selectedcomponentsupport.name
            );
          }
          ChartLocaliseFactory.dataStyle(scope.selectChart).then(function(
            rdata
          ) {
            var tab = [];
            var features = rdata.data.features;
            for (var i = 0; i < features.length; i++) {
              if (features[i].properties['value'] == null) {
                features[i].properties['value'] = '0';
              }
              tab.push(features[i].properties['value']);
            }

            tab.sort();
            tab = tab.join();
            tab = tab.split(',');
            var tab2 = [];
            for (var d = 0; d < tab.length; d++) {
              if (tab[d] != tab[d + 1]) {
                tab2.push(tab[d]);
              }
            }
            tab2.sort(compare);
            var sizel = tab2.length;
            scope.currentPalette.data.nb = sizel;
            scope.current.gpalette = StyleFactory.paletteGenerator(
              scope.currentPalette.data
            );
            for (var i = 0; i < sizel; i++) {
              scope.selectChart.styles.push({
                hexa: '#' + scope.current.gpalette[i],
                color: hexToRgb(scope.current.gpalette[i]),
                val: tab2[i],
              });
            }
            gaDomUtils.hideGlobalLoader();
          });
        };

        /**
         * [countInterv generation des styles dans le cas de link value en mode interval]
         * @param  {[type]} iteration [description]
         * @return {[type]}           [description]
         */
        scope.countInterv = function(iteration) {
          gaDomUtils.showGlobalLoader();
          scope.selectChart.styles = [];
          var fti = scope.selectedcomponentsupport;
          if (scope.selectChart.config.datasource == 'DB') {
            scope.selectChart.data = {};
          } else {
            scope.selectChart.data = SelectManager.getFeaturesByftiType(
              scope.selectedcomponentsupport.name
            );
          }
          ChartLocaliseFactory.dataStyle(scope.selectChart).then(function(
            rdata
          ) {
            var tab = [];
            var features = rdata.data.features;
            for (var i = 0; i < features.length; i++) {
              tab.push(features[i].properties['value']);
            }
            tab.sort();
            tab = tab.join();
            tab = tab.split(',');
            var tab2 = [];
            for (var d = 0; d < tab.length; d++) {
              if (tab[d] != tab[d + 1]) {
                tab2.push(parseInt(tab[d]));
              }
            }
            var min = 0;
            var max = 0;
            angular.forEach(tab2, function(value) {
              if (min > Number(value)) {
                min = Number(value);
              }

              if (max < Number(value)) {
                max = Number(value);
              }
            });

            var amplitude = Math.abs(max - min);
            var variant = amplitude / iteration;
            var current_value = angular.copy(min);
            scope.current.interv = [];
            scope.current.interv.push(current_value);
            scope.currentPalette.data.nb = iteration;
            scope.current.gpalette = StyleFactory.paletteGenerator(
              scope.currentPalette.data
            );
            var i = 0;
            while (current_value < max) {
              var maxv = current_value + variant;
              scope.selectChart.styles.push({
                hexa: '#' + scope.current.gpalette[i],
                color: hexToRgb(scope.current.gpalette[i]),
                max: Math.round((maxv * 100) / 100),
                min: Math.round((current_value * 100) / 100),
                name:
                  '[' +
                  Math.round(current_value) +
                  ',' +
                  Math.round(maxv) +
                  ']',
              });
              current_value = current_value + variant;
              i++;
            }
            gaDomUtils.hideGlobalLoader();
          });
        };

        //// fonctions de calcul valeurs directes et liées ////

        /**
         * [applyChloro appliquer les styles selon la legende aux différentes features cas de chloropleth]
         * @return {[type]} [description]
         */
        scope.applyChloro = function() {
          gaDomUtils.showGlobalLoader();
          //scope.selectChart.data ={};
          if (scope.selectChart.config.datasource == 'DB') {
            scope.selectChart.data = {};
          } else {
            scope.selectChart.data = SelectManager.getFeaturesByftiType(
              scope.selectedcomponentsupport.name
            );
          }
          if (scope.selectChart.styles.length > 0) {
            if (scope.selectChart.config.datasource == 'SELECTION') {
              if (scope.selectChart.data.features.length > 0) {
                scope.map.removeLayer(scope.vectorLayer);
                ChartLocaliseFactory.datastats(scope.selectChart).then(function(
                  rdata
                ) {
                  for (var i = 0; i < rdata.data.features.length; i++) {
                    if (rdata.data.features[i].properties.color == null) {
                      rdata.data.features[i].properties.color =
                        scope.selectChart.styles[0].hexa;
                    }
                  }
                  var vectorSource = new ol.source.Vector({
                    features: new ol.format.GeoJSON().readFeatures(rdata.data),
                  });
                  scope.vectorLayer = new ol.layer.Vector({
                    source: vectorSource,
                    style: scope.styleFunction,
                  });
                  scope.map.addLayer(scope.vectorLayer);
                  gaDomUtils.hideGlobalLoader();
                });
              } else {
                require('toastr').error('aucun objet selectionné');
                gaDomUtils.hideGlobalLoader();
              }
            } else {
              scope.map.removeLayer(scope.vectorLayer);
              ChartLocaliseFactory.datastats(scope.selectChart).then(function(
                rdata
              ) {
                for (var i = 0; i < rdata.data.features.length; i++) {
                  if (rdata.data.features[i].properties.color == null) {
                    rdata.data.features[i].properties.color =
                      scope.selectChart.styles[0].hexa;
                  }
                }
                var vectorSource = new ol.source.Vector({
                  features: new ol.format.GeoJSON().readFeatures(rdata.data),
                });
                scope.vectorLayer = new ol.layer.Vector({
                  source: vectorSource,
                  style: scope.styleFunction,
                });
                scope.map.addLayer(scope.vectorLayer);
                gaDomUtils.hideGlobalLoader();
              });
            }
          } else {
            //require('toastr').error($filter('translate')('itv.correspondance.nofeatureselected'));
            require('toastr').error('veuillez calculer la légende');
            gaDomUtils.hideGlobalLoader();
          }
        };

        /////// Fonctions Secteur ////
        /**
         * [countInterv generation des styles dans le cas de link value en mode interval]
         * @param  {[type]} iteration [description]
         * @return {[type]}           [description]
         */
        scope.pieChartStyleInterv = function(iteration) {
          gaDomUtils.showGlobalLoader();
          scope.selectChart.styles = [];
          var fti = scope.selectedcomponentlink;
          if (scope.selectChart.config.datasource == 'DB') {
            scope.selectChart.data = {};
          } else {
            scope.selectChart.data = SelectManager.getFeaturesByftiType(
              scope.selectedcomponentsupport.name
            );
          }
          ChartLocaliseFactory.dataStylePieChart(scope.selectChart).then(
            function(rdata) {
              var tab = [];
              var features = rdata.data.features;
              for (var i = 0; i < features.length; i++) {
                if (features[i].properties['values'] == null) {
                  features[i].properties['values'] = '0';
                }
                if (features[i].properties['values'] != null) {
                  var lastC = features[i].properties['values'].length - 1;
                  var value0 = features[i].properties['values'].slice(1, lastC);
                  var value = value0.replace(/\s+/g, '');
                  var tab0 = value.split(',');
                  for (var K = 0; K < tab0.length; K++) {
                    tab.push(tab0[K]);
                  }
                }
              }
              tab.sort();
              tab = tab.join();
              tab = tab.split(',');
              var tab2 = [];
              for (var d = 0; d < tab.length; d++) {
                if (tab[d] != tab[d + 1]) {
                  tab2.push(tab[d]);
                }
              }
              tab2.sort(compare);
              var min = 0;
              var max = 0;
              angular.forEach(tab2, function(value) {
                if (min > Number(value)) {
                  min = Number(value);
                }

                if (max < Number(value)) {
                  max = Number(value);
                }
              });
              var amplitude = Math.abs(max - min);
              var variant = amplitude / iteration;
              var current_value = angular.copy(min);
              scope.current.interv = [];
              scope.current.interv.push(current_value);
              scope.currentPalette.data.nb = iteration;
              scope.current.gpalette = StyleFactory.paletteGenerator(
                scope.currentPalette.data
              );
              var i = 0;
              while (current_value < max) {
                var maxv = current_value + variant;
                scope.selectChart.styles.push({
                  hexa: '#' + scope.current.gpalette[i],
                  color: hexToRgb(scope.current.gpalette[i]),
                  max: Math.round((maxv * 100) / 100),
                  min: Math.round((current_value * 100) / 100),
                  name:
                    '[' +
                    Math.round(current_value) +
                    ',' +
                    Math.round(maxv) +
                    ']',
                });
                current_value = current_value + variant;
                i++;
              }
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * [pieChartDiscret generation des styles dans le cas de link value en mode discret]
         * @return {[type]} [description]
         */
        scope.pieChartStyleDiscret = function() {
          gaDomUtils.showGlobalLoader();
          scope.selectChart.styles = [];
          if (scope.selectChart.config.datasource == 'DB') {
            scope.selectChart.data = {};
          } else {
            scope.selectChart.data = SelectManager.getFeaturesByftiType(
              scope.selectedcomponentsupport.name
            );
          }
          ChartLocaliseFactory.dataStylePieChart(scope.selectChart).then(
            function(rdata) {
              var tab = [];
              var features = rdata.data.features;
              for (var i = 0; i < features.length; i++) {
                if (
                  features[i].properties['values'] == null ||
                  features[i].properties['values'] == '[]'
                ) {
                  features[i].properties['values'] = '0';
                }
                if (features[i].properties['values'] != null) {
                  var lastC = features[i].properties['values'].length - 1;
                  var value0 = features[i].properties['values'].slice(1, lastC);
                  var value = value0.replace(/\s+/g, '');
                  var tab0 = value.split(',');
                  for (var K = 0; K < tab0.length; K++) {
                    tab.push(tab0[K]);
                  }
                }
                //tab.push(features[i].properties["values"]);
              }

              tab.sort();
              tab = tab.join();
              tab = tab.split(',');
              var tab2 = [];
              for (var d = 0; d < tab.length; d++) {
                if (tab[d] != tab[d + 1]) {
                  tab2.push(tab[d]);
                }
              }
              tab2.sort(compare);
              var sizel = tab2.length;
              scope.currentPalette.data.nb = sizel;
              scope.current.gpalette = StyleFactory.paletteGenerator(
                scope.currentPalette.data
              );
              for (var i = 0; i < sizel; i++) {
                scope.selectChart.styles.push({
                  hexa: '#' + scope.current.gpalette[i],
                  color: hexToRgb(scope.current.gpalette[i]),
                  val: tab2[i],
                });
              }
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * [applyCharts calcul cas secteur]
         * @return {[type]} [description]
         */
        scope.applyCharts = function() {
          gaDomUtils.showGlobalLoader();
          if (scope.selectChart.config.datasource == 'DB') {
            scope.selectChart.data = {};
          } else {
            scope.selectChart.data = SelectManager.getFeaturesByftiType(
              scope.selectedcomponentlink.name
            );
          }
          if (scope.selectChart.styles.length > 0) {
            if (scope.selectChart.config.datasource == 'SELECTION') {
              if (scope.selectChart.data.features.length > 0) {
                scope.map.removeLayer(scope.vectorLayer);
                ChartLocaliseFactory.datastats(scope.selectChart).then(function(
                  rdata
                ) {
                  var vectorSource = new ol.source.Vector({
                    features: new ol.format.GeoJSON().readFeatures(rdata.data),
                  });
                  scope.vectorLayer = new ol.layer.Vector({
                    source: vectorSource,
                    style: scope.styleFunction,
                  });

                  scope.map.addLayer(scope.vectorLayer);
                  gaDomUtils.hideGlobalLoader();
                });
              } else {
                require('toastr').error('aucun objet selectionné');
                gaDomUtils.hideGlobalLoader();
              }
            } else {
              scope.map.removeLayer(scope.vectorLayer);
              ChartLocaliseFactory.datastats(scope.selectChart).then(function(
                rdata
              ) {
                var vectorSource = new ol.source.Vector({
                  features: new ol.format.GeoJSON().readFeatures(rdata.data),
                });
                scope.vectorLayer = new ol.layer.Vector({
                  source: vectorSource,
                  style: scope.styleFunction,
                });

                scope.map.addLayer(scope.vectorLayer);
                gaDomUtils.hideGlobalLoader();
              });
            }
          } else {
            //require('toastr').error($filter('translate')('itv.correspondance.nofeatureselected'));
            require('toastr').error('Veuillez calculer la légende');

            gaDomUtils.hideGlobalLoader();
          }
        };
        ////////////////////////////////////////////////
        /**
         * [selectcomponetchange description]
         * @return {[type]} [description]
         */
        scope.selectcomponetchange = function() {
          scope.attributs = [];
          scope.selectedcomponent.attributes.forEach(function(att) {
            scope.attributs.push({
              value: att.name,
              label: att.alias,
              att: att,
            });
          });
          scope.selectChart.config.ftidata = scope.selectedcomponent.uid;
        };
        /**
         * [selectcomponentchangelink description]
         * @return {[type]} [description]
         */
        scope.selectcomponentchangelink = function() {
          scope.cancelCharts();
          scope.attributslink = [];
          scope.selectedcomponentlink.attributes.forEach(function(att) {
            scope.attributslink.push({
              value: att.name,
              label: att.alias,
              att: att,
            });
          });
          scope.selectChart.config.ftidatalink =
            scope.selectedcomponentlink.uid;
        };

        /**
         * [selectcomponetchangesupport description]
         * @return {[type]} [description]
         */
        scope.selectcomponetchangesupport = function() {
          scope.cancelCharts();
          scope.attributssupport = [];
          scope.selectedcomponentsupport.attributes.forEach(function(att) {
            scope.attributssupport.push({
              value: att.name,
              label: att.alias,
              att: att,
            });
          });
          scope.selectChart.config.ftisupport =
            scope.selectedcomponentsupport.uid;
        };
        /**
         * [selectattributchange description]
         * @return {[type]} [description]
         */
        scope.selectattributchange = function() {
          scope.cancelCharts();
          scope.selectChart.config.dataCriteria = scope.selectedattribut;
        };
        /**
         * [selectrelationchange description]
         * @return {[type]} [description]
         */
        scope.selectrelationchange = function() {
          scope.cancelCharts();
          scope.componentlink = [];
          if (scope.selectedrelation == 'INTERSECT') {
            scope.component.forEach(function(cmp) {
              if (cmp.type != 'NG') {
                scope.componentlink.push(cmp);
              }
            });
          } else if (scope.selectedcomponentsupport) {
            for (
              var i = 0;
              i < scope.selectedcomponentsupport.relations.length;
              i++
            ) {
              if (
                scope.selectedcomponentsupport.relations[i].name ==
                scope.selectedrelation
              ) {
                var id = scope.selectedcomponentsupport.relations[i].idEnd;
                for (var j = 0; j < scope.component.length; j++) {
                  if (scope.component[j].uid == id) {
                    scope.componentlink.push(scope.component[j]);
                  }
                }
              }
            }
          }
        };
        /**
         * [selectattributchangelink description]
         * @return {[type]} [description]
         */
        scope.selectattributchangelink = function() {
          if (
            scope.selectChart.config.charttypevalue == 'LINKVALUE' &&
            scope.selectedattributlink.att.type == 'java.lang.String'
          ) {
            require('toastr').error(
              'Veuillez sélectionner un attribut numérique '
            );
          }
          scope.cancelCharts();
          scope.selectChart.config.dataCriteria = scope.selectedattributlink;
        };
        /**
         * [selectrepresentation description]
         * @return {[type]} [description]
         */
        scope.selectrepresentation = function() {
          scope.cancelCharts();
          scope.selectChart.config.representation =
            scope.selectedRepresentation;
        };
        /**
         * [selectOperation description]
         * @return {[type]} [description]
         */
        scope.selectOperation = function() {
          //scope.cancelCharts();
          scope.selectChart.config.operation = scope.selectedOperation;
        };

        /**
         * [openPalettesLibrary description]
         * @return {[type]} [description]
         */
        scope.openPalettesLibrary = function() {
          ngDialog.open({
            template:
              'js/XG/widgets/mapapp/style/views/modals/modal.palettelibrary.html',
            className: 'ngdialog-theme-plain miniclose width600 nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };
        var hexToRgb = function(hex) {
          var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
          return result
            ? {
                r: parseInt(result[1], 16),
                g: parseInt(result[2], 16),
                b: parseInt(result[3], 16),
                a: 0.8,
              }
            : null;
        };
        /**
         * [styleFunction fonction pour le definir le styles]
         * @param  {[type]} feature    [description]
         * @param  {[type]} resolution [description]
         * @return {[type]}            [description]
         */
        scope.styleFunction = function(feature, resolution) {
          var iconette = feature.get('icon');
          var mycolor = feature.get('color');
          var scale = 0.2;
          if (resolution <= 30) {
            scale = 1;
          }
          if (60 >= resolution > 30) {
            scale = 0.5;
          }
          var style = [];
          if (iconette == undefined) {
            style = [
              new ol.style.Style({
                fill: new ol.style.Fill({
                  color: mycolor,
                }),
              }),
            ];
          } else {
            style = [
              new ol.style.Style({
                fill: new ol.style.Fill({
                  color: mycolor,
                  //'rgba('+scope.interv[i].r+','+scope.interv[i].g+','+scope.interv[i].b+','+scope.interv[i].a+')'
                }),

                image: new ol.style.Icon({
                  scale: scale,
                  src: iconette,
                }),
              }),
            ];
          }

          return style;
          /*[new ol.style.Style({
                  fill: new ol.style.Fill({
                  color:mycolor
                  //'rgba('+scope.interv[i].r+','+scope.interv[i].g+','+scope.interv[i].b+','+scope.interv[i].a+')'
                }),

                image:new ol.style.Icon({
                  scale: scale ,
                  src: iconette
                })})]*/
        };
        /**
         * [cancelCharts description]
         * @return {[type]} [description]
         */
        scope.cancelCharts = function() {
          scope.selectChart.styles = [];
          scope.map.removeLayer(scope.vectorLayer);
        };
      },
    };
  };

  statistiqueWidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    'FilesFactory',
    'FeatureTypeFactory',
    'ChartLocaliseFactory',
    'SelectManager',
    'QueryFactory',
    'StyleFactory',
    'ngDialog',
    'gaDomUtils',
    'PortalsFactory',
  ];
  return statistiqueWidget;
});
