'use strict';
define(function() {
  var paletteviewer = function(StyleFactory) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/style/views/paletteviewer.html',
      restrict: 'E',
      replace: true,
      scope: {
        palette: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.$watch(
          'palette',
          function() {
            if (!angular.isDefined(scope.palette)) return;
            var displayPalette = angular.copy(scope.palette);

            // max 100
            if (displayPalette.nb > 100) displayPalette.nb = 100;

            // get colors
            scope.tiles = StyleFactory.paletteGenerator(displayPalette);
          },
          1
        );

        /**
         * getPaletteStyle
         */
        scope.getPaletteStyle = function(tile, nb) {
          return {
            'background-color': '#' + tile,
            width: 100 / nb + '%',
          };
        };
      },
    };
  };

  paletteviewer.$inject = ['StyleFactory'];
  return paletteviewer;
});
