'use strict';
define(function() {
  var sldsimplelinesymbolizer = function($filter, x2js, sldUtils, $rootScope) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/style/views/symbolizer/sldsimplelinesymbolizer.html',
      restrict: 'A',
      scope: {
        component: '=component',
        fti: '=fti',
        rules: '=rules',
        ruletypepossibilities: '=ruletypepossibilities',
        selectsymbol: '=selectsymbol',
        selectedcomponent: '= selectedcomponent',
        _uom:'=',
        isannotation: '=?'
      },
      link: function(scope) {

        scope.lineType = sldUtils.getSubTypeOfSymbolizer(
          'LINE',
          scope.component
        );

        scope.selectedComponent = { index: 0 };
        scope.component._uom='';

        scope.selectHashTemplate = function(hashtemplate) {
          scope.component.hashtemplate = hashtemplate.title;
          scope.selectedHashBgrd = hashtemplate.image;
        };

        scope.setFillType = function() {
          switch (scope.fillType) {
            case 'continuous':
              var xml = '<CssParameter name="fill">#000000</CssParameter>';
              break;

            case 'grid':
              xml =
                '<GraphicFill>' +
                '<Graphic>' +
                '<Mark>' +
                '<WellKnownName>shape://times</WellKnownName>' +
                '<Stroke>' +
                '<CssParameter name="stroke">#000000</CssParameter>' +
                '<CssParameter name="stroke-width">1</CssParameter>' +
                '</Stroke>' +
                '</Mark>' +
                '</Graphic>' +
                '</GraphicFill>';

              break;
          }

          scope.component.Fill = x2js.xml_str2json(xml);
        };

        // define stroke type
        scope.stroke = {
          type: 'none',
          types: [
            {
              key: 'continuous',
              label:
                'model.styles.editor.symbolizers.common.stroke.types.continuous',
            },
            {
              key: 'dash',
              label: 'model.styles.editor.symbolizers.common.stroke.types.dash',
            },
            {
              key: 'dots',
              label: 'model.styles.editor.symbolizers.common.stroke.types.dots',
            },
          ],
        };

        if (scope.selectedcomponent) {
          /**
           * When the user select another rule
           */
          scope.$watch(
            function() {
              
              var index0 = scope.selectedcomponent.index;
              var lastIndex = parseInt(index0.charAt(index0.length - 1));
              var firstIndex = parseInt(index0.charAt(0));
              scope.selectedComponent.index = lastIndex;
              return scope.rules[firstIndex][scope.selectsymbol.type][
                scope.selectedComponent.index
              ];
            },
            function(symbol) {
              if (symbol) {
                //scope.component.symbolType = sldUtils.getSubTypeOfSymbolizer(scope.selectRule.symbolizerName, symbol);
                //console.log(scope.selectRule);
                scope.component.symbolType = sldUtils.getSubTypeOfSymbolizer(
                  scope.selectsymbol.type,
                  symbol
                );
              }
            }
          );
        }

        /**
         * switchRuleSymbolType
         */
        scope.switchRuleSymbolType = function() {
          console.log(scope.component);
          var index0 = scope.selectedcomponent.index;
          var lastIndex = parseInt(index0.charAt(index0.length - 1));
          var firstIndex = parseInt(index0.charAt(0));
          scope.selectedComponent.index = lastIndex;
          sldUtils
            .switchRuleSymbolType(scope.component.symbolType)
            .then(function(newRule) {
              scope.rules[firstIndex][scope.selectsymbol.type][
                scope.selectedComponent.index
              ] = newRule[scope.selectsymbol.type][0];
              scope.lineType = scope.component.symbolType;
              var data = {
                index: lastIndex,
                rule: 0,
                type: 'LineSymbolizer',
              };

              var component = scope.component;
              $rootScope.$broadcast('refresh_selected_component', {
                coord: data,
                cmp: component,
              });
            });
        };

        // used to retrieve the stroke type when user toggles between different point symboilizers
        scope.$watch(
          'component',
          function(component) {
            if (angular.isDefined(component.Stroke)) {
              var dashArray = $filter('cssParam')(
                scope.component.Stroke,
                'stroke-dasharray'
              )['__text'];
              if (dashArray && dashArray != '') {
                scope.stroke.type = 'dash';
                if (dashArray == '1 2') scope.strokeType = 'dots';
              } else {
                scope.stroke.type = 'continuous';
              }
            } else {
              scope.stroke.type = 'none';
            }
            console.log(component)
            scope.component.componentShowHide = component.hasOwnProperty('image')?false:true;
          },
          1
        );

        scope.changeStrokeType = function() {
          if (!angular.isDefined(scope.component.Stroke)) {
            scope.component.Stroke = {
              CssParameter: [
                {
                  _name: 'stroke',
                  __text: '#000000',
                },
              ],
            };
          }
          if (scope.stroke.type == 'dash') {
            $filter('cssParam')(scope.component.Stroke, 'stroke-dasharray')[
              '__text'
            ] = '5 7';
          } else if (scope.stroke.type == 'dots') {
            $filter('cssParam')(scope.component.Stroke, 'stroke-dasharray')[
              '__text'
            ] = '0.25 4';
          } else if (scope.stroke.type == 'continuous') {
            $filter('cssParam')(scope.component.Stroke, 'stroke-dasharray')[
              '__text'
            ] = '';
          }
        };

        scope.lineJoinOptions = [
          {
            key: 'round',
            label: 'model.styles.editor.symbolizers.line.linejoin.round',
          },
          {
            key: 'bevel',
            label: 'model.styles.editor.symbolizers.line.linejoin.bevel',
          },
          {
            key: 'miter',
            label: 'model.styles.editor.symbolizers.line.linejoin.miter',
          },
        ];

        // ------------
        // LINE POLYGONS
        // ------------
        scope.lineShapes = [
          {
            key: 'shape://vertline',
            symbol: '| ',
            label: 'model.styles.editor.symbolizers.polygon.line.vertical',
          },
          {
            key: 'shape://horline',
            symbol: '_ ',
            label: 'model.styles.editor.symbolizers.polygon.line.horizontal',
          },
          {
            key: 'shape://slash',
            symbol: '/ ',
            label: 'model.styles.editor.symbolizers.polygon.line.slash',
          },
          {
            key: 'shape://backslash',
            symbol: '\\ ',
            label: 'model.styles.editor.symbolizers.polygon.line.backslash',
          },
          /*{ key : 'shape://dot', label : '. Dot' },*/
          {
            key: 'shape://plus',
            symbol: '+ ',
            label: 'model.styles.editor.symbolizers.polygon.line.plus',
          },
          {
            key: 'shape://times',
            symbol: 'x ',
            label: 'model.styles.editor.symbolizers.polygon.line.times',
          },

          /*{ key : 'shape://oarrow', label : '> Open Arrow' },
                    { key : 'shape://carrow', label : '▷ Closed Arrow' },*/
        ];

        // ------------
        // POLYGON LINES
        // ------------
      },
    };
  };

  sldsimplelinesymbolizer.$inject = [
    '$filter',
    'x2js',
    'sldUtils',
    '$rootScope',
  ];
  return sldsimplelinesymbolizer;
});
