'use strict';
define(function() {
  var sldtextsymbolizer = function(StyleFactory, gaJsUtils, $timeout) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/style/views/symbolizer/sldtextsymbolizer.html',
      restrict: 'EA',
      scope: {
        rule: '=rule',
        fti: '=fti',
        attributeName: '=attributeName',
      },
      link: function(scope, elt, attrs, ctrl) {
        console.log(scope.rule);
        scope.textSymbolizer = scope.rule.TextSymbolizer;
        console.log(scope.textSymbolizer);

        scope.$watch('textSymbolizer', function(ts) {
          // in only a property (label) it's a new blank object created by the gui
          // we add needed properties
          if (ts) {
            if (!ts.hasOwnProperty('Font')) {
              ts.Font = { CssParameter: [] };
              ts.Fill = { CssParameter: [] };
            }
            if (
              scope.fti &&
              scope.fti.typeInfo == 'POLYGON' &&
              !ts.hasOwnProperty('VendorOption')
            ) {
              ts.VendorOption = [
                {__text: 5, _name: 'autoWrap'},
                {__text: 'mbr', _name: 'polygonAlign'},
                {__text: 'false', _name: 'conflictResolution'},
                {__text: 'true', _name: 'partials'}
              ];
            }
            // Affectation pour l'affichage de l'option dans l'interface graphique / Initialisation si nécéssaire
            // Option de duplication des étiquettes
            if (Array.isArray(scope.textSymbolizer.VendorOption)) {
              if (scope.textSymbolizer.VendorOption.find(option => option._name === 'partials')) {
                scope.noLabelDuplicate = angular.copy(scope.textSymbolizer.VendorOption.find(option => option._name === 'partials'));
              } else {
                scope.noLabelDuplicate = {__text: 'false', _name: 'partials'};
                scope.textSymbolizer.VendorOption.push(angular.copy(scope.noLabelDuplicate));
              }
            }
            if (scope.noLabelDuplicate) {
              scope.noLabelDuplicate.value = scope.noLabelDuplicate.__text === 'true';
            }

            // Option d'optimisation du rendu des étiquettes
            scope.optimizeLabelRender = {};
            scope.optimizeLabelRender.value = Array.isArray(scope.textSymbolizer.VendorOption) && scope.textSymbolizer.VendorOption.some(option => option._name === 'maxDisplacement');
          }
        });

        scope.$watch('rule', function(r) {
          if (angular.isDefined(scope.rule)) {
            scope.textSymbolizer = scope.rule.TextSymbolizer;
            if (
              angular.isDefined(scope.labeltabs) &&
              angular.isDefined(scope.labeltabs.activeTab)
            ) {
              var holdActiveTab = scope.labeltabs.activeTab;
              scope.labeltabs.activeTab = -1;
              $timeout(function() {
                scope.labeltabs.activeTab = holdActiveTab;
              });
            }
          }
        });

        scope.labeltabs = [
          {
            title: 'model.styles.editor.symbolizers.text.text.title',
          },
          {
            title: 'model.styles.editor.symbolizers.text.fill.title',
          },
          {
            title: 'model.styles.editor.symbolizers.text.halo.title',
          },
          {
            title: 'model.styles.editor.symbolizers.text.placement.title',
          },
          {
            title: 'model.styles.editor.symbolizers.text.scale.title',
          },
          /* { title: "Placement"},*/
          /*                    { title: "Background"},
                     { title: "Position"},
                     { title: "Render"},
                     { title: "Shadow"}*/
        ];

        scope.labeltabs.activeTab = 0;
        // force first tab active if none
        scope.$watch('labeltabs.activeTab', function(t) {
          if (t == -1) {
            scope.labeltabs.activeTab = 0;
          }
        });

        var saveTextHalo = {
          Radius: 1,
          Fill: {
            CssParameter: [
              { __text: '#000000', _name: 'fill' },
              { __text: '1', _name: 'fill-opacity' },
            ],
          },
        };
        scope.toggleHalo = function() {
          if (angular.isDefined(scope.textSymbolizer.Halo)) {
            saveTextHalo = scope.textSymbolizer.Halo;
            delete scope.textSymbolizer.Halo;
          } else {
            scope.textSymbolizer.Halo = saveTextHalo;
          }
        };

        scope.textSymbolizerScale = function() {
          if (scope.rule.hasOwnProperty('MinScaleDenominator')) {
            delete scope.rule.MinScaleDenominator;
            delete scope.rule.MaxScaleDenominator;
          } else {
            scope.rule.MinScaleDenominator = 50000;
            scope.rule.MaxScaleDenominator = 250000;
          }
        };

        /*scope.toggleLinePlacement = function(){
                    if(scope.textSymbolizer.LabelPlacement){
                        delete scope.textSymbolizer.LabelPlacement;
                    }else{
                        scope.textSymbolizer.LabelPlacement = { LinePlacement : {} };
                    }
                };*/

        var checkPlacement = function(type) {
          type = 'LabelPlacement.' + type;
          return (
            gaJsUtils.checkNestedProperty(type, scope.textSymbolizer) !== false
          );
        };
        /* --------------------
                 LinePlacement / PointPlacement
                 -------------------- */

        var defaultPlacementType = '';
        if (checkPlacement('LinePlacement')) {
          defaultPlacementType = 'line';
        } else if (checkPlacement('PointPlacement') || scope.fti.typeInfo.includes('POINT')) {
          defaultPlacementType = 'point';
        }
        scope.placement = { type: defaultPlacementType };

        /**
         * Handle the changement of placement type (none/point/line)
         */
        scope.$watch(
          'placement.type',
          function(type) {
            if (!angular.isDefined(scope.textSymbolizer)) return;

            if (type !== '') {
              // set LabelPlacement if it doesnt exist
              if (!scope.textSymbolizer.LabelPlacement) {
                scope.textSymbolizer.LabelPlacement = {};
              }
              // reset
            } else {
              if (scope.textSymbolizer.LabelPlacement)
                delete scope.textSymbolizer.LabelPlacement;
            }

            if (type == 'line') {
              if (!checkPlacement('LinePlacement')) {
                scope.textSymbolizer.LabelPlacement.LinePlacement = {
                  PerpendicularOffset: 0,
                };
              }
              if (checkPlacement('PointPlacement')) {
                delete scope.textSymbolizer.LabelPlacement.PointPlacement;
              }
            }
            if (type == 'point') {
              if (!checkPlacement('PointPlacement')) {
                scope.textSymbolizer.LabelPlacement.PointPlacement = {};
              }
              if (checkPlacement('LinePlacement')) {
                delete scope.textSymbolizer.LabelPlacement.LinePlacement;
              }
            }
          },
          1
        );

        /* --------------------
                 LinePlacement : PERPENDICULAROFFSET
                 -------------------- */
        scope.perpendicularOffset = { min: 0, max: 250 };
        if (checkPlacement('LinePlacement.PerpendicularOffset')) {
          scope.perpendicularOffset.min =
            scope.textSymbolizer.LabelPlacement.LinePlacement.PerpendicularOffset;
          scope.perpendicularOffset.margin = scope.perpendicularOffset.min / -2;
        }
        scope.$watch('perpendicularOffset.min', function(min) {
          if (checkPlacement('LinePlacement.PerpendicularOffset')) {
            scope.textSymbolizer.LabelPlacement.LinePlacement.PerpendicularOffset =
              min * -1;
            scope.perpendicularOffset.margin = min / 2;
          }
        });

        /* --------------------
                PointPlacement : ROTATION
                -------------------- */
        /**
         * Activate/Deactivate Rotation
         */
        scope.toggleRotation = function() {
          if (checkPlacement('PointPlacement.Rotation')) {
            delete scope.textSymbolizer.LabelPlacement.PointPlacement.Rotation;
          } else {
            if (scope.textSymbolizer.LabelPlacement.PointPlacement == '')
              scope.textSymbolizer.LabelPlacement.PointPlacement = {};
            scope.textSymbolizer.LabelPlacement.PointPlacement.Rotation = 0;
          }
        };

        /* --------------------
                 PointPlacement : ANCHOR
                 -------------------- */
        scope.getGridSize = function(num) {
          return new Array(num);
        };
        /**
         * Activate/Deactivate Anchor
         */
        scope.toggleAnchor = function() {
          if (checkPlacement('PointPlacement.AnchorPoint')) {
            delete scope.textSymbolizer.LabelPlacement.PointPlacement
              .AnchorPoint;
          } else {
            if (scope.textSymbolizer.LabelPlacement.PointPlacement == '')
              scope.textSymbolizer.LabelPlacement.PointPlacement = {};
            scope.textSymbolizer.LabelPlacement.PointPlacement.AnchorPoint = {
              AnchorPointX: '0.5',
              AnchorPointY: '0.5',
            };
          }
        };
        scope.getAnchorCoordinates = function(x, y) {
          y = (10 - y) / 10;
          x = x / 10;
          return { x: '' + x, y: '' + y };
        };
        scope.isSelectedAnchorPoint = function(coord) {
          return (
            scope.textSymbolizer.LabelPlacement.PointPlacement.AnchorPoint
              .AnchorPointX == coord.x &&
            scope.textSymbolizer.LabelPlacement.PointPlacement.AnchorPoint
              .AnchorPointY == coord.y
          );
        };
        scope.setAnchorPoint = function(coord) {
          scope.textSymbolizer.LabelPlacement.PointPlacement.AnchorPoint.AnchorPointX =
            coord.x;
          scope.textSymbolizer.LabelPlacement.PointPlacement.AnchorPoint.AnchorPointY =
            coord.y;
        };

        /* --------------------
                 PointPlacement : DISPLACEMENT
                 -------------------- */
        /**
         * Activate/Deactivate Displacement
         */
        scope.toggleDisplacement = function() {
          if (checkPlacement('PointPlacement.Displacement')) {
            delete scope.textSymbolizer.LabelPlacement.PointPlacement
              .Displacement;
          } else {
            if (scope.textSymbolizer.LabelPlacement.PointPlacement == '')
              scope.textSymbolizer.LabelPlacement.PointPlacement = {};
            scope.textSymbolizer.LabelPlacement.PointPlacement.Displacement = {
              DisplacementX: '0',
              DisplacementY: '0',
            };
          }
        };

        scope.displacement = {
          degree: 0,
          r: 10,
          x: 0,
          y: 0,
        };
        scope.$watch(
          'displacement',
          function(dis, prevdis) {
            // if(dis.r==0){
            //     scope.displacement.x = 0;
            //     scope.displacement.y = 0;
            //     return;
            // }
            // if(dis.degree!=prevdis.degree || dis.r!=prevdis.r){
            //     scope.displacement.x = Math.round(scope.displacement.r * Math.cos(scope.displacement.degree* Math.PI / 180));
            //     scope.displacement.y = Math.round(scope.displacement.r * Math.sin(scope.displacement.degree* Math.PI / 180));
            // }else{
            //     var r = Math.round(Math.sqrt(Math.pow(scope.displacement.x,2)+Math.pow(scope.displacement.y,2)));
            //     scope.displacement.r = r;
            //     var d  =  Math.round((Math.acos(scope.displacement.x/scope.displacement.r)*180)/Math.PI);
            //     scope.displacement.d = d;
            // }
            // scope.textSymbolizer.LabelPlacement.PointPlacement.Displacement.DisplacementX = scope.displacement.x
            // scope.textSymbolizer.LabelPlacement.PointPlacement.Displacement.DisplacementY = scope.displacement.y
          },
          1
        );

        // available fonts and most common fonts
        scope.commonFonts = [
          'Helvetica',
          'Arial',
          'Times',
          'Times New Roman',
          'Courier',
          'Courier New',
          'Verdana',
          'Tahoma',
        ];
        StyleFactory.getfont().then(function(r) {
          if (gaJsUtils.checkNestedProperty('data.fonts', r) !== false) {
            scope.availableFonts = r.data.fonts.sort();
          }
        });

        // styles
        scope.fontStyles = [
          {
            key: 'normal',
            label: 'model.styles.editor.symbolizers.text.text.style.normal',
          },
          {
            key: 'italic',
            label: 'model.styles.editor.symbolizers.text.text.style.italic',
          },
          {
            key: 'oblique',
            label: 'model.styles.editor.symbolizers.text.text.style.oblique',
          },
        ];

        // weight
        scope.fontWeights = [
          {
            key: 'normal',
            label: 'model.styles.editor.symbolizers.text.text.weight.normal',
          },
          {
            key: 'bold',
            label: 'model.styles.editor.symbolizers.text.text.weight.bold',
          },
        ];

        // opacity
        scope.text_symbolizer_opacity = {};
        scope.$watch(
          'text_symbolizer_opacity',
          function(opacity) {
            if (!angular.isDefined(opacity.value)) return;
            if (
              gaJsUtils.checkNestedProperty(
                'Fill.CssParameter',
                scope.textSymbolizer
              ) !== false
            ) {
              scope.textSymbolizer.Fill.CssParameter.forEach(function(
                cssparam
              ) {
                if (cssparam._name == 'fill-opacity') {
                  cssparam.__text = opacity.value / 100;
                }
              });
            }
          },
          1
        );

        // halo opacity
        scope.text_symbolizer_radio_opacity = {};
        scope.$watch(
          'text_symbolizer_radio_opacity',
          function(opacity) {
            if (!angular.isDefined(opacity.value)) return;
            if (
              gaJsUtils.checkNestedProperty(
                'Halo.Fill.CssParameter',
                scope.textSymbolizer
              ) !== false
            ) {
              scope.textSymbolizer.Halo.Fill.CssParameter.forEach(function(
                cssparam
              ) {
                if (cssparam._name == 'fill-opacity') {
                  cssparam.__text = opacity.value / 100;
                }
              });
            }
            /*scope.textSymbolizer.Fill.forEach(function(x){
                     console.log(x);
                     })*/
          },
          1
        );
        /*if(scope.fti.typeInfo=='LINE'){
                 scope.labeltabs.push({ title : 'Placement '});
                 }*/

        // autoWrap
        scope.polygon_auto_wrap = {};
        scope.$watch(
          'polygon_auto_wrap',
          function(autoWrap) {
            if (!angular.isDefined(autoWrap.value)) return;
            if (
              gaJsUtils.checkNestedProperty(
                'VendorOption',
                scope.textSymbolizer
              ) !== false
            ) {
              scope.textSymbolizer.VendorOption.forEach(function(vendorOpt) {
                if (vendorOpt._name == 'autoWrap') {
                  vendorOpt.__text = autoWrap.value;
                }
              });
            }
          },
          1
        );

        // conflictResolution
        scope.polygon_conflict_resolution = {};
        scope.$watch(
          'polygon_conflict_resolution',
          function(confRes) {
            if (!angular.isDefined(confRes.value)) return;
            if (
              gaJsUtils.checkNestedProperty(
                'VendorOption',
                scope.textSymbolizer
              ) !== false
            ) {
              scope.textSymbolizer.VendorOption.forEach(function(vendorOpt) {
                if (vendorOpt._name == 'conflictResolution') {
                  vendorOpt.__text = confRes.value;
                }
              });
            }
          },
          1
        );

        // Option de non duplication des étiquettes
        /**
         * Fonction appelée lors du changement de la checkbox de l'option noLabelDuplicate
         */
        scope.noLabelDuplicateChange = () => {
          if (gaJsUtils.checkNestedProperty('VendorOption', scope.textSymbolizer) !== false) {
            for (const vendorOption of scope.textSymbolizer.VendorOption) {
              if (vendorOption._name === 'partials') {
                vendorOption.__text = scope.noLabelDuplicate.value;
              }
            }
          }
        };


        // Option d'optimisation du rendu des étiquettes
        /**
         * Fonction appelée lors du changement de la checkbox de l'option de rendu des étiquettes
         */
        scope.optimizeLabelRenderChange = () => {
          if (gaJsUtils.checkNestedProperty('VendorOption', scope.textSymbolizer) !== false) {
            if (scope.optimizeLabelRender.value) {
              scope.textSymbolizer.VendorOption.push({ __text: '100', _name: 'maxDisplacement' });
              scope.textSymbolizer.VendorOption.push({ __text: '10', _name: 'spaceAround' });
            } else {
              scope.textSymbolizer.VendorOption = scope.textSymbolizer.VendorOption.filter(
                  option => option._name !== 'maxDisplacement' && option._name !== 'spaceAround');
            }
          }
        };


        scope.togglePolygonAlignement = function() {
          if (
            gaJsUtils.checkNestedProperty(
              'VendorOption',
              scope.textSymbolizer
            ) !== false
          ) {
            var hitIndex = -1;
            scope.textSymbolizer.VendorOption.forEach(function(
              vendorOpt,
              index
            ) {
              if (hitIndex == -1 && vendorOpt._name == 'polygonAlign')
                hitIndex = index;
            });

            if (hitIndex == -1)
              scope.textSymbolizer.VendorOption.push({
                __text: 'mbr',
                _name: 'polygonAlign',
              });
            else scope.textSymbolizer.VendorOption.splice(hitIndex, 1);

            console.log(scope.textSymbolizer.VendorOption);
          }
        };
      },
    };
  };

  sldtextsymbolizer.$inject = ['StyleFactory', 'gaJsUtils', '$timeout'];
  return sldtextsymbolizer;
});
