'use strict';
define(function() {
  var sitesListctrl = function(
    $scope,
    QueryFactory,
    SirocoFactory,
    FeatureTypeFactory,
    ngTableParams,
    ngDialog,
    $location
  ) {
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));
    var setTable = function(chantierFtId) {
      $scope.tableParams = new ngTableParams(
        { page: 1, count: 10 },
        {
          total: 0,
          getData: function($defer, params) {
            QueryFactory.data(
              chantierFtId,
              '',
              '',
              params.page(),
              params.count()
            ).then(function(data) {
              params.total(data.data.totalFeatures);
              $defer.resolve(data.data.features);
            });
          },
        }
      );
    };

    /**
     * showChantier
     * @param x
     * @param chantier
     */
    $scope.showChantier = function(action, chantier, y) {
      if (action == 'show') {
        $scope.currentChantier = chantier;
        $scope.chantierModal = ngDialog.open({
          template:
            'js/XG/widgets/sirocoapp/export/views/modals/modal.chantier.html',
          className: 'ngdialog-theme-plain nopadding width600 miniclose',
          closeByDocument: false,
          scope: $scope,
        });
      } else if (action == 'print') {
        SirocoFactory.getRapportChantier(chantier, false);
      }
    };

    $scope.chantieractions = [
      {
        label: 'btn',
        btnclass: 'default',
        cfg: {
          iconOrLabel: 'label',
          label: 'Fiche chantier',
          size: 'btn-xs',
          style: 'btn-default',
        },
        config: { click: ['show'] },
      },
      {
        label: 'btn',
        btnclass: 'default',
        cfg: {
          iconOrLabel: 'label',
          label: 'Imprimer fiche',
          size: 'btn-xs',
          style: 'btn-default',
        },
        config: { click: ['print'] },
      },
    ];

    /**
     * go to Sites page
     */
    $scope.goToSites = function() {
      $scope.chantierModal.close();
      $location.path('/siroco/sites');
    };

    FeatureTypeFactory.get().then(function() {
      var chantierFtId = FeatureTypeFactory.getFeatureUidByName(
        sirocoCfg.layersNames.chantier
      );
      $scope.chantierFT = FeatureTypeFactory.getFeatureByUid(chantierFtId);
      setTable(chantierFtId);
    });
  };
  sitesListctrl.$inject = [
    '$scope',
    'QueryFactory',
    'SirocoFactory',
    'FeatureTypeFactory',
    'ngTableParams',
    'ngDialog',
    '$location',
  ];
  return sitesListctrl;
});
