'use strict';
define(function() {
  var formBuilderFtiUniqueAttributeArray = function(FeatureTypeFactory) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/form/views/formBuilderFtiUniqueAttributeArray.html',
      restrict: 'EA',
      scope: {
        res: '=?',      // res contient le resultat de la dernière sélection sous le format "uid;attribut"
        ftidst: '=?ftidst',    // "'" + "uid;attribute" + "'"
        functionindex: '=?'
      },
      link: function(scope) {
        scope.init = () => {
          scope.ftid = undefined;
          scope.myfti = undefined;
          scope.myAttribute = undefined;
          scope.res = undefined;
          scope.resString = undefined;
          scope.ftidst = undefined;

          // Si initialisation avec une valeur existante dans ftidst
          if (scope.ftidst && scope.ftidst !== 'fids' && scope.ftidst !== 'Composants') {
            const ftidstClean = scope.ftidst.replace(/^'+|'+$/g, ''); // Enlève les quotes
            const [uid, attribute] = ftidstClean.split(';');

            const fti = FeatureTypeFactory.getFeatureByUid(uid);
            if (fti) {
              scope.myfti = fti;
              scope.myAttribute = fti.attributes.find(attr => attr.name === attribute);
            }
          }
        };

        scope.init();

        scope.$watch('functionindex', (newVal, oldVal) => {
          if (newVal !== oldVal) {
            scope.init();
          }
        });

        // Appelé depuis le ng-change
        scope.addLine = () => {
          if (scope.myfti && scope.myAttribute) {
            const uid = scope.myfti.uid;
            const attr = scope.myAttribute.name;
            scope.res = [`${uid};${attr}`];
            scope.resString = scope.res[0];
            scope.ftidst = `'${scope.resString}'`;
          } else {
            scope.res = undefined;
            scope.resString = undefined;
            scope.ftidst = undefined;
          }
        };
      },
    };
  };

  formBuilderFtiUniqueAttributeArray.$inject = ['FeatureTypeFactory'];
  return formBuilderFtiUniqueAttributeArray;
});