'use strict';
define(function() {

  /**
   * Composant select avec autocomplete
   * Ré-utilise le sale composant bootstrap ui-select
   */
  var gccomponent = function(
    $timeout
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gcautocomplete.html',
      restrict: 'E',
      replace: true,
      scope: {
        ngModel: '=', // normal ng-model behavior
        list: '=', // should be one of thoose: array of object, array of string, array of int, array of bool.
        // data-placeholder:
        //  placeholder of the input
        //  NOTE: one-way-binding
        placeholder: '<',
        // attribute-displayed:
        //  name of the attribute displayed in the dropdown (ie: alias of the component, name of user).
        //  NOTE: one-way-binding
        attributeDisplayed: '<',
        // attribute-used:
        //  name of the attribute picked by the dropdown (ie: name of the component, login of user)
        //  if undefined, the entire object is put in scope.ngModel
        //  NOTE: one-way-binding
        attributeUsed: '<?',
        // This value is used only to search for an element in the list 
        // when no specific attribute (attributeUsed) is provided.
        // In some cases, when a JSON object is being searched in the list, 
        // it must match exactly (strict equality) to be found.
        compareValue: '<?',
        ngDisabled: '=?', // normal ng-disabled behavior
        // on-change: is called when data change
        // exemple-> on-change="myfunction(myparam)"
        onChange: '&?',
        // enclosing-character:
        //  when ng-model is a string it adds enclosing charater to it
        //  if your enclosing-character is "'" then the ng-model will be "'myvalue'" instead of "myvalue"
        //  this behavior doen't break the data-binding on ng-model !
        //  enclosing-character will be added even if ng-model is null or undefined
        //  NOTE: one-way-binding
        enclosingCharacter: '<?'
      },
      /**
       * scope.selectedAutocomplete contient l'objet selectionné
       * si scope.attributeUsed est undefined alors scope.ngModel contient aussi l'objet selectonné
       * sinon scope.ngModel contient seulement l'attribut voulu (attributeUsed)
       */
      link: function(scope) {

        /**
         * autopick object corresponding to selected value
         * this is used to keep two-way-binding on scope.ngModel
         * (if we modify scope.ngModel from the outside scope.selectedAutocomplete.selected
         *    will be correct and the dropdown too)
         */
        const initDirective = () => {
          fillValueFromOutside();
        };

        const fillValueFromOutside = () => {
          if (!scope.selectedAutocomplete) {
            scope.selectedAutocomplete = {};
          }
          if (Array.isArray(scope.list)) {
            const ngModelWithoutEnclosingCharacter = unformatString(scope.ngModel);
            let selectedValue = null;
            
            if (ngModelWithoutEnclosingCharacter) {
              const compareKey = scope.attributeUsed || scope.compareValue;
            
              selectedValue = scope.list.find(element => {
                const elementValue = compareKey ? element[compareKey] : element;
                return elementValue === (scope.compareValue 
                  ? ngModelWithoutEnclosingCharacter[scope.compareValue] 
                  : ngModelWithoutEnclosingCharacter);
              });
            }
            scope.selectedAutocomplete.selected = selectedValue;
          } else {
            scope.selectedAutocomplete.selected = null;
          }
        };

        /**
         * create a filter for the ui-select-choices
         * @param {String} searchString
         * @returns json search pattern
         */
        scope.getSearchFilter = (searchString) => {
          if (scope.attributeDisplayed) {
            let searchFilter = {};
            searchFilter[scope.attributeDisplayed] = searchString;
            return searchFilter;
          } else {
            return searchString;
          }
        };

        scope.getDisplayedName = (object) => {
          return (object && scope.attributeDisplayed) ? object[scope.attributeDisplayed] : object;
        };

        /**
         * keep track of the content of ngModel
         */
        scope.$watch('ngModel', () => {
          fillValueFromOutside();
        });
        /**
         * when list is updated we re-select the value
         */
        scope.$watch('list', () => {
          fillValueFromOutside();
        });

        /**
         * Assigne l'élément de la liste cliqué comme élement sélectionné présent dans l'input
         * @param x objet élément de la liste du dropdown (ex. utilisateur, rôle, groupe)
         */
        scope.selectFromAutocomplete = (x) => {
          if (scope.attributeUsed && x.selected) {
            scope.ngModel = formatString(x.selected[scope.attributeUsed]);
          } else {
            scope.ngModel = formatString(x.selected);
          }
          if (typeof scope.onChange === 'function') {
            // call the function on next $apply to make
            // sure the ng-model has been updated
            $timeout(scope.onChange);
          }
        };

        /**
         * add enclosing character to ng-model
         */
        const formatString = (selectedobject) => {
          if (scope.enclosingCharacter && (typeof selectedobject==='string' || selectedobject == undefined )) {
            // put an empty string instead of null or undefined
            selectedobject = selectedobject ? selectedobject : '';
            return scope.enclosingCharacter + selectedobject + scope.enclosingCharacter;
          } else {
            return selectedobject;
          }
        };

        /**
         * remove enclosing character from ng-model
         */
        const unformatString = (selectedobject) => {
          if (scope.enclosingCharacter && typeof selectedobject==='string') {
            return selectedobject.slice(1, selectedobject.length-1);
          } else {
            return selectedobject;
          }
        };

        //init directve when all methods are loaded
        initDirective();
      },
    };
  };

  gccomponent.$inject = [
    '$timeout',
  ];
  return gccomponent;
});
