'use strict';
define(function() {
  /*
        Import data into existing feature
     */
  var gcimportfeatures = function(FeatureTypeFactory, DataStoreFactory, RightsFactory, $timeout, $filter, $rootScope) {
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gcimportfeatures.html',
      restrict: 'EA',
      scope: {
        liaisons: '=res', // result
        sources: '=', // array of column names
        sourceFti: '=?', // fti source
        maj: '=?',
        name: '=?',
        submitFunction: '&?',
        ftid: '=?', // destination
        dateattributes: '=?',
        editable: '=?', // whether you can change the ftid,
        allowDefaultValues: '<?', // allow default values for destinations fields
        // true : can set default value for every destination
        //{key1:true,key2:true} can set default value only for attr named key1 and key2
        defaultValues: '=?', // actual default values
        applyRules: '=?', // boolean: true if business rules should be applied
        deleteSourceLayer: '=?', // boolean: true if business rules should be applied
        features: '=?', // source dont on veut mapper les propriétés
        doVerification: '=?',
        isCsv: '=?',  // est true si le composant parent est importdiverswidget
        hasFtiListFilter: '=?', // true si ftiListFilter est initialisé,
        // il faut cette propriété, car même si aucune
        // fonction n'est affecté à ftiListFilter,
        // vu que dans le HTML, il y a
        // [fti-list-filter: "ftiListFilter],
        // une fonction ftiListFilter est
        // instanciée ....
        ftiListFilter: '&?', // fonction de filtrage des ftis. Permet de ne pas
        // afficher tout les ftis dans la liste destination
        associations: '=?', // si la liste n'est pas vide l'import doit
        // transférer les associations du source vers la destination
        allAssociations: '=?', // toutes les associations disponibles
        showDeleteMasterLayerData: '=?', // Affiche/masque la case à cocher "suppression des données de la couche mère" (uniquement affiché pour le transfert de couche)
        fieldsApplyCurrentDate: '=?',
        transferSuccessful: '=?',
        downloadJournal: '&?', // fonction de téléchargement du journal
      },

      link: function(scope, elt) {
        const TYPE_INT = 'java.lang.Integer';
        const TYPE_LONG = 'java.lang.Long';
        const TYPE_STRING = 'java.lang.String';
        const TYPE_DOUBLE = 'java.lang.Double';
        const TYPE_DATE = 'java.util.Date';
        const TYPE_TIMESTAMP = 'java.sql.Timestamp';
        const ATTACHMENT_TYPE = 'g2c.attachment';
        const ATTACHMENTS_TYPE = 'g2c.attachments';
        const initDirective = () => {
          scope.selectedSource = {};
          scope.selectSourceAttribute(scope.sources[0]);
          if (!scope.liaisons) {
            scope.liaisons = {};
          }
          scope.usedAttributes = {};
          scope.setToDefault = {};
          scope.canSubmit = false;
          scope.importFeature = {};
          scope.selectedAttribute = {};

          FeatureTypeFactory.get().then(featureTypes => {
            // RightsFactory.isAllowedToReadOrWriteFeatureType: garde le fti
            // si l'utilisateur a un droit en écriture dessus
            const user = $rootScope.xgos ? $rootScope.xgos.user : null;
            const isAdmin = $rootScope.xgos && ($rootScope.xgos.isroot || $rootScope.xgos.isadmin);
            const ftis = featureTypes.filter(
              fti => RightsFactory.isAllowedToReadOrWriteFeatureType(
                fti, isAdmin, user));

            if (scope.hasFtiListFilter
              && typeof scope.ftiListFilter === 'function') {
              scope.filteredComponentsList = ftis.filter(scope.ftiListFilter);
            }
            else {
              scope.filteredComponentsList = ftis;
            }
          });

          if (scope.ftid) {
            if (!FeatureTypeFactory.resources.featuretypes.length) {
              FeatureTypeFactory.get().then(() => {
                scope.importFeature.fti = FeatureTypeFactory.getFeatureByUid(
                  scope.ftid
                );
                if (scope.isCsv){
                  updateDateAttributes();
                }
              });
            } else {
              scope.importFeature.fti = FeatureTypeFactory.getFeatureByUid(
                scope.ftid
              );
              if (scope.isCsv){
                updateDateAttributes();
              }
            }

            /* load existing cfg if any */
            if (angular.isDefined(scope.liaisons)) {
              for (var i in scope.liaisons) {
                scope.usedAttributes[scope.liaisons[i]] = true;
                scope.canSubmit = true;
              }
            } else {
              scope.resetLiaisons();
            }
          }

          scope.ftis = FeatureTypeFactory.resources.featuretypes;
          scope.$watch('ftid', () => scope.importFeature.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid));

          // reset when the fti changes
          scope.$watch('importFeature.fti', function(fti, prevfti) {
            if (scope.isCsv){
              const attFId = {
                name: 'fid',
                alias: 'fid',
              };
              if (fti && fti.attributes) {
                const tab = fti.attributes.map(attr=>attr.name);
                if (!tab.includes('fid')) {
                  fti.attributes.push(attFId);
                }
              }
            }
            if (fti) {
              scope.ftiPrimaryKey = fti.primaryKey ? fti.primaryKey : undefined;
              scope.ftiEsriIdField = fti.esriIdField ? fti.esriIdField : undefined;
              if (fti.attributes) {
                scope.ftid = fti.uid;
                checkAssociationMapping();
              }
            }
            console.log(fti);
            console.log(prevfti);
            if (angular.isDefined(fti) && angular.isDefined(prevfti)) {
              if (fti !== prevfti) {
                scope.resetLiaisons();
              }
            }
            if (scope.isCsv){
              updateDateAttributes();
            }
          });

          // KIS-3179: empêche le contenu de dépasser la largeur de la popup
          if (elt && elt[0]) {
            const directiveTemplate = elt[0];
            if (directiveTemplate) {
              const contentTemplate = directiveTemplate.closest('.contentTemplate');
              if (contentTemplate) {
                contentTemplate.style.width = '100%';
              }
            }
          }
        };

        /**
         * cette fonction verifie qu'il y a vraiment une correspondance entre
         * les associations du source et les associations du destination
         */
        let checkAssociationMapping = () => {
          scope.showAlertAsso = false;
          if(Array.isArray(scope.associations) && scope.associations.length>0 && Array.isArray(scope.allAssociations)){
            scope.showAlertAsso = true;
            scope.associations.forEach(asso => {
              let assoSource = scope.allAssociations.find(ass => ass.ID === asso.ID);
              let assoSourceOtherField =  assoSource.atable === scope.sourceFti.name?
                assoSource.btable:assoSource.atable;
              let assoDest = scope.allAssociations.find(
                ass => (ass.atable === scope.importFeature.fti.name &&
                  ass.btable === assoSourceOtherField) ||
                  (ass.btable === scope.importFeature.fti.name &&
                  ass.atable === assoSourceOtherField) &&
                  assoSource.type_patrimoine === ass.type_patrimoine);
              if(angular.isDefined(assoDest)){
                scope.showAlertAsso = false;
              }
            });
          }
        };
        /**
         * resetLiaisons
         */
        scope.resetLiaisons = function() {
          scope.selectedSource = { idx: scope.sources[0] };
          scope.liaisons = {};
          scope.usedAttributes = {};
          scope.setToDefault = {};
          scope.canSubmit = false;
        };


        /**
         * checkDestination
         * @param attr
         */
        scope.checkDestination = function(attr) {
          var previousAttr;

          if (
            scope.isCsv &&
              scope.maj &&
              scope.maj.maj_component &&
              scope.maj.value &&
              scope.maj.value.name &&
              attr.name === scope.maj.value.name
          ){
            return ;
          }

          // if has default value
          //if(scope.allowDefaultValues==true || scope.defaultValues[attr.name]){
          if (
            scope.allowDefaultValues == true &&
            scope.defaultValues &&
            scope.defaultValues[attr.name]
          ) {
            //delete scope.defaultValues[attr.name];
            scope.setToDefault[attr.name] = false;
          }

          // if already used for another source
          if (scope.usedAttributes[attr.name]) {
            if (scope.liaisons[scope.selectedSource.idx] !== attr.name) {
              return false;
            }
          }

          if (angular.isDefined(scope.liaisons[scope.selectedSource.idx])) {
            previousAttr = scope.liaisons[scope.selectedSource.idx];
            delete scope.liaisons[scope.selectedSource.idx];
            scope.usedAttributes[previousAttr] = false;
          }

          if (previousAttr != attr.name) {
            scope.liaisons[scope.selectedSource.idx] = attr.name;
            scope.usedAttributes[attr.name] = true;
          }

          scope.canSubmit = Object.keys(scope.liaisons).length;
        };

        /**
         * activateDefaultValues
         * @param attr
         */
        scope.activateDefaultValues = function(attr, event) {
          event.stopPropagation();
          /*if(scope.usedAttributes[attr.name]==true){
                        scope.usedAttributes[attr.name] = false;
                        delete scope.liaisons[scope.selectedSource.idx];
                    }*/
          scope.setToDefault[attr.name] = true;
        };

        /**
         * Exécute la vérification de la longueur des champ
         * Exécute la méthode de soumission du composant parent
         */
        scope.submitLiaisons = () => {
          if (scope.liaisons && scope.importFeature && scope.importFeature.fti) {
            // Vérifie la longueur des champs
            if (scope.sourceFti) {
              //-- Cas du tansfert de couche (transferLayerWidget)
              // cropValuesOverLengthLimit(attributeMap, scope.liaisons, scope.features, scope.importFeature.fti)
              isValuesUnderLengthLimitLayerTransfer(scope.liaisons, scope.sourceFti, scope.importFeature.fti);
            } else {
              //-- Cas des imports de fichier (shape, dxf, csv)
              $timeout(() => {
                if (scope.importFeature.fti.attributes.length === 0) {
                  //-- Cas d'un composant sans champ (en import d'un dxf,
                  //-- on ne récupére pas d'attribut et ça pourrait
                  //-- correspondre à un composant KIS sans attribut
                  //-- lui non plus)
                  callSubmitFunctionIfAny();
                }
                else {
                  //-- Appel api pour récupérer la longueur maximale autorisée
                  //-- des champs de la table
                  DataStoreFactory.getTableColumnsLength(scope.importFeature.fti.storeName, scope.importFeature.fti.name).then(
                    (res) => {
                      if (res && res.data) {

                        const attributeMap = res.data;

                        // Vérifie la longueur des champs
                        if (isValuesUnderLengthLimitDxf(attributeMap, scope.liaisons, scope.features, scope.importFeature.fti)) {
                          callSubmitFunctionIfAny();
                        }
                      }
                    },
                    () => {
                      require('toastr').error(
                        $filter('translate')('model.featuretypes.import.fieldslengtherror'));
                    });
                }
              });
            }
          }
        };

        scope.cancelLiaisons = function() {
          scope.cancelFunction();
        };

        /**
         * Vérifie que les types sont compatibles
         * @returns {boolean}
         */
        const typesAreCompatible = (attribute1Name, attribute2) => {
          // si on a pas de feature source (exp import csv)
          // pas besoin de verifier la compatibilité
          if(!scope.sourceFti){
            return true;
          }
          const attribute1 = scope.sourceFti.attributes.find(attribute => attribute.name === attribute1Name);
          if (getUnderlyingType(attribute1.type) === getUnderlyingType(attribute2.type)) {
            return true;
          } else {
            switch (attribute1.type) {
              case TYPE_INT:
                // can be a int, long, double or String
                return [TYPE_LONG,TYPE_DOUBLE,TYPE_STRING].includes(attribute2.type);
              case TYPE_LONG:
                // can be a long, double or String
                return [TYPE_DOUBLE,TYPE_STRING].includes(attribute2.type);
              case TYPE_DOUBLE:
              case TYPE_DATE:
              case TYPE_TIMESTAMP:
                return attribute2.type === TYPE_STRING;
              default: return false;
            }
          }
        }

        /**
         * Mappage automatique des champs basé sur la correspondance des noms
         * @param sources propriétés du geojson source
         * @param tab tableau des attributs du fti cible
         */
        scope.allAutomaticMap = function(sources, tab) {
          sources.forEach(function(source) {
            if (source !== 'fid' && (!scope.maj || !scope.maj.attribut || source !== scope.maj.attribut)) {
              scope.selectedSource.idx = source;
              for (let i = 0; i < tab.length; i++) {
                if (
                    (tab[i].name.toLowerCase() === source.toLowerCase() ||
                    (tab[i].name.substr(0, 10).toLowerCase() ===
                        source.toLowerCase()))
                    && typesAreCompatible(source, tab[i])
                ) {
                  let attmap = tab[i];
                  scope.checkDestination(attmap);
                }
              }
            }
          });
        };

        /**
         * Vérifie le respect de la taille autorisée des champs de la table vers lesquels sont mappées les attributs des features de la layer d'import
         * @param attributeMap map de la table cible: nom_champ_table -> longueur_champ_table
         * @param liaisons objet contenant les mappages entre feature source et table cible: nom_attr_feature -> nom_champ_table
         * @param features objets de la layer d'import
         * @param fti featuretypeinfo du composant cible
         * @return {boolean} false si la vérification est arrêtée, true si la vérification s'est poursuivie jusqu'au bout.
         * @see submitLiaisons
         */
        function isValuesUnderLengthLimitDxf(attributeMap, liaisons, features, fti) {
          for (const feature of features){
            for (const [source, target] of Object.entries(liaisons)){

              if (feature.properties.hasOwnProperty(source) && attributeMap.hasOwnProperty(target) && feature.properties[source] !== null) {

                // longueur de la propriété mappée de la feature
                const sourceLength = feature.properties[source].length;

                // longueur maximale du champ cible du fti
                const targetLength = attributeMap[target];

                if ((targetLength < sourceLength) && (targetLength !== -1)) {
                  // si la case avait été cochée alors on tronque la propriété à la longueur du champ
                  if (scope.neverAskAgain){
                    feature.properties[source] = feature.properties[source].substring(0,targetLength);
                  }else{
                    // sinon on affiche l'alerte
                    const alias = fti.attributes.filter(att=>att.name===target).map(att=>att.alias)[0];
                    return displayAlertDxf(alias);
                  }
                }
              }
            }
          }
          return true;
        }

        /**
         * Vérifie le respect de la taille autorisée des champs de la table vers lesquels sont mappées les attributs des features de la layer d'import. On se base sur les longueurs dans les fti source et destination.
         * @param liaisons objet contenant les mappages entre feature source et table cible: nom_attr_feature -> nom_champ_table
         * @param sourceFti
         * @param destinationFti
         * @see submitLiaisons
         */
        const isValuesUnderLengthLimitLayerTransfer = (liaisons, sourceFti, destinationFti)  => {
          let aliases = [];
          if (sourceFti.attributes) {
            for (const [source, target] of Object.entries(liaisons)) {
              const sourceAttribute = sourceFti.attributes.find(attribute => attribute.name === source);
              const destinationAttribute = destinationFti.attributes.find(attribute => attribute.name === target);

              if (sourceAttribute && destinationAttribute) {

                if ((destinationAttribute.size < sourceAttribute.size) && (destinationAttribute.size !== -1)) {
                  // on affiche l'alerte
                  aliases.push(destinationAttribute.alias);
                }
              }
            }
          }
          if (aliases.length > 0) {
            displayLengthWarning(aliases);
          } else {
            callSubmitFunctionIfAny();
          }


          return true;
        };


        /**
         * Affiche une alerte quand la longueur d'une propriété est plus grande que la valeur du champ cible de la table
         * Relance la soumission si l'utilisateur a décidé de continuer (isConfirm=true) et de tronquer les champs
         * @param alias alias de l'attribut du fti
         * @return {boolean} false dans tous les cas pour terminer la fonction parent
         * @see isValuesUnderLengthLimit
         */
        function displayAlertDxf(alias) {
          const text = $filter('translate')('model.featuretypes.attributes.valueerrorpart1') + alias
              + $filter('translate')('model.featuretypes.attributes.valueerrorpart2');
          swal({
            title: $filter('translate')('model.featuretypes.attributes.mappingerror'),
            text: text,
            type: 'error',
            showCancelButton: true,
            confirmButtonColor: '#5cb85c',
            confirmButtonText: $filter('translate')('model.featuretypes.attributes.continue'),
            cancelButtonText: $filter('translate')('model.featuretypes.attributes.stop'),
            closeOnConfirm: true,
            closeOnCancel: true,
          }, function (onConfirm) {
            if (onConfirm) {
              // si oui, on tronque la propriété et on continue la vérification
              $('.sweet-alert').removeClass('sweet-alert-custom');
              scope.neverAskAgain = true;
              scope.submitLiaisons();
            } else {
              // si non, arrêt de la vérification et on renvoie false pour ne pas démarrer la sauvegarde
              $('.sweet-alert').removeClass('sweet-alert-custom');
              return false;
            }
          });
          return false;

          $('.sweet-alert').addClass('sweet-alert-custom');

          /** ajout d'une case à cocher dans le sweet-alert **/
          /* const neverAskMessage = $filter('translate')(
              'model.featuretypes.attributes.cancelorcontinue');
          const div = '<div class="import-resume-process"><input id="neveraskagain" type="checkbox"/><label for="neveraskagain">'
              + neverAskMessage + '</label></div>';
          $('.sweet-alert-custom p').after(div);
          $('#neveraskagain').change(function () {
            scope.neverAskAgain = $(this).is(':checked');
          });*/
        }

        /**
         * Affiche une alerte quand la longueur d'une propriété est plus grande que la valeur du champ cible de la table
         * Relance la soumission si l'utilisateur a décidé de continuer (isConfirm=true) et de tronquer les champs
         * @param aliases les alias des attributs concernés
         * @see isValuesUnderLengthLimit
         */
        function displayLengthWarning(aliases) {
          const text = $filter('translate')('model.featuretypes.attributes.values_too_long') + '\n' + aliases.join(', ');
          swal({
            title: $filter('translate')('model.featuretypes.attributes.mappingerror'),
            text: text,
            type: 'error',
            showCancelButton: true,
            confirmButtonColor: '#5cb85c',
            confirmButtonText: $filter('translate')('model.featuretypes.attributes.continue'),
            cancelButtonText: $filter('translate')('model.featuretypes.attributes.stop'),
            closeOnConfirm: true,
            closeOnCancel: true,
          }, (onConfirm) => {
            if (onConfirm) {
              // si oui, on tronque la propriété et on continue la vérification
              $('.sweet-alert').removeClass('sweet-alert-custom');
              callSubmitFunctionIfAny();
            } else {
              // si non, arrêt de la vérification et on renvoie false pour ne pas démarrer la sauvegarde
              $('.sweet-alert').removeClass('sweet-alert-custom');
            }
          });
          $('.sweet-alert').addClass('sweet-alert-custom');
        }

        const callSubmitFunctionIfAny = () => {
          if (typeof scope.submitFunction === 'function') {
            scope.submitFunction();
          }
        };

        /*  SPECIFIQUE CSV */

        if (typeof scope.maj !== 'object') {
          scope.maj = {
            maj_component: false,
            attribut: undefined,
            value: undefined,
          };
        }
        if (scope.applyRules == undefined || scope.applyRules.value == undefined) {
          scope.applyRules = { value: false};
        }
        if (!scope.deleteSourceLayer || !scope.deleteSourceLayer.value ) {
          scope.deleteSourceLayer = { value: false};
        }

        const datetypes = [
          'java.lang.Date',
          'java.util.Date',
          'java.sql.Timestamp',
        ];

        let updateDateAttributes = () => {
          if (
            scope.importFeature &&
              scope.importFeature.fti &&
              scope.importFeature.fti.attributes
          )
            scope.dateattributes = scope.importFeature.fti.attributes
              .filter(attr => attr && datetypes.indexOf(attr.type) !== -1)
              .map(attr => attr.name);
        };

        scope.selectSourceAttribute = selectedAttributeName => {
          scope.selectedSource.idx = selectedAttributeName;
          if (scope.sourceFti && Array.isArray(scope.sourceFti.attributes)) {
            scope.selectedAttribute = scope.sourceFti.attributes.find(sourceAttribute => sourceAttribute.name === selectedAttributeName);
          }
        };

        const getUnderlyingType = (type) => {
          // attachement and attachements should be considered as String
          switch(type) {
            case ATTACHMENT_TYPE:
            case ATTACHMENTS_TYPE:
              return TYPE_STRING;
            default: return type;
          }
        };

        /**
         * Affiche l'attribut de destination seulement si il est compatible avec
         *  le type de l'attribut source.
         * Un champs est compatible avec un champs du même type, plus quelques cas spécifiques:
         * int -> int, long, double or String
         * long -> long, double or String
         * double -> long, double or String
         * date -> Date or String
         * timestamp -> Timestamp or String
         * @param {object} destinationAttribute l'attribut de destination
         * @returns
         */
        scope.isTypeCompatible = destinationAttribute => {

          if (scope.selectedAttribute && scope.selectedAttribute.type) {
            if ((scope.ftiPrimaryKey && scope.ftiPrimaryKey === destinationAttribute.name)
              || (scope.ftiEsriIdField && scope.ftiEsriIdField === destinationAttribute.name)) {
              // Les attributs correspondants aux propriétées PrimaryKey et
              // esriIdField ne doivent pas apparaitre dans la liste des champs destination.
              return false;
            } else {
              // show only compatible types
              if (getUnderlyingType(destinationAttribute.type) == getUnderlyingType(scope.selectedAttribute.type)) {
                return true;
              } else {
                switch (scope.selectedAttribute.type) {
                  case TYPE_INT:
                    // can be a int, long, double or String
                    return [TYPE_LONG,TYPE_DOUBLE,TYPE_STRING].includes(destinationAttribute.type);
                  case TYPE_LONG:
                    // can be a long, double or String
                    return [TYPE_DOUBLE,TYPE_STRING].includes(destinationAttribute.type);
                  case TYPE_DOUBLE:
                  case TYPE_DATE:
                  case TYPE_TIMESTAMP:
                    return destinationAttribute.type === TYPE_STRING;
                  default: return false;
                }
              }
            }
          } else {
            return true;
          }
        };

        //// Init directive
        initDirective();
      },
    };
  };

  gcimportfeatures.$inject = ['FeatureTypeFactory', 'DataStoreFactory', 'RightsFactory', '$timeout', '$filter', '$rootScope'];
  return gcimportfeatures;
});